/*
 * Decompiled with CFR 0.152.
 */
package ai.rewardfunction;

import ai.rewardfunction.AttackRewardFunction;
import ai.rewardfunction.CloserToEnemyBaseRewardFunction;
import ai.rewardfunction.ProduceBuildingRewardFunction;
import ai.rewardfunction.ProduceCombatUnitRewardFunction;
import ai.rewardfunction.ProduceWorkerRewardFunction;
import ai.rewardfunction.ResourceGatherRewardFunction;
import ai.rewardfunction.RewardFunctionInterface;
import ai.rewardfunction.WinLossRewardFunction;
import rts.GameState;
import rts.TraceEntry;

public class CombinedRewardFunction
extends RewardFunctionInterface {
    public double factorAttack = 0.4;
    public double factorCloserToEnemyBase = 0.05;
    public double factorProduceBuilding = 1.0;
    public double factorProduceCombatUnit = 0.5;
    public double factorProduceWorker = 0.1;
    public double factorResourceGather = 0.1;
    public double factorWinLoss = 5.0;
    public RewardFunctionInterface attackR;
    public RewardFunctionInterface closerToEnemyBaseR;
    public RewardFunctionInterface produceBuildingR;
    public RewardFunctionInterface produceCombatUnitR;
    public RewardFunctionInterface produceWorkerR;
    public RewardFunctionInterface resourceGatherR;
    public RewardFunctionInterface winLossR;

    public CombinedRewardFunction(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        this.factorAttack = d;
        this.factorCloserToEnemyBase = d2;
        this.factorProduceBuilding = d3;
        this.factorProduceCombatUnit = d4;
        this.factorProduceWorker = d5;
        this.factorResourceGather = d6;
        this.factorWinLoss = d7;
        this.attackR = new AttackRewardFunction();
        this.closerToEnemyBaseR = new CloserToEnemyBaseRewardFunction();
        this.produceBuildingR = new ProduceBuildingRewardFunction();
        this.produceCombatUnitR = new ProduceCombatUnitRewardFunction();
        this.produceWorkerR = new ProduceWorkerRewardFunction();
        this.resourceGatherR = new ResourceGatherRewardFunction();
        this.winLossR = new WinLossRewardFunction();
    }

    @Override
    public void computeReward(int n, int n2, TraceEntry traceEntry, GameState gameState) {
        this.reward = 0.0;
        this.done = false;
        this.attackR.computeReward(n, n2, traceEntry, gameState);
        this.closerToEnemyBaseR.computeReward(n, n2, traceEntry, gameState);
        this.produceBuildingR.computeReward(n, n2, traceEntry, gameState);
        this.produceCombatUnitR.computeReward(n, n2, traceEntry, gameState);
        this.produceWorkerR.computeReward(n, n2, traceEntry, gameState);
        this.resourceGatherR.computeReward(n, n2, traceEntry, gameState);
        this.winLossR.computeReward(n, n2, traceEntry, gameState);
        this.done = this.winLossR.isDone();
        this.reward = this.factorAttack * this.attackR.getReward() + this.factorCloserToEnemyBase * this.closerToEnemyBaseR.getReward() + this.factorProduceBuilding * this.produceBuildingR.getReward() + this.factorProduceCombatUnit * this.produceCombatUnitR.getReward() + this.factorProduceWorker * this.produceWorkerR.getReward() + this.factorResourceGather * this.resourceGatherR.getReward() + this.factorWinLoss * this.winLossR.getReward();
    }

    @Override
    public double getReward() {
        return this.reward;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }
}

