/*
 * Decompiled with CFR 0.152.
 */
package ai.rewardfunction;

import ai.rewardfunction.RewardFunctionInterface;
import rts.GameState;
import rts.PhysicalGameState;
import rts.TraceEntry;
import rts.UnitAction;
import rts.units.Unit;
import util.Pair;

public class ResourceGatherRewardFunction
extends RewardFunctionInterface {
    public static float RESOURCE_RETURN_REWARD = 1.0f;
    public static float RESOURCE_HARVEST_REWARD = 1.0f;

    @Override
    public void computeReward(int n, int n2, TraceEntry traceEntry, GameState gameState) {
        this.reward = 0.0;
        for (Pair<Unit, UnitAction> object : traceEntry.getActions()) {
            if (((Unit)object.m_a).getPlayer() == n && ((UnitAction)object.m_b).getType() == 2) {
                this.reward += (double)RESOURCE_HARVEST_REWARD;
                continue;
            }
            if (((Unit)object.m_a).getPlayer() != n || ((UnitAction)object.m_b).getType() != 3) continue;
            this.reward += (double)RESOURCE_RETURN_REWARD;
        }
        this.done = true;
        PhysicalGameState physicalGameState = gameState.getPhysicalGameState();
        for (Unit unit : physicalGameState.getUnits()) {
            if (!unit.getType().name.equals("Resource") || unit.getResources() <= 0) continue;
            this.done = false;
            return;
        }
    }

    @Override
    public double getReward() {
        return this.reward;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }
}

