/*
 * Decompiled with CFR 0.152.
 */
package ai.scv;

import ai.RandomBiasedAI;
import ai.abstraction.EconomyMilitaryRush;
import ai.abstraction.EconomyRush;
import ai.abstraction.HeavyDefense;
import ai.abstraction.LightDefense;
import ai.abstraction.LightRush;
import ai.abstraction.RangedDefense;
import ai.abstraction.RangedRush;
import ai.abstraction.WorkerDefense;
import ai.abstraction.WorkerRush;
import ai.abstraction.WorkerRushPlusPlus;
import ai.abstraction.partialobservability.POHeavyRush;
import ai.abstraction.partialobservability.POLightRush;
import ai.abstraction.partialobservability.PORangedRush;
import ai.abstraction.partialobservability.POWorkerRush;
import ai.abstraction.pathfinding.AStarPathFinding;
import ai.core.AI;
import ai.core.AIWithComputationBudget;
import ai.core.ParameterSpecification;
import ai.evaluation.SimpleSqrtEvaluationFunction3;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import rts.GameState;
import rts.PhysicalGameState;
import rts.Player;
import rts.PlayerAction;
import rts.UnitAction;
import rts.units.Unit;
import rts.units.UnitTypeTable;
import util.Pair;
import weka.classifiers.functions.SimpleLogistic;
import weka.core.DenseInstance;
import weka.core.Instances;
import weka.core.SerializationHelper;
import weka.core.converters.ConverterUtils;

public class SCV
extends AIWithComputationBudget {
    AI[] strategies = null;
    int playerForThisComputation;
    GameState gs_to_start_from = null;
    SimpleLogistic rf = null;
    UnitTypeTable localUtt = null;
    Instances dataSet = null;
    long tempoInicial = 0L;
    HashMap<String, HashMap<Integer, List<infBattles>>> indice = null;
    int heightMap;

    public SCV(UnitTypeTable unitTypeTable) {
        this(new AI[]{new WorkerRush(unitTypeTable), new LightRush(unitTypeTable), new RangedRush(unitTypeTable), new RandomBiasedAI()}, 100, -1, unitTypeTable);
    }

    public SCV(AI[] aIArray, int n, int n2, UnitTypeTable unitTypeTable) {
        super(n, n2);
        this.strategies = aIArray;
        this.localUtt = unitTypeTable;
        this.indice = new HashMap();
    }

    @Override
    public void reset() {
    }

    @Override
    public PlayerAction getAction(int n, GameState gameState) throws Exception {
        this.tempoInicial = System.currentTimeMillis();
        if (this.rf == null) {
            this.heightMap = gameState.getPhysicalGameState().getHeight();
            this.loadModel();
            this.loadLtd3Battles();
        }
        this.tryClassify(n, gameState);
        if (gameState.canExecuteAnyAction(n)) {
            this.startNewComputation(n, gameState);
            return this.getBestActionSoFar();
        }
        return new PlayerAction();
    }

    protected void loadLtd3Battles() {
        ArrayList<infBattles> arrayList = new ArrayList<infBattles>();
        try {
            BufferedReader bufferedReader;
            switch (this.heightMap) {
                case 8: {
                    bufferedReader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("models/ltdsFinais8.csv")));
                    break;
                }
                case 9: {
                    bufferedReader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("models/ltdsFinais9.csv")));
                    break;
                }
                case 16: {
                    bufferedReader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("models/ltdsFinais16.csv")));
                    break;
                }
                case 24: {
                    bufferedReader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("models/ltdsFinais24.csv")));
                    break;
                }
                case 32: {
                    bufferedReader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("models/ltdsFinais32.csv")));
                    break;
                }
                case 64: {
                    bufferedReader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("models/ltdsFinais64.csv")));
                    break;
                }
                default: {
                    bufferedReader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("models/ltdsFinaisSCV.csv")));
                }
            }
            String string = bufferedReader.readLine();
            while (string != null) {
                infBattles infBattles2 = new infBattles();
                String[] stringArray = string.split(";");
                infBattles2.ltd3 = Double.valueOf(stringArray[0]);
                infBattles2.tMapa = Integer.decode(stringArray[1]);
                infBattles2.enemy = stringArray[2];
                infBattles2.strategy = stringArray[3];
                arrayList.add(infBattles2);
                string = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            System.err.printf("Erro na abertura do arquivo: %s.\n", exception.getMessage());
            System.out.println(exception.toString());
        }
        this.buildIndice(arrayList);
    }

    protected void buildIndice(ArrayList<infBattles> arrayList) {
        int n = 0;
        for (infBattles infBattles2 : arrayList) {
            ArrayList<infBattles> arrayList2;
            HashMap<Object, Object> hashMap;
            ++n;
            if (this.indice.containsKey(infBattles2.strategy)) {
                hashMap = this.indice.get(infBattles2.strategy);
                if (!hashMap.containsKey(infBattles2.tMapa)) {
                    arrayList2 = new ArrayList();
                    arrayList2.add(infBattles2);
                    hashMap.put(infBattles2.tMapa, arrayList2);
                    continue;
                }
                ((List)hashMap.get(infBattles2.tMapa)).add(infBattles2);
                continue;
            }
            hashMap = new HashMap();
            arrayList2 = new ArrayList<infBattles>();
            arrayList2.add(infBattles2);
            hashMap.put(infBattles2.tMapa, arrayList2);
            this.indice.put(infBattles2.strategy, hashMap);
        }
    }

    public void startNewComputation(int n, GameState gameState) {
        this.playerForThisComputation = n;
        this.gs_to_start_from = gameState;
    }

    /*
     * WARNING - void declaration
     */
    public PlayerAction getBestActionSoFar() throws Exception {
        Iterator iterator;
        int n = this.strategies.length;
        AI[] aIArray = new AI[n];
        PlayerAction[] playerActionArray = new PlayerAction[n];
        ArrayList<TreeMap> arrayList = new ArrayList<TreeMap>();
        for (int j = 0; j < n; ++j) {
            aIArray[j] = this.strategies[j].clone();
            playerActionArray[j] = this.strategies[j].getAction(this.playerForThisComputation, this.gs_to_start_from);
        }
        PlayerAction playerAction = playerActionArray[0];
        for (PlayerAction object : playerActionArray) {
            iterator = new TreeMap();
            object.getActions().forEach(pair -> iterator.put(((Unit)pair.m_a).getID(), pair.m_b));
            arrayList.add((TreeMap)((Object)iterator));
        }
        PlayerAction playerAction2 = new PlayerAction();
        ArrayList arrayList2 = new ArrayList();
        TreeMap treeMap2 = new TreeMap(new Comparator<UnitAction>(){

            @Override
            public int compare(UnitAction unitAction, UnitAction unitAction2) {
                if (unitAction.equals(unitAction2)) {
                    return 0;
                }
                return 1;
            }
        });
        while (!((TreeMap)arrayList.get(0)).isEmpty()) {
            void var9_15;
            arrayList.forEach(treeMap -> arrayList2.add(treeMap.get(treeMap.firstKey())));
            Object var9_14 = null;
            for (Pair pair2 : playerAction.getActions()) {
                if (((Unit)pair2.m_a).getID() != ((Long)((TreeMap)arrayList.get(0)).firstKey()).longValue()) continue;
                Unit unit = (Unit)pair2.m_a;
            }
            arrayList.forEach(treeMap -> treeMap.remove(treeMap.firstKey()));
            arrayList2.stream().map(unitAction -> {
                if (!treeMap2.containsKey(unitAction)) {
                    treeMap2.put((UnitAction)unitAction, 0);
                }
                return unitAction;
            }).forEachOrdered(unitAction -> treeMap2.put((UnitAction)unitAction, (Integer)treeMap2.get(unitAction) + 1));
            arrayList2.clear();
            iterator = treeMap2.entrySet().iterator();
            Map.Entry entry = iterator.next();
            Integer n2 = (Integer)entry.getValue();
            UnitAction unitAction2 = entry.getKey();
            iterator.remove();
            while (iterator.hasNext()) {
                Map.Entry entry2 = iterator.next();
                Integer n3 = (Integer)entry2.getValue();
                if (n3 > n2) {
                    unitAction2 = entry2.getKey();
                    n2 = n3;
                }
                iterator.remove();
            }
            playerAction2.addUnitAction((Unit)var9_15, unitAction2);
        }
        return playerAction2;
    }

    @Override
    public AI clone() {
        return new SCV(this.strategies, this.TIME_BUDGET, this.ITERATIONS_BUDGET, this.localUtt);
    }

    @Override
    public List<ParameterSpecification> getParameters() {
        ArrayList<ParameterSpecification> arrayList = new ArrayList<ParameterSpecification>();
        arrayList.add(new ParameterSpecification("TimeBudget", Integer.TYPE, 100));
        arrayList.add(new ParameterSpecification("IterationsBudget", Integer.TYPE, -1));
        return arrayList;
    }

    protected void loadModel() {
        this.dataSet = null;
        try {
            switch (this.heightMap) {
                case 8: {
                    this.rf = (SimpleLogistic)SerializationHelper.read(this.getClass().getResourceAsStream("models/SimpleLogisticSCV8.model"));
                    break;
                }
                case 9: {
                    this.rf = (SimpleLogistic)SerializationHelper.read(this.getClass().getResourceAsStream("models/SimpleLogisticSCV9.model"));
                    break;
                }
                case 16: {
                    this.rf = (SimpleLogistic)SerializationHelper.read(this.getClass().getResourceAsStream("models/SimpleLogisticSCV16.model"));
                    break;
                }
                case 24: {
                    this.rf = (SimpleLogistic)SerializationHelper.read(this.getClass().getResourceAsStream("models/SimpleLogisticSCV24.model"));
                    break;
                }
                case 32: {
                    this.rf = (SimpleLogistic)SerializationHelper.read(this.getClass().getResourceAsStream("models/SimpleLogisticSCV32.model"));
                    break;
                }
                case 64: {
                    this.rf = (SimpleLogistic)SerializationHelper.read(this.getClass().getResourceAsStream("models/SimpleLogisticSCV64.model"));
                    break;
                }
                default: {
                    this.rf = (SimpleLogistic)SerializationHelper.read(this.getClass().getResourceAsStream("models/SimpleLogisticSCV.model"));
                }
            }
            ConverterUtils.DataSource dataSource = new ConverterUtils.DataSource(this.getClass().getResourceAsStream("models/dadosEnemyDistModelTemplateSCV.arff"));
            this.dataSet = dataSource.getDataSet();
            this.dataSet.setClassIndex(this.dataSet.numAttributes() - 1);
            DenseInstance denseInstance = new DenseInstance(10);
            denseInstance.setDataset(this.dataSet);
            denseInstance.setValue(0, 0.0);
            denseInstance.setValue(1, 0.0);
            denseInstance.setValue(2, 0.0);
            denseInstance.setValue(3, 0.0);
            denseInstance.setValue(4, 0.0);
            denseInstance.setValue(5, 0.0);
            denseInstance.setValue(6, 0.0);
            denseInstance.setValue(7, 8.0);
            denseInstance.setValue(8, -1.0);
            double d = this.rf.classifyInstance(denseInstance);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logger.getLogger(SCV.class.getName()).log(Level.SEVERE, null, fileNotFoundException);
            System.out.println("Erro " + fileNotFoundException);
        }
        catch (Exception exception) {
            Logger.getLogger(SCV.class.getName()).log(Level.SEVERE, null, exception);
            System.out.println("Erro " + exception);
        }
    }

    protected void tryClassify(int n, GameState gameState) {
        int n2 = 0;
        if (n == 0) {
            n2 = 1;
        }
        if (gameState.getTime() % 1000 == 0 && gameState.getTime() != 0) {
            this.recordInfo(n2, n, gameState, gameState.getTime());
        } else if (gameState.getTime() == 0) {
            PhysicalGameState physicalGameState = gameState.getPhysicalGameState();
            this.strategies = physicalGameState.getHeight() == 8 ? new AI[]{new WorkerRushPlusPlus(this.localUtt), new WorkerDefense(this.localUtt)} : (physicalGameState.getHeight() == 16 ? new AI[]{new WorkerRushPlusPlus(this.localUtt)} : (physicalGameState.getHeight() == 24 ? new AI[]{new WorkerRushPlusPlus(this.localUtt), new WorkerDefense(this.localUtt), new LightDefense(this.localUtt)} : (physicalGameState.getHeight() == 32 ? new AI[]{new POLightRush(this.localUtt), new WorkerDefense(this.localUtt), new EconomyMilitaryRush(this.localUtt)} : (physicalGameState.getHeight() == 64 ? new AI[]{new POLightRush(this.localUtt), new EconomyMilitaryRush(this.localUtt), new WorkerDefense(this.localUtt)} : new AI[]{new EconomyMilitaryRush(this.localUtt)}))));
        }
    }

    private void recordInfo(int n, int n2, GameState gameState, int n3) {
        PhysicalGameState physicalGameState = gameState.getPhysicalGameState();
        Player player = gameState.getPlayer(n);
        Player player2 = gameState.getPlayer(n2);
        SimpleSqrtEvaluationFunction3 simpleSqrtEvaluationFunction3 = new SimpleSqrtEvaluationFunction3();
        Unit unit = null;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        for (Unit unit2 : physicalGameState.getUnits()) {
            if (unit2.getType().name.equals("Base") && unit2.getPlayer() == n2 && unit == null) {
                unit = unit2;
            }
            if (unit2.getType().name.equals("Base") && unit2.getPlayer() == n) {
                ++n5;
            }
            if (unit2.getType().name.equals("Barracks") && unit2.getPlayer() == n) {
                ++n6;
            }
            if (unit2.getType().name.equals("Worker") && unit2.getPlayer() == n) {
                ++n4;
            }
            if (unit2.getType().name.equals("Ranged") && unit2.getPlayer() == n) {
                ++n7;
            }
            if (unit2.getType().name.equals("Light") && unit2.getPlayer() == n) {
                ++n8;
            }
            if (!unit2.getType().name.equals("Heavy") || unit2.getPlayer() != n) continue;
            ++n9;
        }
        DenseInstance denseInstance = new DenseInstance(10);
        denseInstance.setDataset(this.dataSet);
        denseInstance.setValue(0, (double)n5);
        denseInstance.setValue(1, (double)n6);
        denseInstance.setValue(2, (double)n4);
        denseInstance.setValue(3, (double)n8);
        denseInstance.setValue(4, (double)n9);
        denseInstance.setValue(5, (double)n7);
        denseInstance.setValue(6, (double)gameState.getTime());
        denseInstance.setValue(7, (double)physicalGameState.getWidth());
        if (unit == null) {
            denseInstance.setValue(8, -1.0);
        } else {
            denseInstance.setValue(8, (double)this.distRealUnitEneBase(unit, player2, gameState));
        }
        try {
            this.setNewStrategy(this.getStrategyByDistribution(this.rf.distributionForInstance(denseInstance), physicalGameState.getHeight()));
        }
        catch (Exception exception) {
            Logger.getLogger(SCV.class.getName()).log(Level.SEVERE, null, exception);
            System.out.println("Erro na classifica\u00e7\u00e3o=" + exception);
        }
    }

    public int distRealUnitEneBase(Unit unit, Player player, GameState gameState) {
        AStarPathFinding aStarPathFinding = new AStarPathFinding();
        PhysicalGameState physicalGameState = gameState.getPhysicalGameState();
        Unit unit2 = null;
        int n = 0;
        int n2 = 9999;
        for (Unit unit3 : physicalGameState.getUnits()) {
            if (unit3.getPlayer() < 0 || unit3.getPlayer() == player.getID() || unit3 == null || unit == null) continue;
            n2 = aStarPathFinding.findDistToPositionInRange(unit, unit3.getPosition(physicalGameState), 1, gameState, gameState.getResourceUsage());
            if (unit2 != null && n2 >= n) continue;
            unit2 = unit3;
            n = n2;
        }
        if (unit2 == null) {
            return -1;
        }
        return aStarPathFinding.findDistToPositionInRange(unit, unit2.getPosition(physicalGameState), 1, gameState, gameState.getResourceUsage());
    }

    public int distUnitEneBase(Unit unit, Player player, GameState gameState) {
        PhysicalGameState physicalGameState = gameState.getPhysicalGameState();
        Unit unit2 = null;
        int n = 0;
        for (Unit unit3 : physicalGameState.getUnits()) {
            if (unit3.getPlayer() < 0 || unit3.getPlayer() == player.getID()) continue;
            int n2 = Math.abs(unit3.getX() - unit.getX()) + Math.abs(unit3.getY() - unit.getY());
            if (unit2 != null && n2 >= n) continue;
            unit2 = unit3;
            n = n2;
        }
        return n;
    }

    protected String getStrategyByDistribution(double[] dArray, int n) {
        String string = "POWorkerRush";
        double d = -1.0;
        for (String string2 : this.indice.keySet()) {
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            block15: for (infBattles infBattles2 : this.indice.get(string2).get(n)) {
                switch (infBattles2.enemy) {
                    case "POHeavyRush": {
                        d2 = infBattles2.ltd3;
                        continue block15;
                    }
                    case "EconomyRush": {
                        d3 = infBattles2.ltd3;
                        continue block15;
                    }
                    case "PORangedRush": {
                        d4 = infBattles2.ltd3;
                        continue block15;
                    }
                    case "POLightRush": {
                        d5 = infBattles2.ltd3;
                        continue block15;
                    }
                    case "POWorkerRush": {
                        d6 = infBattles2.ltd3;
                        continue block15;
                    }
                }
                System.err.println("Erro na sele\u00e7\u00e3o");
            }
            double d7 = (dArray[0] * d5 + dArray[1] * d6 + dArray[2] * d4 + dArray[3] * d3 + dArray[4] * d2) / (dArray[0] + dArray[1] + dArray[2] + dArray[3] + dArray[4]);
            if (!(d7 > d)) continue;
            d = d7;
            string = string2;
        }
        return string;
    }

    protected void setNewStrategy(String string) {
        ArrayList<AI> arrayList = new ArrayList<AI>();
        if (string.contains("POWorkerRush")) {
            arrayList.add(new POWorkerRush(this.localUtt));
        }
        if (string.contains("WorkerRushPlusPlus")) {
            arrayList.add(new WorkerRushPlusPlus(this.localUtt));
        }
        if (string.contains("POLightRush")) {
            arrayList.add(new POLightRush(this.localUtt));
        }
        if (string.contains("EconomyRush")) {
            arrayList.add(new EconomyRush(this.localUtt));
        }
        if (string.contains("RandomBiasedAI")) {
            arrayList.add(new RandomBiasedAI(this.localUtt));
        }
        if (string.contains("POHeavyRush")) {
            arrayList.add(new POHeavyRush(this.localUtt));
        }
        if (string.contains("PORangedRush")) {
            arrayList.add(new PORangedRush(this.localUtt));
        }
        if (string.contains("LightDefense")) {
            arrayList.add(new LightDefense(this.localUtt));
        }
        if (string.contains("RangedDefense")) {
            arrayList.add(new RangedDefense(this.localUtt));
        }
        if (string.contains("WorkerDefense")) {
            arrayList.add(new WorkerDefense(this.localUtt));
        }
        if (string.contains("EconomyMilitaryRush")) {
            arrayList.add(new EconomyMilitaryRush(this.localUtt));
        }
        if (string.contains("HeavyDefense")) {
            arrayList.add(new HeavyDefense(this.localUtt));
        }
        this.strategies = new AI[arrayList.size()];
        for (int j = 0; j < arrayList.size(); ++j) {
            this.strategies[j] = (AI)arrayList.get(j);
        }
    }

    protected class infBattles {
        Integer tMapa;
        String enemy;
        String strategy;
        double ltd3;

        protected infBattles() {
        }
    }
}

