/*
 * Decompiled with CFR 0.152.
 */
package ai.socket;

import ai.RandomBiasedAI;
import ai.core.AI;
import ai.socket.SocketAI;
import gui.PhysicalGameStateJFrame;
import gui.PhysicalGameStatePanel;
import rts.GameState;
import rts.PhysicalGameState;
import rts.PlayerAction;
import rts.units.UnitTypeTable;

public class GameVisualSimulationWithSocketAI {
    public static void main(String[] stringArray) throws Exception {
        UnitTypeTable unitTypeTable = new UnitTypeTable();
        PhysicalGameState physicalGameState = PhysicalGameState.load("maps/16x16/basesWorkers16x16.xml", unitTypeTable);
        GameState gameState = new GameState(physicalGameState, unitTypeTable);
        int n = 5000;
        int n2 = 20;
        boolean bl = false;
        SocketAI socketAI = new SocketAI(100, 0, "127.0.0.1", 9898, 1, unitTypeTable);
        RandomBiasedAI randomBiasedAI = new RandomBiasedAI();
        ((AI)socketAI).reset();
        ((AI)randomBiasedAI).reset();
        PhysicalGameStateJFrame physicalGameStateJFrame = PhysicalGameStatePanel.newVisualizer(gameState, 640, 640, false, PhysicalGameStatePanel.COLORSCHEME_BLACK);
        ((AI)socketAI).preGameAnalysis(gameState, 1000L, ".");
        randomBiasedAI.preGameAnalysis(gameState, 1000L, ".");
        long l = System.currentTimeMillis() + (long)n2;
        do {
            if (System.currentTimeMillis() >= l) {
                PlayerAction playerAction = ((AI)socketAI).getAction(0, gameState);
                PlayerAction playerAction2 = ((AI)randomBiasedAI).getAction(1, gameState);
                gameState.issueSafe(playerAction);
                gameState.issueSafe(playerAction2);
                bl = gameState.cycle();
                physicalGameStateJFrame.repaint();
                l += (long)n2;
                continue;
            }
            try {
                Thread.sleep(1L);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } while (!bl && gameState.getTime() < n);
        System.out.println("Game Over");
    }
}

