/*
 * Decompiled with CFR 0.152.
 */
package ai.socket;

import ai.abstraction.WorkerRush;
import ai.core.AIWithComputationBudget;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import rts.GameState;
import rts.PlayerAction;
import rts.units.UnitTypeTable;

public class JSONSocketWrapperAI {
    public static int DEBUG = 0;

    public static void main(String[] stringArray) throws Exception {
        DEBUG = 1;
        JSONSocketWrapperAI.runServer(new WorkerRush(new UnitTypeTable()), 9898);
    }

    public static void runServer(AIWithComputationBudget aIWithComputationBudget, int n) throws Exception {
        if (DEBUG >= 1) {
            System.out.println("JSONSocketWrapperAI server is running.");
        }
        int n2 = 0;
        ServerSocket serverSocket = new ServerSocket(n);
        try {
            while (true) {
                new SocketWrapperAI(serverSocket.accept(), n2++, aIWithComputationBudget).start();
            }
        }
        catch (Throwable throwable) {
            serverSocket.close();
            throw throwable;
        }
    }

    private static class SocketWrapperAI
    extends Thread {
        Socket socket = null;
        int clientNumber = 0;
        int time_budget = 100;
        int iterations_budget = 0;
        UnitTypeTable utt = null;
        AIWithComputationBudget ai = null;

        public SocketWrapperAI(Socket socket, int n, AIWithComputationBudget aIWithComputationBudget) {
            this.socket = socket;
            this.clientNumber = n;
            this.ai = aIWithComputationBudget;
            if (DEBUG >= 1) {
                System.out.println("New connection with client# " + n + " at " + socket);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                String string;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
                PrintWriter printWriter = new PrintWriter(this.socket.getOutputStream(), true);
                printWriter.println("JSONSocketWrapperAI: you are client #" + this.clientNumber);
                while ((string = bufferedReader.readLine()) != null) {
                    Object object;
                    Object object2;
                    int n;
                    String[] stringArray;
                    if (string.startsWith("end")) {
                        System.exit(0);
                        continue;
                    }
                    if (string.startsWith("budget")) {
                        stringArray = string.split(" ");
                        this.time_budget = Integer.parseInt(stringArray[1]);
                        this.iterations_budget = Integer.parseInt(stringArray[2]);
                        if (DEBUG >= 1) {
                            System.out.println("setting the budget to: " + this.time_budget + ", " + this.iterations_budget);
                        }
                        this.ai.reset();
                        this.ai.setTimeBudget(this.time_budget);
                        this.ai.setIterationsBudget(this.iterations_budget);
                        printWriter.append("ack\n");
                        printWriter.flush();
                        continue;
                    }
                    if (string.startsWith("utt")) {
                        string = bufferedReader.readLine();
                        if (DEBUG >= 1) {
                            System.out.println("setting the utt to: " + string);
                        }
                        this.utt = UnitTypeTable.fromJSON(string);
                        this.ai.reset(this.utt);
                        printWriter.append("ack\n");
                        printWriter.flush();
                        continue;
                    }
                    if (string.startsWith("getAction")) {
                        stringArray = string.split(" ");
                        n = Integer.parseInt(stringArray[1]);
                        if (DEBUG >= 1) {
                            System.out.println("getAction for player " + n);
                        }
                        string = bufferedReader.readLine();
                        if (DEBUG >= 1) {
                            System.out.println("with game state: " + string);
                        }
                        object2 = GameState.fromJSON(string, this.utt);
                        if (DEBUG >= 1) {
                            System.out.println(object2);
                        }
                        object = this.ai.getAction(n, (GameState)object2);
                        ((PlayerAction)object).toJSON(printWriter);
                        printWriter.append("\n");
                        printWriter.flush();
                        if (DEBUG < 1) continue;
                        System.out.println("action sent!");
                        continue;
                    }
                    if (string.startsWith("preGameAnalysis")) {
                        stringArray = string.split(" ");
                        n = Integer.parseInt(stringArray[1]);
                        object2 = null;
                        if (stringArray.length >= 2 && ((String)(object2 = stringArray[2])).startsWith("\"")) {
                            object2 = ((String)object2).substring(1, ((String)object2).length() - 1);
                        }
                        if (DEBUG >= 1) {
                            System.out.println("preGameAnalysis");
                        }
                        string = bufferedReader.readLine();
                        if (DEBUG >= 1) {
                            System.out.println("with game state: " + string);
                        }
                        object = GameState.fromJSON(string, this.utt);
                        if (DEBUG >= 1) {
                            System.out.println(object);
                        }
                        if (object2 != null) {
                            this.ai.preGameAnalysis((GameState)object, n, (String)object2);
                        } else {
                            this.ai.preGameAnalysis((GameState)object, n);
                        }
                        printWriter.append("ack\n");
                        printWriter.flush();
                        continue;
                    }
                    if (!string.startsWith("gameOver")) continue;
                    stringArray = string.split(" ");
                    n = Integer.parseInt(stringArray[1]);
                    if (DEBUG >= 1) {
                        System.out.println("gameOver " + n);
                    }
                    this.ai.gameOver(n);
                    printWriter.append("ack\n");
                    printWriter.flush();
                }
            }
            catch (Exception exception) {
                System.out.println("Error handling client# " + this.clientNumber + ": " + exception);
                exception.printStackTrace();
            }
            finally {
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                System.out.println("Connection with client# " + this.clientNumber + " closed");
            }
        }
    }
}

