/*
 * Decompiled with CFR 0.152.
 */
package ai.socket;

import ai.core.AI;
import ai.core.AIWithComputationBudget;
import ai.core.ParameterSpecification;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.net.ConnectException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import rts.GameState;
import rts.PlayerAction;
import rts.units.UnitTypeTable;
import util.XMLWriter;

public class SocketAI
extends AIWithComputationBudget {
    public static int DEBUG = 0;
    public static final int LANGUAGE_XML = 1;
    public static final int LANGUAGE_JSON = 2;
    UnitTypeTable utt = null;
    int communication_language = 1;
    String serverAddress = "127.0.0.1";
    int serverPort = 9898;
    String unixSocketPath = "/tmp/unixsocket";
    Socket socket = null;
    BufferedReader in_pipe = null;
    PrintWriter out_pipe = null;
    boolean layerJSON = false;
    int connectionMaxTry = 10;
    int connectionWaitDuration = 1000;

    public SocketAI(UnitTypeTable unitTypeTable) {
        super(100, -1);
        this.utt = unitTypeTable;
        try {
            this.connectToServer(false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public SocketAI(int n, int n2, String string, int n3, int n4, UnitTypeTable unitTypeTable) throws Exception {
        super(n, n2);
        this.serverAddress = string;
        this.serverPort = n3;
        this.communication_language = n4;
        this.utt = unitTypeTable;
        int n5 = 0;
        while (true) {
            try {
                this.connectToServer(false);
            }
            catch (ConnectException connectException) {
                System.out.printf("Connection to the MicroRTS server failed. Retrying in %f seconds\n", (double)this.connectionWaitDuration / 1000.0);
                Thread.sleep(this.connectionWaitDuration);
                if (++n5 != this.connectionMaxTry) continue;
                throw new Exception("Connection to the MicroRTS server failed");
            }
            catch (Exception exception) {
                throw exception;
            }
            break;
        }
    }

    public SocketAI(int n, int n2, String string, int n3, UnitTypeTable unitTypeTable) throws Exception {
        super(n, n2);
        this.unixSocketPath = string;
        this.communication_language = n3;
        this.utt = unitTypeTable;
        int n4 = 0;
        while (true) {
            try {
                this.connectToServer(true);
            }
            catch (ConnectException connectException) {
                System.out.printf("Connection to the MicroRTS server failed. Retrying in %f seconds\n", (double)this.connectionWaitDuration / 1000.0);
                Thread.sleep(this.connectionWaitDuration);
                if (++n4 != this.connectionMaxTry) continue;
                throw new Exception("Connection to the MicroRTS server failed");
            }
            catch (Exception exception) {
                throw exception;
            }
            break;
        }
    }

    private SocketAI(int n, int n2, UnitTypeTable unitTypeTable, int n3, Socket socket) {
        super(n, n2);
        this.communication_language = n3;
        this.utt = unitTypeTable;
        try {
            this.socket = socket;
            this.in_pipe = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            this.out_pipe = new PrintWriter(socket.getOutputStream(), true);
            while (!this.in_pipe.ready()) {
            }
            while (this.in_pipe.ready()) {
                this.in_pipe.readLine();
            }
            if (DEBUG >= 1) {
                System.out.println("SocketAI: welcome message received");
            }
            this.reset();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static SocketAI createFromExistingSocket(int n, int n2, UnitTypeTable unitTypeTable, int n3, Socket socket) {
        return new SocketAI(n, n2, unitTypeTable, n3, socket);
    }

    public void connectToServer(boolean bl) throws Exception {
        if (bl) {
            System.out.println(this.unixSocketPath);
            File file = new File(this.unixSocketPath);
            this.socket = AFUNIXSocket.newInstance();
            this.socket.connect(new AFUNIXSocketAddress(file));
        } else {
            this.socket = new Socket(this.serverAddress, this.serverPort);
        }
        this.in_pipe = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
        this.out_pipe = new PrintWriter(this.socket.getOutputStream(), true);
        while (!this.in_pipe.ready()) {
        }
        while (this.in_pipe.ready()) {
            this.in_pipe.readLine();
        }
        if (DEBUG >= 1) {
            System.out.println("SocketAI: welcome message received");
        }
        this.reset();
    }

    @Override
    public void reset() {
        try {
            this.out_pipe.append("budget " + this.TIME_BUDGET + " " + this.ITERATIONS_BUDGET + "\n");
            this.out_pipe.flush();
            if (DEBUG >= 1) {
                System.out.println("SocketAI: budgetd sent, waiting for ack");
            }
            this.in_pipe.readLine();
            while (this.in_pipe.ready()) {
                this.in_pipe.readLine();
            }
            if (DEBUG >= 1) {
                System.out.println("SocketAI: ack received");
            }
            this.out_pipe.append("utt\n");
            if (this.communication_language == 1) {
                XMLWriter xMLWriter = new XMLWriter(this.out_pipe, " ");
                this.utt.toxml(xMLWriter);
                xMLWriter.flush();
                this.out_pipe.append("\n");
                this.out_pipe.flush();
            } else if (this.communication_language == 2) {
                this.utt.toJSON(this.out_pipe);
                this.out_pipe.append("\n");
                this.out_pipe.flush();
            } else {
                throw new Exception("Communication language " + this.communication_language + " not supported!");
            }
            if (DEBUG >= 1) {
                System.out.println("SocketAI: UTT sent, waiting for ack");
            }
            this.in_pipe.readLine();
            while (this.in_pipe.ready()) {
                this.in_pipe.readLine();
            }
            if (DEBUG >= 1) {
                System.out.println("SocketAI: ack received");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public PlayerAction getAction(int n, GameState gameState) throws Exception {
        this.out_pipe.append("getAction " + n + "\n");
        if (this.communication_language == 1) {
            XMLWriter xMLWriter = new XMLWriter(this.out_pipe, " ");
            gameState.toxml(xMLWriter);
            xMLWriter.getWriter().append("\n");
            xMLWriter.flush();
            String string = this.in_pipe.readLine();
            if (DEBUG >= 1) {
                System.out.println("action received from server: " + string);
            }
            Element element = new SAXBuilder().build(new StringReader(string)).getRootElement();
            PlayerAction playerAction = PlayerAction.fromXML(element, gameState, this.utt);
            playerAction.fillWithNones(gameState, n, 10);
            return playerAction;
        }
        if (this.communication_language == 2) {
            gameState.toJSON(this.out_pipe);
            this.out_pipe.append("\n");
            this.out_pipe.flush();
            String string = this.in_pipe.readLine();
            PlayerAction playerAction = PlayerAction.fromJSON(string, gameState, this.utt);
            playerAction.fillWithNones(gameState, n, 10);
            return playerAction;
        }
        throw new Exception("Communication language " + this.communication_language + " not supported!");
    }

    @Override
    public void preGameAnalysis(GameState gameState, long l) throws Exception {
        this.out_pipe.append("preGameAnalysis " + l + "\n");
        switch (this.communication_language) {
            case 1: {
                XMLWriter xMLWriter = new XMLWriter(this.out_pipe, " ");
                gameState.toxml(xMLWriter);
                xMLWriter.flush();
                this.out_pipe.append("\n");
                this.out_pipe.flush();
                this.in_pipe.readLine();
                break;
            }
            case 2: {
                gameState.toJSON(this.out_pipe);
                this.out_pipe.append("\n");
                this.out_pipe.flush();
                this.in_pipe.readLine();
                break;
            }
            default: {
                throw new Exception("Communication language " + this.communication_language + " not supported!");
            }
        }
    }

    @Override
    public void preGameAnalysis(GameState gameState, long l, String string) throws Exception {
        this.out_pipe.append("preGameAnalysis " + l + "  \"" + string + "\"\n");
        switch (this.communication_language) {
            case 1: {
                XMLWriter xMLWriter = new XMLWriter(this.out_pipe, " ");
                gameState.toxml(xMLWriter);
                xMLWriter.flush();
                this.out_pipe.append("\n");
                this.out_pipe.flush();
                this.in_pipe.readLine();
                break;
            }
            case 2: {
                gameState.toJSON(this.out_pipe);
                this.out_pipe.append("\n");
                this.out_pipe.flush();
                this.in_pipe.readLine();
                break;
            }
            default: {
                throw new Exception("Communication language " + this.communication_language + " not supported!");
            }
        }
    }

    @Override
    public void gameOver(int n) throws Exception {
        this.out_pipe.append("gameOver " + n + "\n");
        this.out_pipe.flush();
        this.in_pipe.readLine();
    }

    @Override
    public AI clone() {
        try {
            return new SocketAI(this.TIME_BUDGET, this.ITERATIONS_BUDGET, this.serverAddress, this.serverPort, this.communication_language, this.utt);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public List<ParameterSpecification> getParameters() {
        ArrayList<ParameterSpecification> arrayList = new ArrayList<ParameterSpecification>();
        arrayList.add(new ParameterSpecification("Server Address", String.class, "127.0.0.1"));
        arrayList.add(new ParameterSpecification("Server Port", Integer.class, 9898));
        arrayList.add(new ParameterSpecification("Language", Integer.class, 1));
        return arrayList;
    }
}

