/*
 * Decompiled with CFR 0.152.
 */
package ai.socket;

import ai.evaluation.SimpleEvaluationFunction;
import ai.socket.SocketAI;
import ai.socket.SocketAIInterface;
import com.google.gson.Gson;
import gui.PhysicalGameStateJFrame;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import javax.imageio.ImageIO;
import rts.GameState;
import rts.PlayerAction;
import rts.units.UnitTypeTable;
import util.Pair;
import util.XMLWriter;

public class SocketRewardAI
extends SocketAI
implements SocketAIInterface {
    boolean layerJSON = false;
    boolean render = false;
    double reward = 0.0;
    double oldReward = 0.0;
    boolean firstRewardCalculation = true;
    int frameSkip = 0;
    int frameSkipCount = 0;
    RandomAccessFile file = null;
    DataOutputStream dOut = null;
    public boolean reset = false;
    public boolean gameover = false;
    public boolean finished = false;
    boolean shouldSendUTTAndBudget = true;
    SimpleEvaluationFunction ef = new SimpleEvaluationFunction();

    public SocketRewardAI(int n, int n2, String string, int n3, int n4, UnitTypeTable unitTypeTable, boolean bl) throws Exception {
        super(n, n2, string, n3, n4, unitTypeTable);
        this.layerJSON = bl;
    }

    public SocketRewardAI(int n, int n2, String string, int n3, UnitTypeTable unitTypeTable, boolean bl) throws Exception {
        super(n, n2, string, n3, unitTypeTable);
        this.layerJSON = bl;
    }

    @Override
    public void computeReward(int n, int n2, GameState gameState) throws Exception {
        if (this.firstRewardCalculation) {
            this.oldReward = this.ef.evaluate(n, n2, gameState);
            this.reward = 0.0;
            this.firstRewardCalculation = false;
        } else {
            double d = this.ef.evaluate(n, n2, gameState);
            this.reward = d - this.oldReward;
            this.oldReward = d;
        }
    }

    @Override
    public PlayerAction getAction(int n, GameState gameState) throws Exception {
        if (this.communication_language == 1) {
            return null;
        }
        if (this.communication_language == 2) {
            Object object;
            Object object2;
            if (this.frameSkipCount < this.frameSkip) {
                ++this.frameSkipCount;
                return new PlayerAction();
            }
            this.frameSkipCount = 0;
            this.frameSkip = 0;
            if (!this.render) {
                if (this.layerJSON) {
                    object2 = gameState.getMatrixObservation();
                    object = new HashMap<String, Object>();
                    object.put("observation", object2);
                    object.put("reward", this.reward);
                    object.put("done", this.gameover);
                    HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                    hashMap.put("resources", gameState.getPlayer(n).getResources());
                    object.put("info", hashMap);
                    Gson gson = new Gson();
                    this.out_pipe.write(gson.toJson(object));
                } else {
                    gameState.toJSON(this.out_pipe);
                }
                this.out_pipe.append("\n");
                this.out_pipe.flush();
            }
            if (((String)(object2 = this.in_pipe.readLine())).equals("reset")) {
                this.reset = true;
                return new PlayerAction();
            }
            if (((String)object2).equals("finished")) {
                this.reset = true;
                this.finished = true;
                return new PlayerAction();
            }
            this.render = false;
            if (((String)object2).equals("render")) {
                this.render = true;
                return new PlayerAction();
            }
            if (((String)object2).equals("[]")) {
                return new PlayerAction();
            }
            object = PlayerAction.fromActionArrays((String)object2, gameState, this.utt, n);
            ((PlayerAction)((Pair)object).m_a).fillWithNones(gameState, n, 1);
            this.frameSkip = (Integer)((Pair)object).m_b;
            return (PlayerAction)((Pair)object).m_a;
        }
        throw new Exception("Communication language " + this.communication_language + " not supported!");
    }

    @Override
    public void gameOver(int n) throws Exception {
        this.gameover = true;
    }

    @Override
    public void reset() {
        try {
            if (this.shouldSendUTTAndBudget) {
                this.out_pipe.append("budget " + this.TIME_BUDGET + " " + this.ITERATIONS_BUDGET + "\n");
                this.out_pipe.flush();
                if (DEBUG >= 1) {
                    System.out.println("SocketAI: budgetd sent, waiting for ack");
                }
                this.in_pipe.readLine();
                while (this.in_pipe.ready()) {
                    this.in_pipe.readLine();
                }
                if (DEBUG >= 1) {
                    System.out.println("SocketAI: ack received");
                }
                this.out_pipe.append("utt\n");
                if (this.communication_language == 1) {
                    XMLWriter xMLWriter = new XMLWriter(this.out_pipe, " ");
                    this.utt.toxml(xMLWriter);
                    xMLWriter.flush();
                    this.out_pipe.append("\n");
                    this.out_pipe.flush();
                } else if (this.communication_language == 2) {
                    this.utt.toJSON(this.out_pipe);
                    this.out_pipe.append("\n");
                    this.out_pipe.flush();
                } else {
                    throw new Exception("Communication language " + this.communication_language + " not supported!");
                }
                if (DEBUG >= 1) {
                    System.out.println("SocketAI: UTT sent, waiting for ack");
                }
                this.in_pipe.readLine();
                while (this.in_pipe.ready()) {
                    this.in_pipe.readLine();
                }
                if (DEBUG >= 1) {
                    System.out.println("SocketAI: ack received");
                }
                this.shouldSendUTTAndBudget = false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.reset = false;
        this.finished = false;
        this.gameover = false;
    }

    @Override
    public void setTimeBudget(int n) {
        this.TIME_BUDGET = n;
        this.shouldSendUTTAndBudget = true;
    }

    public void setUTT(UnitTypeTable unitTypeTable) {
        this.utt = unitTypeTable;
        this.shouldSendUTTAndBudget = true;
    }

    @Override
    public boolean getReset() {
        return this.reset;
    }

    @Override
    public boolean getFinished() {
        return this.finished;
    }

    @Override
    public double getReward() {
        return this.reward;
    }

    @Override
    public boolean getRender() {
        return this.render;
    }

    @Override
    public void sendGameStateRGBArray(PhysicalGameStateJFrame physicalGameStateJFrame) {
        BufferedImage bufferedImage = new BufferedImage(physicalGameStateJFrame.getWidth(), physicalGameStateJFrame.getHeight(), 1);
        physicalGameStateJFrame.paint(bufferedImage.getGraphics());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)bufferedImage, "jpg", byteArrayOutputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        Gson gson = new Gson();
        try {
            if (this.dOut == null) {
                this.dOut = new DataOutputStream(this.socket.getOutputStream());
                this.file = new RandomAccessFile("/home/costa/Documents/work/go/src/github.com/vwxyzjn/gym-microrts/unix/t", "rw");
            }
            this.file.seek(0L);
            MappedByteBuffer mappedByteBuffer = this.file.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, this.file.length());
            mappedByteBuffer.putInt(byArray.length);
            mappedByteBuffer.put(byArray);
            this.dOut.writeInt(byArray.length);
            this.dOut.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static int[][][] convertTo2DWithoutUsingGetRGB(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        int[][][] nArray = new int[n2][n][3];
        for (int j = 0; j < n2; ++j) {
            for (int k = 0; k < n; ++k) {
                Color color = new Color(bufferedImage.getRGB(k, j));
                nArray[j][k][0] = color.getRed();
                nArray[j][k][1] = color.getGreen();
                nArray[j][k][2] = color.getBlue();
            }
        }
        return nArray;
    }
}

