/*
 * Decompiled with CFR 0.152.
 */
package ai.stochastic;

import ai.core.AI;
import ai.core.ParameterSpecification;
import ai.stochastic.UnitActionProbabilityDistribution;
import ai.stochastic.UnitActionTypeConstantDistribution;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import rts.GameState;
import rts.PhysicalGameState;
import rts.PlayerAction;
import rts.ResourceUsage;
import rts.UnitAction;
import rts.UnitActionAssignment;
import rts.units.Unit;
import rts.units.UnitTypeTable;
import util.Sampler;

public class UnitActionProbabilityDistributionAI
extends AI {
    public static int DEBUG = 0;
    Random r = new Random();
    UnitActionProbabilityDistribution model = null;
    String modelName = "";
    UnitTypeTable utt = null;

    public UnitActionProbabilityDistributionAI(UnitTypeTable unitTypeTable) throws Exception {
        this(new UnitActionTypeConstantDistribution(unitTypeTable, new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0}), unitTypeTable, "uniform");
    }

    public UnitActionProbabilityDistributionAI(UnitActionProbabilityDistribution unitActionProbabilityDistribution, UnitTypeTable unitTypeTable, String string) {
        this.model = unitActionProbabilityDistribution;
        this.utt = unitTypeTable;
        this.modelName = string;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.modelName + ")";
    }

    @Override
    public void reset() {
    }

    @Override
    public AI clone() {
        return new UnitActionProbabilityDistributionAI(this.model, this.utt, this.modelName);
    }

    @Override
    public PlayerAction getAction(int n, GameState gameState) throws Exception {
        Object object;
        Object object2;
        if (gameState.getUnitTypeTable() != this.utt) {
            throw new Exception("UnitActionDistributionAI uses a UnitTypeTable different from the one used to play!");
        }
        PhysicalGameState physicalGameState = gameState.getPhysicalGameState();
        PlayerAction playerAction = new PlayerAction();
        if (!gameState.canExecuteAnyAction(n)) {
            return playerAction;
        }
        for (Unit unit : physicalGameState.getUnits()) {
            object2 = gameState.getActionAssignment(unit);
            if (object2 == null) continue;
            object = ((UnitActionAssignment)object2).action.resourceUsage(unit, physicalGameState);
            playerAction.getResourceUsage().merge((ResourceUsage)object);
        }
        for (Unit unit : physicalGameState.getUnits()) {
            Object object3;
            if (unit.getPlayer() != n || gameState.getActionAssignment(unit) != null) continue;
            object2 = unit.getUnitActions(gameState);
            object = this.model.predictDistribution(unit, gameState, (List<UnitAction>)object2);
            UnitAction unitAction = null;
            Object object4 = object2.iterator();
            while (object4.hasNext()) {
                object3 = (UnitAction)object4.next();
                if (((UnitAction)object3).getType() != 0) continue;
                unitAction = object3;
            }
            try {
                object4 = (UnitAction)object2.get(Sampler.weighted((double[])object));
                if (((UnitAction)object4).resourceUsage(unit, physicalGameState).consistentWith(playerAction.getResourceUsage(), gameState)) {
                    object3 = ((UnitAction)object4).resourceUsage(unit, physicalGameState);
                    playerAction.getResourceUsage().merge((ResourceUsage)object3);
                    playerAction.addUnitAction(unit, (UnitAction)object4);
                    continue;
                }
                playerAction.addUnitAction(unit, unitAction);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                playerAction.addUnitAction(unit, unitAction);
            }
        }
        return playerAction;
    }

    @Override
    public List<ParameterSpecification> getParameters() {
        ArrayList<ParameterSpecification> arrayList = new ArrayList<ParameterSpecification>();
        try {
            arrayList.add(new ParameterSpecification("Model", UnitActionProbabilityDistribution.class, new UnitActionTypeConstantDistribution(this.utt, new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0})));
            arrayList.add(new ParameterSpecification("ModelName", String.class, "uniformDistribution"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    public UnitActionProbabilityDistribution getModel() {
        return this.model;
    }

    public void setModel(UnitActionProbabilityDistribution unitActionProbabilityDistribution) {
        this.model = unitActionProbabilityDistribution;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String string) {
        this.modelName = string;
    }
}

