/*
 * Decompiled with CFR 0.152.
 */
package gui;

import ai.abstraction.AbstractAction;
import ai.abstraction.AbstractionLayerAI;
import ai.abstraction.pathfinding.BFSPathFinding;
import ai.core.AI;
import ai.core.ParameterSpecification;
import gui.PGSMouseListener;
import gui.PhysicalGameStateMouseJFrame;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import rts.GameState;
import rts.PhysicalGameState;
import rts.PlayerAction;
import rts.ResourceUsage;
import rts.UnitAction;
import rts.units.Unit;

public class MouseController
extends AbstractionLayerAI {
    PhysicalGameStateMouseJFrame m_frame = null;
    PGSMouseListener m_mouseListener = null;

    public MouseController(PhysicalGameStateMouseJFrame physicalGameStateMouseJFrame) {
        super(new BFSPathFinding());
        this.m_frame = physicalGameStateMouseJFrame;
        this.reset();
    }

    public void setFrame(PhysicalGameStateMouseJFrame physicalGameStateMouseJFrame) {
        this.m_frame = physicalGameStateMouseJFrame;
        this.reset();
    }

    @Override
    public void reset() {
        if (this.m_frame != null) {
            MouseListener[] mouseListenerArray;
            for (MouseListener mouseListener : mouseListenerArray = this.m_frame.getMouseListeners()) {
                if (!(mouseListener instanceof PGSMouseListener)) continue;
                this.m_frame.removeMouseListener(mouseListener);
            }
            this.m_mouseListener = new PGSMouseListener(this, this.m_frame, null, -1);
            this.m_frame.addMouseListener(this.m_mouseListener);
            this.m_frame.addMouseMotionListener(this.m_mouseListener);
            this.m_frame.addKeyListener(this.m_mouseListener);
        }
    }

    @Override
    public AI clone() {
        return new MouseController(this.m_frame);
    }

    @Override
    public PlayerAction getAction(int n, GameState gameState) {
        this.m_mouseListener.setPlayer(n);
        this.m_mouseListener.setGameState(gameState);
        PhysicalGameState physicalGameState = gameState.getPhysicalGameState();
        for (Unit unit : physicalGameState.getUnits()) {
            if (unit.getPlayer() != n) continue;
            AbstractAction abstractAction = (AbstractAction)this.actions.get(unit);
            if (abstractAction == null) {
                this.idle(unit);
                continue;
            }
            if (!abstractAction.completed(gameState)) continue;
            this.idle(unit);
        }
        return this.translateActions(n, gameState);
    }

    @Override
    public PlayerAction translateActions(int n, GameState gameState) {
        PhysicalGameState physicalGameState = gameState.getPhysicalGameState();
        PlayerAction playerAction = new PlayerAction();
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        Object object = gameState.getResourceUsage();
        LinkedList<Unit> linkedList2 = new LinkedList<Unit>();
        for (AbstractAction object2 : this.actions.values()) {
            UnitAction unitAction;
            if (!physicalGameState.getUnits().contains(object2.getUnit())) {
                linkedList2.add(object2.getUnit());
                continue;
            }
            if (gameState.getActionAssignment(object2.getUnit()) != null || (unitAction = object2.execute(gameState)) == null) continue;
            playerAction.addUnitAction(object2.getUnit(), unitAction);
            ResourceUsage resourceUsage = unitAction.resourceUsage(object2.getUnit(), physicalGameState);
            for (Integer n2 : resourceUsage.getPositionsUsed()) {
                int n3;
                int n4 = n2 % physicalGameState.getWidth();
                if (physicalGameState.getTerrain(n4, n3 = n2 / physicalGameState.getWidth()) != 0) continue;
                linkedList.add(n2);
                physicalGameState.setTerrain(n4, n3, 1);
            }
            ResourceUsage resourceUsage2 = ((ResourceUsage)object).mergeIntoNew(resourceUsage);
            if (!playerAction.consistentWith(resourceUsage2, gameState)) {
                playerAction.removeUnitAction(object2.getUnit(), unitAction);
                continue;
            }
            object = resourceUsage2;
        }
        for (Unit unit : linkedList2) {
            this.actions.remove(unit);
        }
        for (Integer n5 : linkedList) {
            int n6 = n5 % physicalGameState.getWidth();
            int n7 = n5 / physicalGameState.getWidth();
            physicalGameState.setTerrain(n6, n7, 0);
        }
        playerAction.fillWithNones(gameState, n, 1);
        return playerAction;
    }

    @Override
    public List<ParameterSpecification> getParameters() {
        return new ArrayList<ParameterSpecification>();
    }
}

