/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.MouseController;
import gui.MouseControllerPanel;
import gui.PhysicalGameStateMouseJFrame;
import gui.PhysicalGameStatePanel;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import rts.GameState;
import rts.units.Unit;
import rts.units.UnitType;
import util.Pair;

public class PGSMouseListener
implements MouseListener,
MouseMotionListener,
KeyListener {
    MouseController AI = null;
    PhysicalGameStateMouseJFrame frame = null;
    GameState gs = null;
    int playerID = -1;
    List<Unit> selectedUnits = new ArrayList<Unit>();
    String selectedButton = null;
    HashMap<Character, String> unitTypeQuickKeys = new HashMap();

    public PGSMouseListener(MouseController mouseController, PhysicalGameStateMouseJFrame physicalGameStateMouseJFrame, GameState gameState, int n) {
        this.AI = mouseController;
        this.frame = physicalGameStateMouseJFrame;
        this.gs = gameState;
        this.playerID = n;
    }

    public void setGameState(GameState gameState) {
        this.gs = gameState;
    }

    public void setPlayer(int n) {
        this.playerID = n;
    }

    public void clearQuickKeys() {
        this.unitTypeQuickKeys.clear();
    }

    public Character addQuickKey(String string) {
        for (int j = 0; j < string.length(); ++j) {
            Character c = Character.valueOf(string.charAt(j));
            c = Character.valueOf(Character.toLowerCase(c.charValue()));
            boolean bl = false;
            for (Character c2 : this.unitTypeQuickKeys.keySet()) {
                if (!c2.equals(c)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            this.unitTypeQuickKeys.put(c, string);
            return c;
        }
        return null;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        Object object;
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        Pair pair = null;
        Unit unit = null;
        Unit unit2 = null;
        String string = null;
        if (this.gs == null) {
            return;
        }
        PhysicalGameStatePanel physicalGameStatePanel = this.frame.getPanel();
        MouseControllerPanel mouseControllerPanel = this.frame.getMousePanel();
        Object object2 = this.frame.getContentAtCoordinates(n, n2);
        if (object2 != null) {
            if (object2 instanceof Pair) {
                pair = (Pair)object2;
                unit = this.gs.getPhysicalGameState().getUnitAt((Integer)pair.m_a, (Integer)pair.m_b);
                if (unit != null && unit.getPlayer() == this.playerID) {
                    unit2 = unit;
                    pair = null;
                }
            } else if (object2 instanceof String) {
                string = (String)object2;
            }
        }
        if (mouseEvent.getButton() == 1) {
            if (unit2 != null) {
                this.selectedUnits.clear();
                this.selectedUnits.add(unit2);
                this.selectedButton = null;
                this.updateButtons();
            } else if (string != null) {
                this.selectedButton = string;
                for (Unit unit3 : this.selectedUnits) {
                    if (unit3.getType().canMove || (object = this.gs.getUnitTypeTable().getUnitType(this.selectedButton)) == null) continue;
                    this.AI.train(unit3, (UnitType)object);
                    this.selectedButton = null;
                }
            } else if (this.insideOfGameArea(mouseEvent.getX(), mouseEvent.getY())) {
                this.selectedUnits.clear();
                this.selectedButton = null;
                mouseControllerPanel.clearButtons();
                this.clearQuickKeys();
            }
        } else if (mouseEvent.getButton() == 3) {
            for (Unit unit3 : this.selectedUnits) {
                if (pair == null) continue;
                if (unit != null) {
                    if (unit.getType().isResource) {
                        if (!unit3.getType().canHarvest) continue;
                        object = null;
                        double d = 0.0;
                        for (Unit unit4 : this.gs.getPhysicalGameState().getUnits()) {
                            if (unit4.getPlayer() != this.playerID || !unit4.getType().isStockpile) continue;
                            double d2 = unit3.getX() - unit4.getX() + (unit3.getY() - unit4.getY());
                            if (object != null && !(d2 < d)) continue;
                            object = unit4;
                            d = d2;
                        }
                        if (object == null) continue;
                        this.AI.harvest(unit3, unit, (Unit)object);
                        continue;
                    }
                    if (unit.getType().isResource || unit.getPlayer() == this.playerID || !unit3.getType().canAttack) continue;
                    this.AI.attack(unit3, unit);
                    continue;
                }
                object = this.gs.getUnitTypeTable().getUnitType(this.selectedButton);
                if (object == null) {
                    if (!unit3.getType().canMove) continue;
                    this.AI.move(unit3, (Integer)pair.m_a, (Integer)pair.m_b);
                    continue;
                }
                if (!unit3.getType().canMove) continue;
                this.AI.build(unit3, (UnitType)object, (Integer)pair.m_a, (Integer)pair.m_b);
            }
        }
        physicalGameStatePanel.clearHighlights();
        mouseControllerPanel.clearHighlight();
        for (Unit unit3 : this.selectedUnits) {
            physicalGameStatePanel.highlight(unit3);
        }
        if (unit2 != null) {
            physicalGameStatePanel.highlight(unit2);
        }
        if (this.selectedButton != null) {
            mouseControllerPanel.highlight(this.selectedButton);
        }
        if (string != null) {
            mouseControllerPanel.highlight(string);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1) {
            Insets insets = this.frame.getInsets();
            this.frame.panel.m_mouse_selection_x0 = this.frame.panel.m_mouse_selection_x1 = mouseEvent.getX() - insets.left;
            this.frame.panel.m_mouse_selection_y0 = this.frame.panel.m_mouse_selection_y1 = mouseEvent.getY() - insets.top;
            this.frame.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.insideOfGameArea(mouseEvent.getX(), mouseEvent.getY())) {
            this.frame.panel.m_mouse_selection_x1 = -1;
            this.frame.panel.m_mouse_selection_x0 = -1;
            this.frame.panel.m_mouse_selection_y1 = -1;
            this.frame.panel.m_mouse_selection_y0 = -1;
            return;
        }
        if (mouseEvent.getButton() == 1) {
            int n = Math.min(this.frame.panel.m_mouse_selection_x0, this.frame.panel.m_mouse_selection_x1);
            int n2 = Math.max(this.frame.panel.m_mouse_selection_x0, this.frame.panel.m_mouse_selection_x1);
            int n3 = Math.min(this.frame.panel.m_mouse_selection_y0, this.frame.panel.m_mouse_selection_y1);
            int n4 = Math.max(this.frame.panel.m_mouse_selection_y0, this.frame.panel.m_mouse_selection_y1);
            Pair<Integer, Integer> pair = this.frame.panel.getContentAtCoordinatesBounded(n, n3);
            Pair<Integer, Integer> pair2 = this.frame.panel.getContentAtCoordinatesBounded(n2, n4);
            this.frame.panel.m_mouse_selection_x1 = -1;
            this.frame.panel.m_mouse_selection_x0 = -1;
            this.frame.panel.m_mouse_selection_y1 = -1;
            this.frame.panel.m_mouse_selection_y0 = -1;
            if (pair != null && pair2 != null) {
                PhysicalGameStatePanel physicalGameStatePanel = this.frame.getPanel();
                MouseControllerPanel mouseControllerPanel = this.frame.getMousePanel();
                physicalGameStatePanel.clearHighlights();
                mouseControllerPanel.clearHighlight();
                this.selectedUnits.clear();
                Pair<Integer, Integer> pair3 = pair;
                Pair<Integer, Integer> pair4 = pair2;
                for (int j = ((Integer)pair3.m_b).intValue(); j <= (Integer)pair4.m_b; ++j) {
                    for (int k = ((Integer)pair3.m_a).intValue(); k <= (Integer)pair4.m_a; ++k) {
                        Unit unit = this.gs.getPhysicalGameState().getUnitAt(k, j);
                        if (unit == null || unit.getPlayer() != this.playerID) continue;
                        physicalGameStatePanel.highlight(unit);
                        this.selectedUnits.add(unit);
                    }
                }
                this.updateButtons();
            }
            this.frame.repaint();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1) {
            Insets insets = this.frame.getInsets();
            this.frame.panel.m_mouse_selection_x1 = mouseEvent.getX() - insets.left;
            this.frame.panel.m_mouse_selection_y1 = mouseEvent.getY() - insets.top;
            this.frame.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        Object object;
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (this.gs == null) {
            return;
        }
        PhysicalGameStatePanel physicalGameStatePanel = this.frame.getPanel();
        MouseControllerPanel mouseControllerPanel = this.frame.getMousePanel();
        physicalGameStatePanel.clearHighlights();
        mouseControllerPanel.clearHighlight();
        Object object2 = this.selectedUnits.iterator();
        while (object2.hasNext()) {
            object = object2.next();
            physicalGameStatePanel.highlight((Unit)object);
        }
        if (this.selectedButton != null) {
            mouseControllerPanel.highlight(this.selectedButton);
        }
        if ((object2 = this.frame.getContentAtCoordinates(n, n2)) != null) {
            if (object2 instanceof Pair) {
                object = (Pair)object2;
                Unit unit = this.gs.getPhysicalGameState().getUnitAt((Integer)((Pair)object).m_a, (Integer)((Pair)object).m_b);
                if (unit != null && unit.getPlayer() == this.playerID) {
                    physicalGameStatePanel.highlight(unit);
                }
            } else if (object2 instanceof String) {
                mouseControllerPanel.highlight((String)object2);
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        String string = this.unitTypeQuickKeys.get(Character.valueOf(c));
        if (string != null) {
            this.selectedButton = string;
            for (Unit unit : this.selectedUnits) {
                UnitType unitType;
                if (unit.getType().canMove || (unitType = this.gs.getUnitTypeTable().getUnitType(this.selectedButton)) == null) continue;
                this.AI.train(unit, unitType);
            }
        }
        MouseControllerPanel mouseControllerPanel = this.frame.getMousePanel();
        mouseControllerPanel.clearHighlight();
        if (this.selectedButton != null) {
            mouseControllerPanel.highlight(this.selectedButton);
        }
        if (string != null) {
            mouseControllerPanel.highlight(string);
        }
        mouseControllerPanel.repaint();
    }

    private void updateButtons() {
        Serializable serializable;
        MouseControllerPanel mouseControllerPanel = this.frame.getMousePanel();
        mouseControllerPanel.clearButtons();
        this.clearQuickKeys();
        ArrayList<UnitType> arrayList = null;
        for (Unit object : this.selectedUnits) {
            if (arrayList == null) {
                arrayList = new ArrayList<UnitType>();
                arrayList.addAll(object.getType().produces);
                continue;
            }
            serializable = new ArrayList();
            for (UnitType unitType : arrayList) {
                if (object.getType().produces.contains(unitType)) continue;
                serializable.add(unitType);
            }
            arrayList.removeAll((Collection<?>)((Object)serializable));
        }
        if (arrayList != null) {
            for (UnitType unitType : arrayList) {
                serializable = this.addQuickKey(unitType.name);
                mouseControllerPanel.addButton(unitType.name, (Character)serializable);
            }
        }
    }

    public boolean insideOfGameArea(int n, int n2) {
        Insets insets = this.frame.getInsets();
        Rectangle rectangle = this.frame.panel.getBounds();
        return (n -= insets.left) >= rectangle.x && n < rectangle.x + rectangle.width && (n2 -= insets.top) >= rectangle.y && n2 < rectangle.y + rectangle.height;
    }
}

