/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.MouseControllerPanel;
import gui.PhysicalGameStatePanel;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import rts.GameState;
import util.Pair;

public class PhysicalGameStateMouseJFrame
extends JFrame {
    PhysicalGameStatePanel panel = null;
    MouseControllerPanel mousePanel = null;

    public PhysicalGameStateMouseJFrame(String string, int n, int n2, PhysicalGameStatePanel physicalGameStatePanel) {
        super(string);
        this.panel = physicalGameStatePanel;
        this.mousePanel = new MouseControllerPanel();
        this.panel.setPreferredSize(new Dimension(n, n2 - 64));
        this.mousePanel.setPreferredSize(new Dimension(n, 64));
        this.getContentPane().removeAll();
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.getContentPane().add(this.panel);
        this.getContentPane().add(this.mousePanel);
        this.pack();
        this.setSize(n, n2);
        this.setResizable(false);
        this.setVisible(true);
        this.setDefaultCloseOperation(2);
    }

    public PhysicalGameStatePanel getPanel() {
        return this.panel;
    }

    public MouseControllerPanel getMousePanel() {
        return this.mousePanel;
    }

    public void setStateDirect(GameState gameState) {
        this.panel.setStateDirect(gameState);
    }

    public Object getContentAtCoordinates(int n, int n2) {
        Insets insets = this.getInsets();
        Rectangle rectangle = this.panel.getBounds();
        if ((n -= insets.left) >= rectangle.x && n < rectangle.x + rectangle.width && (n2 -= insets.top) >= rectangle.y && n2 < rectangle.y + rectangle.height) {
            Pair<Integer, Integer> pair = this.panel.getContentAtCoordinates(n - rectangle.x, n2 - rectangle.y);
            return pair;
        }
        rectangle = this.mousePanel.getBounds();
        if (n >= rectangle.x && n < rectangle.x + rectangle.width && n2 >= rectangle.y && n2 < rectangle.y + rectangle.height) {
            String string = this.mousePanel.getContentAtCoordinates(n - rectangle.x, n2 - rectangle.y);
            return string;
        }
        return null;
    }
}

