/*
 * Decompiled with CFR 0.152.
 */
package gui;

import ai.evaluation.EvaluationFunction;
import ai.evaluation.SimpleEvaluationFunction;
import gui.PhysicalGameStateJFrame;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JPanel;
import rts.GameState;
import rts.PartiallyObservableGameState;
import rts.PhysicalGameState;
import rts.UnitActionAssignment;
import rts.units.Unit;
import util.Pair;

public class PhysicalGameStatePanel
extends JPanel {
    public static int COLORSCHEME_BLACK = 1;
    public static int COLORSCHEME_WHITE = 2;
    boolean fullObservability = true;
    int drawFromPerspectiveOfPlayer = -1;
    GameState gs = null;
    List<Unit> toHighLight = new LinkedList<Unit>();
    EvaluationFunction evalFunction = null;
    int m_mouse_selection_x0 = -1;
    int m_mouse_selection_x1 = -1;
    int m_mouse_selection_y0 = -1;
    int m_mouse_selection_y1 = -1;
    PartiallyObservableGameState[] pogs = new PartiallyObservableGameState[2];
    int last_start_x = 0;
    int last_start_y = 0;
    int last_grid = 0;
    int colorScheme = COLORSCHEME_BLACK;

    public PhysicalGameStatePanel(GameState gameState) {
        this(gameState, new SimpleEvaluationFunction());
    }

    public PhysicalGameStatePanel(PhysicalGameStatePanel physicalGameStatePanel) {
        this(physicalGameStatePanel.gs, physicalGameStatePanel.evalFunction);
        this.fullObservability = physicalGameStatePanel.fullObservability;
        this.drawFromPerspectiveOfPlayer = physicalGameStatePanel.drawFromPerspectiveOfPlayer;
        if (this.gs != null) {
            this.pogs[0] = new PartiallyObservableGameState(this.gs, 0);
            this.pogs[1] = new PartiallyObservableGameState(this.gs, 1);
        }
    }

    public PhysicalGameStatePanel(GameState gameState, EvaluationFunction evaluationFunction) {
        this.gs = gameState;
        if (this.gs != null) {
            this.pogs[0] = new PartiallyObservableGameState(this.gs, 0);
            this.pogs[1] = new PartiallyObservableGameState(this.gs, 1);
        }
        this.evalFunction = evaluationFunction;
        if (this.colorScheme == COLORSCHEME_BLACK) {
            this.setBackground(Color.BLACK);
        }
        if (this.colorScheme == COLORSCHEME_WHITE) {
            this.setBackground(Color.WHITE);
        }
    }

    public PhysicalGameStatePanel(GameState gameState, EvaluationFunction evaluationFunction, int n) {
        this.gs = gameState;
        if (this.gs != null) {
            this.pogs[0] = new PartiallyObservableGameState(this.gs, 0);
            this.pogs[1] = new PartiallyObservableGameState(this.gs, 1);
        }
        this.evalFunction = evaluationFunction;
        this.colorScheme = n;
        if (this.colorScheme == COLORSCHEME_BLACK) {
            this.setBackground(Color.BLACK);
        }
        if (this.colorScheme == COLORSCHEME_WHITE) {
            this.setBackground(Color.WHITE);
        }
    }

    public static PhysicalGameStateJFrame newVisualizer(GameState gameState) {
        return PhysicalGameStatePanel.newVisualizer(gameState, 320, 320, false, new SimpleEvaluationFunction(), COLORSCHEME_BLACK);
    }

    public static PhysicalGameStateJFrame newVisualizer(GameState gameState, boolean bl) {
        return PhysicalGameStatePanel.newVisualizer(gameState, 320, 320, bl, new SimpleEvaluationFunction(), COLORSCHEME_BLACK);
    }

    public static PhysicalGameStateJFrame newVisualizer(GameState gameState, int n, int n2) {
        return PhysicalGameStatePanel.newVisualizer(gameState, n, n2, false, new SimpleEvaluationFunction(), COLORSCHEME_BLACK);
    }

    public static PhysicalGameStateJFrame newVisualizer(GameState gameState, int n, int n2, boolean bl) {
        return PhysicalGameStatePanel.newVisualizer(gameState, n, n2, bl, new SimpleEvaluationFunction(), COLORSCHEME_BLACK);
    }

    public static PhysicalGameStateJFrame newVisualizer(GameState gameState, int n, int n2, boolean bl, int n3) {
        return PhysicalGameStatePanel.newVisualizer(gameState, n, n2, bl, new SimpleEvaluationFunction(), n3);
    }

    public static PhysicalGameStateJFrame newVisualizer(GameState gameState, int n, int n2, EvaluationFunction evaluationFunction) {
        return PhysicalGameStatePanel.newVisualizer(gameState, n, n2, false, evaluationFunction, COLORSCHEME_BLACK);
    }

    public static PhysicalGameStateJFrame newVisualizer(GameState gameState, int n, int n2, boolean bl, EvaluationFunction evaluationFunction, int n3) {
        PhysicalGameStatePanel physicalGameStatePanel = new PhysicalGameStatePanel(gameState, evaluationFunction, n3);
        physicalGameStatePanel.fullObservability = !bl;
        PhysicalGameStateJFrame physicalGameStateJFrame = null;
        physicalGameStateJFrame = new PhysicalGameStateJFrame("Game State Visualizer", n, n2, physicalGameStatePanel);
        return physicalGameStateJFrame;
    }

    public GameState getGameState() {
        return this.gs;
    }

    public void setColorScheme(int n) {
        this.colorScheme = n;
        if (this.colorScheme == COLORSCHEME_BLACK) {
            this.setBackground(Color.BLACK);
        }
        if (this.colorScheme == COLORSCHEME_WHITE) {
            this.setBackground(Color.WHITE);
        }
    }

    public int getColorScheme() {
        return this.colorScheme;
    }

    public void setStateCloning(GameState gameState) {
        this.gs = gameState.clone();
        if (this.gs != null) {
            this.pogs[0] = new PartiallyObservableGameState(this.gs, 0);
            this.pogs[1] = new PartiallyObservableGameState(this.gs, 1);
        } else {
            this.pogs[0] = null;
            this.pogs[1] = null;
        }
    }

    public void setStateDirect(GameState gameState) {
        this.gs = gameState;
        if (this.gs != null) {
            this.pogs[0] = new PartiallyObservableGameState(this.gs, 0);
            this.pogs[1] = new PartiallyObservableGameState(this.gs, 1);
        } else {
            this.pogs[0] = null;
            this.pogs[1] = null;
        }
    }

    public GameState getState() {
        return this.gs;
    }

    public void clearHighlights() {
        this.toHighLight.clear();
    }

    public void highlight(Unit unit) {
        this.toHighLight.add(unit);
    }

    public Pair<Integer, Integer> getContentAtCoordinates(int n, int n2) {
        if (n < this.last_start_x) {
            return null;
        }
        if (n2 < this.last_start_y) {
            return null;
        }
        int n3 = (n - this.last_start_x) / this.last_grid;
        int n4 = (n2 - this.last_start_y) / this.last_grid;
        if (n3 >= this.gs.getPhysicalGameState().getWidth()) {
            return null;
        }
        if (n4 >= this.gs.getPhysicalGameState().getHeight()) {
            return null;
        }
        return new Pair<Integer, Integer>(n3, n4);
    }

    public Pair<Integer, Integer> getContentAtCoordinatesBounded(int n, int n2) {
        if (n < this.last_start_x) {
            n = this.last_start_x;
        }
        if (n2 < this.last_start_y) {
            n2 = this.last_start_y;
        }
        int n3 = (n - this.last_start_x) / this.last_grid;
        int n4 = (n2 - this.last_start_y) / this.last_grid;
        if (n3 >= this.gs.getPhysicalGameState().getWidth()) {
            n3 = this.gs.getPhysicalGameState().getWidth() - 1;
        }
        if (n4 >= this.gs.getPhysicalGameState().getHeight()) {
            n4 = this.gs.getPhysicalGameState().getHeight() - 1;
        }
        return new Pair<Integer, Integer>(n3, n4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.gs != null) {
            GameState gameState = this.gs;
            synchronized (gameState) {
                PhysicalGameStatePanel.draw(graphics2D, this, this.getWidth(), this.getHeight(), this.gs, this.pogs, this.colorScheme, this.fullObservability, this.drawFromPerspectiveOfPlayer, this.evalFunction);
            }
        }
        if (this.m_mouse_selection_x0 >= 0) {
            graphics.setColor(Color.green);
            int n = Math.min(this.m_mouse_selection_x0, this.m_mouse_selection_x1);
            int n2 = Math.max(this.m_mouse_selection_x0, this.m_mouse_selection_x1);
            int n3 = Math.min(this.m_mouse_selection_y0, this.m_mouse_selection_y1);
            int n4 = Math.max(this.m_mouse_selection_y0, this.m_mouse_selection_y1);
            graphics.drawRect(n, n3, n2 - n, n4 - n3);
        }
    }

    public static void draw(Graphics2D graphics2D, PhysicalGameStatePanel physicalGameStatePanel, int n, int n2, GameState gameState, PartiallyObservableGameState[] partiallyObservableGameStateArray, int n3, boolean bl, int n4, EvaluationFunction evaluationFunction) {
        int linkedList;
        if (gameState == null) {
            return;
        }
        PhysicalGameState physicalGameState = gameState.getPhysicalGameState();
        if (physicalGameState == null) {
            return;
        }
        int n6 = (n - 64) / physicalGameState.getWidth();
        int n7 = (n2 - 64) / physicalGameState.getHeight();
        int n8 = Math.min(n6, n7);
        int n9 = n8 * physicalGameState.getWidth();
        int n10 = n8 * physicalGameState.getHeight();
        if (partiallyObservableGameStateArray != null && partiallyObservableGameStateArray[0] != null && partiallyObservableGameStateArray[1] != null && partiallyObservableGameStateArray[0].getTime() != gameState.getTime()) {
            partiallyObservableGameStateArray[0] = new PartiallyObservableGameState(gameState, 0);
            partiallyObservableGameStateArray[1] = new PartiallyObservableGameState(gameState, 1);
        }
        if (n3 == COLORSCHEME_BLACK) {
            graphics2D.setColor(Color.WHITE);
        }
        if (n3 == COLORSCHEME_WHITE) {
            graphics2D.setColor(Color.BLACK);
        }
        int n11 = 0;
        for (Unit object : gameState.getPhysicalGameState().getUnits()) {
            if (object.getPlayer() != 0) continue;
            ++n11;
        }
        int n12 = 0;
        for (Unit f2 : gameState.getPhysicalGameState().getUnits()) {
            if (f2.getPlayer() != 1) continue;
            ++n12;
        }
        float f = evaluationFunction != null ? evaluationFunction.evaluate(0, 1, gameState) : 0.0f;
        float f2 = evaluationFunction != null ? evaluationFunction.evaluate(1, 0, gameState) : 0.0f;
        String string = "T: " + gameState.getTime() + ", P_0: " + n11 + " (" + f + "), P_1: " + n12 + " (" + f2 + ")";
        graphics2D.drawString(string, 10, n2 - 15);
        AffineTransform affineTransform = graphics2D.getTransform();
        if (physicalGameStatePanel != null) {
            physicalGameStatePanel.last_start_x = n / 2 - n9 / 2;
            physicalGameStatePanel.last_start_y = n2 / 2 - n10 / 2;
            physicalGameStatePanel.last_grid = n8;
            graphics2D.translate(physicalGameStatePanel.last_start_x, physicalGameStatePanel.last_start_y);
        } else {
            int color = n / 2 - n9 / 2;
            int color2 = n2 / 2 - n10 / 2;
            graphics2D.translate(color, color2);
        }
        Color color = null;
        Color color2 = new Color(0.0f, 0.33f, 0.0f);
        Color color3 = new Color(0.0f, 0.0f, 0.25f);
        Color color4 = new Color(0.25f, 0.0f, 0.0f);
        Color color5 = new Color(0.25f, 0.0f, 0.25f);
        for (linkedList = 0; linkedList < physicalGameState.getWidth(); ++linkedList) {
            for (int j = 0; j < physicalGameState.getHeight(); ++j) {
                if (!bl) {
                    if (n4 >= 0) {
                        if (partiallyObservableGameStateArray[n4].observable(linkedList, j)) {
                            if (n4 == 0) {
                                graphics2D.setColor(color3);
                                graphics2D.fillRect(linkedList * n8, j * n8, n8, n8);
                            } else {
                                graphics2D.setColor(color4);
                                graphics2D.fillRect(linkedList * n8, j * n8, n8, n8);
                            }
                        }
                    } else if (partiallyObservableGameStateArray[0].observable(linkedList, j)) {
                        if (partiallyObservableGameStateArray[1].observable(linkedList, j)) {
                            graphics2D.setColor(color5);
                            graphics2D.fillRect(linkedList * n8, j * n8, n8, n8);
                        } else {
                            graphics2D.setColor(color3);
                            graphics2D.fillRect(linkedList * n8, j * n8, n8, n8);
                        }
                    } else if (partiallyObservableGameStateArray[1].observable(linkedList, j)) {
                        graphics2D.setColor(color4);
                        graphics2D.fillRect(linkedList * n8, j * n8, n8, n8);
                    }
                }
                if (physicalGameState.getTerrain(linkedList, j) != 1) continue;
                graphics2D.setColor(color2);
                graphics2D.fillRect(linkedList * n8, j * n8, n8, n8);
            }
        }
        if (n3 == COLORSCHEME_BLACK) {
            graphics2D.setColor(Color.GRAY);
        }
        if (n3 == COLORSCHEME_WHITE) {
            graphics2D.setColor(Color.BLACK);
        }
        for (linkedList = 0; linkedList <= physicalGameState.getWidth(); ++linkedList) {
            graphics2D.drawLine(linkedList * n8, 0, linkedList * n8, physicalGameState.getHeight() * n8);
        }
        for (linkedList = 0; linkedList <= physicalGameState.getHeight(); ++linkedList) {
            graphics2D.drawLine(0, linkedList * n8, physicalGameState.getWidth() * n8, linkedList * n8);
        }
        LinkedList<Unit> linkedList2 = new LinkedList<Unit>();
        linkedList2.addAll(physicalGameState.getUnits());
        for (Unit unit : linkedList2) {
            int n5;
            int n13 = 0;
            if (!bl && n4 >= 0 && !partiallyObservableGameStateArray[n4].observable(unit.getX(), unit.getY())) continue;
            UnitActionAssignment unitActionAssignment = gameState.getActionAssignment(unit);
            if (unitActionAssignment != null) {
                int string3 = 0;
                int fontMetrics = 0;
                if (unitActionAssignment.action.getType() == 5) {
                    string3 = (unitActionAssignment.action.getLocationX() - unit.getX()) * n8;
                    fontMetrics = (unitActionAssignment.action.getLocationY() - unit.getY()) * n8;
                } else {
                    if (unitActionAssignment.action.getDirection() == 0) {
                        fontMetrics = -n8;
                    }
                    if (unitActionAssignment.action.getDirection() == 1) {
                        string3 = n8;
                    }
                    if (unitActionAssignment.action.getDirection() == 2) {
                        fontMetrics = n8;
                    }
                    if (unitActionAssignment.action.getDirection() == 3) {
                        string3 = -n8;
                    }
                }
                switch (unitActionAssignment.action.getType()) {
                    case 1: {
                        graphics2D.setColor(Color.GRAY);
                        graphics2D.drawLine(unit.getX() * n8 + n8 / 2, unit.getY() * n8 + n8 / 2, unit.getX() * n8 + n8 / 2 + string3, unit.getY() * n8 + n8 / 2 + fontMetrics);
                        break;
                    }
                    case 5: {
                        graphics2D.setColor(Color.RED);
                        graphics2D.drawLine(unit.getX() * n8 + n8 / 2, unit.getY() * n8 + n8 / 2, unit.getX() * n8 + n8 / 2 + string3, unit.getY() * n8 + n8 / 2 + fontMetrics);
                        break;
                    }
                    case 4: {
                        graphics2D.setColor(Color.BLUE);
                        graphics2D.drawLine(unit.getX() * n8 + n8 / 2, unit.getY() * n8 + n8 / 2, unit.getX() * n8 + n8 / 2 + string3, unit.getY() * n8 + n8 / 2 + fontMetrics);
                        n5 = unitActionAssignment.time + unitActionAssignment.action.ETA(unitActionAssignment.unit) - gameState.getTime();
                        graphics2D.setColor(Color.BLUE);
                        graphics2D.fillRect(unit.getX() * n8 + string3, unit.getY() * n8 + fontMetrics, n8 - (int)((float)n8 * ((float)n5 / (float)unitActionAssignment.action.ETA(unitActionAssignment.unit))), (int)((double)n8 / 5.0));
                        String string2 = unitActionAssignment.action.getUnitType().name;
                        graphics2D.setColor(Color.BLUE);
                        FontMetrics fontMetrics2 = graphics2D.getFontMetrics(graphics2D.getFont());
                        int n14 = fontMetrics2.stringWidth(string2);
                        graphics2D.drawString(string2, unit.getX() * n8 + n8 / 2 - n14 / 2 + string3, unit.getY() * n8 + n8 / 2 + fontMetrics);
                        break;
                    }
                    case 2: 
                    case 3: {
                        if (n3 == COLORSCHEME_BLACK) {
                            graphics2D.setColor(Color.WHITE);
                        }
                        if (n3 == COLORSCHEME_WHITE) {
                            graphics2D.setColor(Color.GREEN);
                        }
                        graphics2D.drawLine(unit.getX() * n8 + n8 / 2, unit.getY() * n8 + n8 / 2, unit.getX() * n8 + n8 / 2 + string3, unit.getY() * n8 + n8 / 2 + fontMetrics);
                    }
                }
            }
            if (unit.getPlayer() == 0) {
                color = Color.blue;
            } else if (unit.getPlayer() == 1) {
                color = Color.red;
            } else if (unit.getPlayer() == -1) {
                color = null;
            }
            if (unit.getType().name.equals("Resource")) {
                graphics2D.setColor(Color.green);
            }
            if (unit.getType().name.equals("Base")) {
                if (n3 == COLORSCHEME_BLACK) {
                    graphics2D.setColor(Color.white);
                }
                if (n3 == COLORSCHEME_WHITE) {
                    graphics2D.setColor(Color.lightGray);
                }
            }
            if (unit.getType().name.equals("Barracks")) {
                if (n3 == COLORSCHEME_BLACK) {
                    graphics2D.setColor(Color.lightGray);
                }
                if (n3 == COLORSCHEME_WHITE) {
                    graphics2D.setColor(Color.gray);
                }
            }
            if (unit.getType().name.equals("Worker")) {
                graphics2D.setColor(Color.gray);
                n13 = n8 / 4;
            }
            if (unit.getType().name.equals("Light")) {
                graphics2D.setColor(Color.orange);
                n13 = n8 / 8;
            }
            if (unit.getType().name.equals("Heavy")) {
                graphics2D.setColor(Color.yellow);
            }
            if (unit.getType().name.equals("Ranged")) {
                graphics2D.setColor(Color.cyan);
                n13 = n8 / 8;
            }
            if (!unit.getType().canMove) {
                graphics2D.fillRect(unit.getX() * n8 + n13, unit.getY() * n8 + n13, n8 - n13 * 2, n8 - n13 * 2);
                graphics2D.setColor(color);
                if (physicalGameStatePanel != null && physicalGameStatePanel.toHighLight.contains(unit)) {
                    graphics2D.setColor(Color.green);
                }
                graphics2D.drawRect(unit.getX() * n8 + n13, unit.getY() * n8 + n13, n8 - n13 * 2, n8 - n13 * 2);
            } else {
                graphics2D.fillOval(unit.getX() * n8 + n13, unit.getY() * n8 + n13, n8 - n13 * 2, n8 - n13 * 2);
                graphics2D.setColor(color);
                if (physicalGameStatePanel != null && physicalGameStatePanel.toHighLight.contains(unit)) {
                    graphics2D.setColor(Color.green);
                }
                graphics2D.drawOval(unit.getX() * n8 + n13, unit.getY() * n8 + n13, n8 - n13 * 2, n8 - n13 * 2);
            }
            if (unit.getType().isStockpile) {
                String string4 = "" + physicalGameState.getPlayer(unit.getPlayer()).getResources();
                graphics2D.setColor(Color.black);
                FontMetrics fontMetrics = graphics2D.getFontMetrics(graphics2D.getFont());
                n5 = fontMetrics.stringWidth(string4);
                graphics2D.drawString(string4, unit.getX() * n8 + n8 / 2 - n5 / 2, unit.getY() * n8 + n8 / 2);
            }
            if (unit.getResources() != 0) {
                String string3 = "" + unit.getResources();
                graphics2D.setColor(Color.black);
                FontMetrics fontMetrics = graphics2D.getFontMetrics(graphics2D.getFont());
                n5 = fontMetrics.stringWidth(string3);
                graphics2D.drawString(string3, unit.getX() * n8 + n8 / 2 - n5 / 2, unit.getY() * n8 + n8 / 2);
            }
            if (unit.getHitPoints() >= unit.getMaxHitPoints()) continue;
            graphics2D.setColor(Color.RED);
            graphics2D.fillRect(unit.getX() * n8, unit.getY() * n8, n8, (int)((double)n8 / 5.0));
            graphics2D.setColor(Color.GREEN);
            graphics2D.fillRect(unit.getX() * n8, unit.getY() * n8, (int)((float)n8 * ((float)unit.getHitPoints() / (float)unit.getMaxHitPoints())), (int)((double)n8 / 5.0));
        }
        graphics2D.setTransform(affineTransform);
    }

    public void resizeGameState(int n, int n2) {
        if (n >= 1 && n2 >= 1) {
            int n3;
            PhysicalGameState physicalGameState = this.gs.getPhysicalGameState();
            int[] nArray = new int[n * n2];
            for (n3 = 0; n3 < n * n2; ++n3) {
                nArray[n3] = 0;
            }
            for (n3 = 0; n3 < n2 && n3 < physicalGameState.getHeight(); ++n3) {
                for (int j = 0; j < n && j < physicalGameState.getWidth(); ++j) {
                    nArray[j + n3 * n] = physicalGameState.getTerrain(j, n3);
                }
            }
            ArrayList<Unit> arrayList = new ArrayList<Unit>();
            for (Unit unit : physicalGameState.getUnits()) {
                if (unit.getX() < n && unit.getY() < n2) continue;
                arrayList.add(unit);
            }
            for (Unit unit : arrayList) {
                this.gs.removeUnit(unit);
            }
            physicalGameState.setTerrain(nArray);
            physicalGameState.setWidth(n);
            physicalGameState.setHeight(n2);
            this.pogs[0] = new PartiallyObservableGameState(this.gs, 0);
            this.pogs[1] = new PartiallyObservableGameState(this.gs, 1);
        }
    }

    public void setFullObservability(boolean bl) {
        this.fullObservability = bl;
    }

    public void setDrawFromPerspectiveOfPlayer(int n) {
        this.drawFromPerspectiveOfPlayer = n;
    }

    public void gameStateUpdated() {
        if (this.gs != null) {
            this.pogs[0] = new PartiallyObservableGameState(this.gs, 0);
            this.pogs[1] = new PartiallyObservableGameState(this.gs, 1);
        } else {
            this.pogs[0] = null;
            this.pogs[1] = null;
        }
    }
}

