/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.PhysicalGameStatePanel;
import java.awt.Color;
import java.awt.Dimension;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import rts.GameState;
import rts.Trace;
import rts.TraceEntry;
import rts.UnitAction;
import rts.units.Unit;
import util.Pair;

public class TraceVisualizer
extends JPanel
implements ListSelectionListener {
    int current_step = 0;
    Trace trace = null;
    JPanel statePanel = null;
    JList Selector = null;
    List<GameState> states = new LinkedList<GameState>();

    public static JFrame newWindow(String string, int n, int n2, Trace trace, int n3) throws Exception {
        TraceVisualizer traceVisualizer = new TraceVisualizer(trace, n, n2, n3);
        JFrame jFrame = new JFrame(string);
        jFrame.getContentPane().add(traceVisualizer);
        jFrame.pack();
        jFrame.setDefaultCloseOperation(2);
        return jFrame;
    }

    public TraceVisualizer(Trace trace, int n, int n2, int n3) throws Exception {
        this.trace = trace;
        for (TraceEntry object2 : this.trace.getEntries()) {
            this.states.add(this.trace.getGameStateAtCycle(object2.getTime()));
        }
        this.setPreferredSize(new Dimension(n, n2));
        this.setSize(n, n2);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            System.out.println("Error setting native LAF: " + exception);
        }
        this.setBackground(Color.WHITE);
        this.removeAll();
        this.setLayout(new BoxLayout(this, 0));
        this.statePanel = new PhysicalGameStatePanel(new GameState(trace.getEntries().get(0).getPhysicalGameState(), trace.getUnitTypeTable()));
        this.statePanel.setPreferredSize(new Dimension((int)((double)n * 0.6), n2));
        this.add(this.statePanel);
        String[] stringArray = new String[trace.getEntries().size()];
        this.Selector = new JList();
        JScrollPane jScrollPane = new JScrollPane(this.Selector);
        for (int j = 0; j < trace.getEntries().size(); ++j) {
            if (!trace.getEntries().get(j).getActions().isEmpty()) {
                String string = "";
                for (Pair<Unit, UnitAction> pair : trace.getEntries().get(j).getActions()) {
                    string = string + "(" + ((Unit)pair.m_a).getID() + ", " + ((UnitAction)pair.m_b).getActionName() + "), ";
                }
                stringArray[j] = string;
                continue;
            }
            stringArray[j] = "-";
        }
        this.Selector.setListData(stringArray);
        this.Selector.addListSelectionListener(this);
        this.Selector.setSelectedIndex(0);
        this.Selector.setSelectionMode(0);
        this.add(jScrollPane);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = this.Selector.getSelectedIndex();
        ((PhysicalGameStatePanel)this.statePanel).setStateDirect(this.states.get(n));
        this.repaint();
    }
}

