/*
 * Decompiled with CFR 0.152.
 */
package gui.frontend;

import ai.BranchingFactorCalculatorBigInteger;
import ai.PassiveAI;
import ai.RandomAI;
import ai.RandomBiasedAI;
import ai.abstraction.HeavyDefense;
import ai.abstraction.HeavyRush;
import ai.abstraction.LightDefense;
import ai.abstraction.LightRush;
import ai.abstraction.RangedDefense;
import ai.abstraction.RangedRush;
import ai.abstraction.WorkerDefense;
import ai.abstraction.WorkerRush;
import ai.abstraction.WorkerRushPlusPlus;
import ai.abstraction.cRush.CRush_V1;
import ai.abstraction.cRush.CRush_V2;
import ai.abstraction.partialobservability.POHeavyRush;
import ai.abstraction.partialobservability.POLightRush;
import ai.abstraction.partialobservability.PORangedRush;
import ai.abstraction.partialobservability.POWorkerRush;
import ai.abstraction.pathfinding.AStarPathFinding;
import ai.abstraction.pathfinding.BFSPathFinding;
import ai.abstraction.pathfinding.FloodFillPathFinding;
import ai.abstraction.pathfinding.GreedyPathFinding;
import ai.abstraction.pathfinding.PathFinding;
import ai.ahtn.AHTNAI;
import ai.core.AI;
import ai.core.AIWithComputationBudget;
import ai.core.ContinuingAI;
import ai.core.InterruptibleAI;
import ai.core.ParameterSpecification;
import ai.core.PseudoContinuingAI;
import ai.evaluation.EvaluationFunction;
import ai.evaluation.EvaluationFunctionForwarding;
import ai.evaluation.SimpleEvaluationFunction;
import ai.evaluation.SimpleOptEvaluationFunction;
import ai.evaluation.SimpleSqrtEvaluationFunction;
import ai.evaluation.SimpleSqrtEvaluationFunction2;
import ai.evaluation.SimpleSqrtEvaluationFunction3;
import ai.mcts.believestatemcts.BS3_NaiveMCTS;
import ai.mcts.informedmcts.InformedNaiveMCTS;
import ai.mcts.mlps.MLPSMCTS;
import ai.mcts.naivemcts.NaiveMCTS;
import ai.mcts.uct.DownsamplingUCT;
import ai.mcts.uct.UCT;
import ai.mcts.uct.UCTFirstPlayUrgency;
import ai.mcts.uct.UCTUnitActions;
import ai.minimax.ABCD.IDABCD;
import ai.minimax.RTMiniMax.IDRTMinimax;
import ai.minimax.RTMiniMax.IDRTMinimaxRandomized;
import ai.montecarlo.MonteCarlo;
import ai.montecarlo.lsi.LSI;
import ai.portfolio.PortfolioAI;
import ai.portfolio.portfoliogreedysearch.PGSAI;
import ai.puppet.PuppetSearchMCTS;
import ai.scv.SCV;
import ai.stochastic.UnitActionProbabilityDistribution;
import gui.MouseController;
import gui.PhysicalGameStateMouseJFrame;
import gui.PhysicalGameStatePanel;
import gui.frontend.FEStateMouseListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;
import rts.GameState;
import rts.PartiallyObservableGameState;
import rts.PhysicalGameState;
import rts.PlayerAction;
import rts.PlayerActionGenerator;
import rts.Trace;
import rts.TraceEntry;
import rts.UnitAction;
import rts.units.Unit;
import rts.units.UnitTypeTable;
import tests.MapGenerator;
import util.Pair;
import util.XMLWriter;

public class FEStatePane
extends JPanel {
    PhysicalGameStatePanel statePanel = null;
    JTextArea textArea = null;
    UnitTypeTable currentUtt = null;
    JFileChooser fileChooser = new JFileChooser();
    EvaluationFunction[] efs = new EvaluationFunction[]{new SimpleEvaluationFunction(), new SimpleSqrtEvaluationFunction(), new SimpleSqrtEvaluationFunction2(), new SimpleSqrtEvaluationFunction3(), new EvaluationFunctionForwarding(new SimpleEvaluationFunction()), new SimpleOptEvaluationFunction()};
    public static Class[] AIs = new Class[]{PassiveAI.class, MouseController.class, RandomAI.class, RandomBiasedAI.class, WorkerRush.class, LightRush.class, HeavyRush.class, RangedRush.class, WorkerDefense.class, LightDefense.class, HeavyDefense.class, RangedDefense.class, POWorkerRush.class, POLightRush.class, POHeavyRush.class, PORangedRush.class, WorkerRushPlusPlus.class, CRush_V1.class, CRush_V2.class, PortfolioAI.class, PGSAI.class, IDRTMinimax.class, IDRTMinimaxRandomized.class, IDABCD.class, MonteCarlo.class, LSI.class, UCT.class, UCTUnitActions.class, UCTFirstPlayUrgency.class, DownsamplingUCT.class, NaiveMCTS.class, BS3_NaiveMCTS.class, MLPSMCTS.class, AHTNAI.class, InformedNaiveMCTS.class, PuppetSearchMCTS.class, SCV.class};
    Class[] PlayoutAIs = new Class[]{RandomAI.class, RandomBiasedAI.class, WorkerRush.class, LightRush.class, HeavyRush.class, RangedRush.class};
    PathFinding[] pathFinders = new PathFinding[]{new AStarPathFinding(), new BFSPathFinding(), new GreedyPathFinding(), new FloodFillPathFinding()};
    public static UnitTypeTable[] unitTypeTables = new UnitTypeTable[]{new UnitTypeTable(1, 1), new UnitTypeTable(1, 3), new UnitTypeTable(1, 2), new UnitTypeTable(2, 1), new UnitTypeTable(2, 3), new UnitTypeTable(2, 2), new UnitTypeTable(3, 1), new UnitTypeTable(3, 3), new UnitTypeTable(3, 2)};
    public static String[] unitTypeTableNames = new String[]{"Original-Both", "Original-Alternating", "Original-Random", "Finetuned-Both", "Finetuned-Alternating", "Finetuned-Random", "Nondeterministic-Both", "Nondeterministic-Alternating", "Nondeterministic-Random"};
    JFormattedTextField mapWidthField = null;
    JFormattedTextField mapHeightField = null;
    JFormattedTextField maxCyclesField = null;
    JFormattedTextField defaultDelayField = null;
    JCheckBox fullObservabilityBox = null;
    JComboBox unitTypeTableBox = null;
    JCheckBox saveTraceBox = null;
    JCheckBox slowDownBox = null;
    JComboBox[] aiComboBox = new JComboBox[]{null, null};
    JCheckBox[] continuingBox = new JCheckBox[]{null, null};
    JPanel[] AIOptionsPanel = new JPanel[]{null, null};
    HashMap[] AIOptionsPanelComponents = new HashMap[]{new HashMap(), new HashMap()};
    FEStateMouseListener mouseListener = null;

    public FEStatePane() throws Exception {
        Object object;
        JComponent jComponent;
        this.currentUtt = new UnitTypeTable();
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        Object object2 = new JPanel();
        ((Container)object2).setLayout(new BoxLayout((Container)object2, 0));
        Object object3 = new JButton("Clear");
        ((JComponent)object3).setAlignmentX(0.5f);
        ((JComponent)object3).setAlignmentY(0.0f);
        ((AbstractButton)object3).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GameState gameState = FEStatePane.this.statePanel.getState();
                gameState.getUnitActions().clear();
                PhysicalGameState physicalGameState = gameState.getPhysicalGameState();
                for (int j = 0; j < physicalGameState.getHeight(); ++j) {
                    for (int k = 0; k < physicalGameState.getWidth(); ++k) {
                        physicalGameState.setTerrain(k, j, 0);
                    }
                }
                physicalGameState.getUnits().clear();
                FEStatePane.this.statePanel.repaint();
            }
        });
        ((Container)object2).add((Component)object3);
        object3 = new JButton("Load");
        ((JComponent)object3).setAlignmentX(0.5f);
        ((JComponent)object3).setAlignmentY(0.0f);
        ((AbstractButton)object3).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = FEStatePane.this.fileChooser.showOpenDialog(null);
                if (n == 0) {
                    File file = FEStatePane.this.fileChooser.getSelectedFile();
                    try {
                        PhysicalGameState physicalGameState = PhysicalGameState.load(file.getAbsolutePath(), FEStatePane.this.currentUtt);
                        GameState gameState = new GameState(physicalGameState, FEStatePane.this.currentUtt);
                        FEStatePane.this.statePanel.setStateDirect(gameState);
                        FEStatePane.this.statePanel.repaint();
                        FEStatePane.this.mapWidthField.setText(physicalGameState.getWidth() + "");
                        FEStatePane.this.mapHeightField.setText(physicalGameState.getHeight() + "");
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        });
        ((Container)object2).add((Component)object3);
        object3 = new JButton("Save");
        ((JComponent)object3).setAlignmentX(0.5f);
        ((JComponent)object3).setAlignmentY(0.0f);
        ((AbstractButton)object3).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (FEStatePane.this.statePanel.getGameState() != null) {
                    int n = FEStatePane.this.fileChooser.showSaveDialog(null);
                    JFileChooser cfr_ignored_0 = FEStatePane.this.fileChooser;
                    if (n == 0) {
                        File file = FEStatePane.this.fileChooser.getSelectedFile();
                        try {
                            XMLWriter xMLWriter = new XMLWriter(new FileWriter(file.getAbsolutePath()));
                            FEStatePane.this.statePanel.getGameState().getPhysicalGameState().toxml(xMLWriter);
                            xMLWriter.flush();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            }
        });
        ((Container)object2).add((Component)object3);
        jPanel.add((Component)object2);
        object2 = new JPanel();
        ((Container)object2).setLayout(new BoxLayout((Container)object2, 0));
        this.mapWidthField = FEStatePane.addTextField((JPanel)object2, "Width:", "8", 4);
        this.mapWidthField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n = Integer.parseInt(FEStatePane.this.mapWidthField.getText());
                    FEStatePane.this.statePanel.resizeGameState(n, FEStatePane.this.statePanel.getGameState().getPhysicalGameState().getHeight());
                    FEStatePane.this.statePanel.repaint();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.mapHeightField = FEStatePane.addTextField((JPanel)object2, "Height:", "8", 4);
        this.mapHeightField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n = Integer.parseInt(FEStatePane.this.mapHeightField.getText());
                    FEStatePane.this.statePanel.resizeGameState(FEStatePane.this.statePanel.getGameState().getPhysicalGameState().getWidth(), n);
                    FEStatePane.this.statePanel.repaint();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        jPanel.add((Component)object2);
        object2 = new JPanel();
        ((Container)object2).setLayout(new BoxLayout((Container)object2, 0));
        object3 = new JButton("Move Player 0");
        ((JComponent)object3).setAlignmentX(0.5f);
        ((JComponent)object3).setAlignmentY(0.0f);
        ((AbstractButton)object3).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AI aI = FEStatePane.this.createAI(FEStatePane.this.aiComboBox[0].getSelectedIndex(), 0, FEStatePane.this.currentUtt);
                if (aI instanceof MouseController) {
                    FEStatePane.this.textArea.setText("Mouse controller is not allowed for this function.");
                    return;
                }
                try {
                    long l = System.currentTimeMillis();
                    aI.reset();
                    PlayerAction playerAction = aI.getAction(0, FEStatePane.this.statePanel.getGameState());
                    long l2 = System.currentTimeMillis();
                    FEStatePane.this.textArea.setText("Action generated with " + aI.getClass().getSimpleName() + " in " + (l2 - l) + "ms\n");
                    FEStatePane.this.textArea.append(aI.statisticsString() + "\n");
                    FEStatePane.this.textArea.append("Action:\n");
                    for (Pair<Unit, UnitAction> pair : playerAction.getActions()) {
                        FEStatePane.this.textArea.append("    " + pair.m_a + ": " + pair.m_b + "\n");
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        ((Container)object2).add((Component)object3);
        object3 = new JButton("Move Player 1");
        ((JComponent)object3).setAlignmentX(0.5f);
        ((JComponent)object3).setAlignmentY(0.0f);
        ((AbstractButton)object3).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AI aI = FEStatePane.this.createAI(FEStatePane.this.aiComboBox[1].getSelectedIndex(), 1, FEStatePane.this.currentUtt);
                if (aI instanceof MouseController) {
                    FEStatePane.this.textArea.setText("Mouse controller is not allowed for this function.");
                    return;
                }
                try {
                    long l = System.currentTimeMillis();
                    aI.reset();
                    PlayerAction playerAction = aI.getAction(0, FEStatePane.this.statePanel.getGameState());
                    long l2 = System.currentTimeMillis();
                    FEStatePane.this.textArea.setText("Action generated with " + aI.getClass().getSimpleName() + " in " + (l2 - l) + "ms\n");
                    FEStatePane.this.textArea.append(aI.statisticsString() + "\n");
                    FEStatePane.this.textArea.append("Action:\n");
                    for (Pair<Unit, UnitAction> pair : playerAction.getActions()) {
                        FEStatePane.this.textArea.append("    " + pair.m_a + ": " + pair.m_b + "\n");
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        ((Container)object2).add((Component)object3);
        object3 = new JButton("Analyze");
        ((JComponent)object3).setAlignmentX(0.5f);
        ((JComponent)object3).setAlignmentY(0.0f);
        ((AbstractButton)object3).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (FEStatePane.this.statePanel.getGameState() == null) {
                    FEStatePane.this.textArea.setText("Load a game state first");
                    return;
                }
                try {
                    FEStatePane.this.textArea.setText("");
                    FEStatePane.this.textArea.append("Evaluation functions:\n");
                    for (EvaluationFunction object : FEStatePane.this.efs) {
                        FEStatePane.this.textArea.append("  - " + object.getClass().getSimpleName() + ": " + object.evaluate(0, 1, FEStatePane.this.statePanel.getGameState()) + ", " + object.evaluate(1, 0, FEStatePane.this.statePanel.getGameState()) + "\n");
                    }
                    FEStatePane.this.textArea.append("\n");
                    int n = 0;
                    int n2 = 0;
                    for (Unit unit : FEStatePane.this.statePanel.getGameState().getUnits()) {
                        if (unit.getPlayer() == 0) {
                            ++n;
                        }
                        if (unit.getPlayer() != 1) continue;
                        ++n2;
                    }
                    FEStatePane.this.textArea.append("Player 0 has " + n + " units\n");
                    FEStatePane.this.textArea.append("Player 1 has " + n2 + " units\n\n");
                    FEStatePane.this.textArea.append("Braching Factor (BigInteger):\n");
                    FEStatePane.this.textArea.append("  - player 0: " + BranchingFactorCalculatorBigInteger.branchingFactorByResourceUsageSeparatingFast(FEStatePane.this.statePanel.getGameState(), 0) + "\n");
                    FEStatePane.this.textArea.append("  - player 1: " + BranchingFactorCalculatorBigInteger.branchingFactorByResourceUsageSeparatingFast(FEStatePane.this.statePanel.getGameState(), 1) + "\n");
                    FEStatePane.this.textArea.append("\n");
                    FEStatePane.this.textArea.append("Unit moves:\n");
                    FEStatePane.this.textArea.append("  - player 0:\n");
                    if (FEStatePane.this.statePanel.getGameState().canExecuteAnyAction(0)) {
                        PlayerActionGenerator playerActionGenerator = new PlayerActionGenerator(FEStatePane.this.statePanel.getGameState(), 0);
                        for (Pair<Unit, List<UnitAction>> pair : playerActionGenerator.getChoices()) {
                            FEStatePane.this.textArea.append("    " + pair.m_a + " has " + ((List)pair.m_b).size() + " actions: " + pair.m_b + "\n");
                        }
                        FEStatePane.this.textArea.append("\n");
                    }
                    FEStatePane.this.textArea.append("  - player 1:\n");
                    if (FEStatePane.this.statePanel.getGameState().canExecuteAnyAction(1)) {
                        PlayerActionGenerator playerActionGenerator = new PlayerActionGenerator(FEStatePane.this.statePanel.getGameState(), 1);
                        for (Pair<Unit, List<UnitAction>> pair : playerActionGenerator.getChoices()) {
                            FEStatePane.this.textArea.append("    " + pair.m_a + " has " + ((List)pair.m_b).size() + " actions: " + pair.m_b + "\n");
                        }
                        FEStatePane.this.textArea.append("\n");
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        ((Container)object2).add((Component)object3);
        jPanel.add((Component)object2);
        object2 = new String[]{"Color Scheme Black", "Color Scheme White"};
        object3 = new JComboBox<String>((E[])object2);
        ((JComponent)object3).setAlignmentX(0.5f);
        ((JComponent)object3).setAlignmentY(0.0f);
        ((JComboBox)object3).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                if (jComboBox.getSelectedIndex() == 0) {
                    FEStatePane.this.statePanel.setColorScheme(PhysicalGameStatePanel.COLORSCHEME_BLACK);
                }
                if (jComboBox.getSelectedIndex() == 1) {
                    FEStatePane.this.statePanel.setColorScheme(PhysicalGameStatePanel.COLORSCHEME_WHITE);
                }
                FEStatePane.this.statePanel.repaint();
            }
        });
        ((JComponent)object3).setMaximumSize(new Dimension(300, 24));
        jPanel.add((Component)object3);
        object2 = new JPanel();
        ((Container)object2).setLayout(new BoxLayout((Container)object2, 0));
        this.maxCyclesField = FEStatePane.addTextField((JPanel)object2, "Max Cycles:", "3000", 5);
        this.defaultDelayField = FEStatePane.addTextField((JPanel)object2, "Default Delay:", "10", 5);
        jPanel.add((Component)object2);
        object2 = new JPanel();
        ((Container)object2).setLayout(new BoxLayout((Container)object2, 0));
        this.fullObservabilityBox = new JCheckBox("Full Obsservability");
        this.fullObservabilityBox.setSelected(true);
        this.fullObservabilityBox.setAlignmentX(0.5f);
        this.fullObservabilityBox.setAlignmentY(0.0f);
        this.fullObservabilityBox.setMaximumSize(new Dimension(120, 20));
        this.fullObservabilityBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FEStatePane.this.statePanel.setFullObservability(FEStatePane.this.fullObservabilityBox.isSelected());
                FEStatePane.this.statePanel.repaint();
            }
        });
        ((Container)object2).add(this.fullObservabilityBox);
        this.slowDownBox = new JCheckBox("Slow Down");
        this.slowDownBox.setAlignmentX(0.5f);
        this.slowDownBox.setAlignmentY(0.0f);
        this.slowDownBox.setMaximumSize(new Dimension(120, 20));
        this.slowDownBox.setSelected(true);
        ((Container)object2).add(this.slowDownBox);
        jPanel.add((Component)object2);
        object2 = new JPanel();
        ((Container)object2).setLayout(new BoxLayout((Container)object2, 0));
        ((Container)object2).add(new JLabel("UnitTypeTable"));
        this.unitTypeTableBox = new JComboBox<String>(unitTypeTableNames);
        this.unitTypeTableBox.setAlignmentX(0.5f);
        this.unitTypeTableBox.setAlignmentY(0.5f);
        this.unitTypeTableBox.setMaximumSize(new Dimension(240, 20));
        this.unitTypeTableBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = FEStatePane.this.unitTypeTableBox.getSelectedIndex();
                UnitTypeTable unitTypeTable = unitTypeTables[n];
                GameState gameState = FEStatePane.this.statePanel.getGameState().cloneChangingUTT(unitTypeTable);
                if (gameState != null) {
                    FEStatePane.this.statePanel.setStateDirect(gameState);
                    FEStatePane.this.currentUtt = unitTypeTable;
                    FEStatePane.this.mouseListener.utt = unitTypeTable;
                } else {
                    System.err.println("Could not change unit type table!");
                }
            }
        });
        ((Container)object2).add(this.unitTypeTableBox);
        jPanel.add((Component)object2);
        object2 = new JPanel();
        ((Container)object2).setLayout(new BoxLayout((Container)object2, 0));
        object3 = new JButton("Start");
        ((JComponent)object3).setAlignmentX(0.5f);
        ((JComponent)object3).setAlignmentY(0.0f);
        ((JComponent)object3).setMaximumSize(new Dimension(120, 20));
        ((AbstractButton)object3).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Runnable runnable = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            Object object;
                            Object object2;
                            Object object3;
                            Object object4;
                            AI aI = FEStatePane.this.createAI(FEStatePane.this.aiComboBox[0].getSelectedIndex(), 0, FEStatePane.this.currentUtt);
                            AI aI2 = FEStatePane.this.createAI(FEStatePane.this.aiComboBox[1].getSelectedIndex(), 1, FEStatePane.this.currentUtt);
                            int n = Integer.parseInt(FEStatePane.this.defaultDelayField.getText());
                            int n2 = Integer.parseInt(FEStatePane.this.defaultDelayField.getText());
                            JFormattedTextField jFormattedTextField = (JFormattedTextField)FEStatePane.this.AIOptionsPanelComponents[0].get("TimeBudget");
                            JFormattedTextField jFormattedTextField2 = (JFormattedTextField)FEStatePane.this.AIOptionsPanelComponents[1].get("TimeBudget");
                            if (jFormattedTextField != null) {
                                n = Integer.parseInt(jFormattedTextField.getText());
                            }
                            if (jFormattedTextField2 != null) {
                                n2 = Integer.parseInt(jFormattedTextField2.getText());
                            }
                            int n3 = n + n2;
                            if (!FEStatePane.this.slowDownBox.isSelected()) {
                                n3 = 1;
                            }
                            int n4 = Integer.parseInt(FEStatePane.this.maxCyclesField.getText());
                            GameState gameState = FEStatePane.this.statePanel.getState().clone();
                            aI.preGameAnalysis(gameState, -1L);
                            aI2.preGameAnalysis(gameState, -1L);
                            boolean bl = false;
                            JFrame jFrame = null;
                            boolean bl2 = false;
                            if (aI instanceof MouseController) {
                                bl2 = true;
                            }
                            if (aI2 instanceof MouseController) {
                                bl2 = true;
                            }
                            if (aI instanceof PseudoContinuingAI && ((PseudoContinuingAI)aI).getbaseAI() instanceof MouseController) {
                                bl2 = true;
                            }
                            if (aI2 instanceof PseudoContinuingAI && ((PseudoContinuingAI)aI2).getbaseAI() instanceof MouseController) {
                                bl2 = true;
                            }
                            if (bl2) {
                                object4 = new PhysicalGameStatePanel(FEStatePane.this.statePanel);
                                ((PhysicalGameStatePanel)object4).setStateDirect(gameState);
                                jFrame = new PhysicalGameStateMouseJFrame("Game State Visualizer (Mouse)", 640, 640, (PhysicalGameStatePanel)object4);
                                boolean bl3 = false;
                                boolean bl4 = false;
                                if (aI instanceof MouseController) {
                                    ((MouseController)aI).setFrame((PhysicalGameStateMouseJFrame)jFrame);
                                    bl3 = true;
                                } else if (aI instanceof PseudoContinuingAI && ((PseudoContinuingAI)aI).getbaseAI() instanceof MouseController) {
                                    ((MouseController)((PseudoContinuingAI)aI).getbaseAI()).setFrame((PhysicalGameStateMouseJFrame)jFrame);
                                    bl3 = true;
                                }
                                if (aI2 instanceof MouseController) {
                                    ((MouseController)aI2).setFrame((PhysicalGameStateMouseJFrame)jFrame);
                                    bl4 = true;
                                } else if (aI2 instanceof PseudoContinuingAI && ((PseudoContinuingAI)aI2).getbaseAI() instanceof MouseController) {
                                    ((MouseController)((PseudoContinuingAI)aI2).getbaseAI()).setFrame((PhysicalGameStateMouseJFrame)jFrame);
                                    bl4 = true;
                                }
                                if (bl3 && !bl4) {
                                    ((PhysicalGameStatePanel)object4).setDrawFromPerspectiveOfPlayer(0);
                                }
                                if (!bl3 && bl4) {
                                    ((PhysicalGameStatePanel)object4).setDrawFromPerspectiveOfPlayer(1);
                                }
                            } else {
                                jFrame = PhysicalGameStatePanel.newVisualizer(gameState, 640, 640, !FEStatePane.this.fullObservabilityBox.isSelected(), FEStatePane.this.statePanel.getColorScheme());
                            }
                            object4 = null;
                            if (FEStatePane.this.saveTraceBox.isSelected()) {
                                object4 = new Trace(FEStatePane.this.currentUtt);
                                TraceEntry traceEntry = new TraceEntry(gameState.getPhysicalGameState().clone(), gameState.getTime());
                                ((Trace)object4).addEntry(traceEntry);
                            }
                            long l = System.currentTimeMillis() + (long)n3;
                            do {
                                if (System.currentTimeMillis() >= l) {
                                    object3 = null;
                                    object2 = null;
                                    if (FEStatePane.this.fullObservabilityBox.isSelected()) {
                                        object3 = aI.getAction(0, gameState);
                                        object2 = aI2.getAction(1, gameState);
                                    } else {
                                        object3 = aI.getAction(0, new PartiallyObservableGameState(gameState, 0));
                                        object2 = aI2.getAction(1, new PartiallyObservableGameState(gameState, 1));
                                    }
                                    if (!(object4 == null || ((PlayerAction)object3).isEmpty() && ((PlayerAction)object2).isEmpty())) {
                                        object = new TraceEntry(gameState.getPhysicalGameState().clone(), gameState.getTime());
                                        ((TraceEntry)object).addPlayerAction(((PlayerAction)object3).clone());
                                        ((TraceEntry)object).addPlayerAction(((PlayerAction)object2).clone());
                                        ((Trace)object4).addEntry((TraceEntry)object);
                                    }
                                    object = gameState;
                                    synchronized (object) {
                                        gameState.issueSafe((PlayerAction)object3);
                                        gameState.issueSafe((PlayerAction)object2);
                                    }
                                    object = gameState;
                                    synchronized (object) {
                                        bl = gameState.cycle();
                                    }
                                    jFrame.repaint();
                                    l += (long)n3;
                                    continue;
                                }
                                Thread.sleep(1L);
                            } while (jFrame.isVisible() && !bl && gameState.getTime() < n4);
                            if (object4 != null) {
                                object3 = new TraceEntry(gameState.getPhysicalGameState().clone(), gameState.getTime());
                                ((Trace)object4).addEntry((TraceEntry)object3);
                                object2 = FEStatePane.nextTraceName();
                                object = new XMLWriter(new FileWriter((String)object2));
                                ((Trace)object4).toxml((XMLWriter)object);
                                ((XMLWriter)object).flush();
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                };
                new Thread(runnable).start();
            }
        });
        ((Container)object2).add((Component)object3);
        this.saveTraceBox = new JCheckBox("Save Trace");
        this.saveTraceBox.setAlignmentX(0.5f);
        this.saveTraceBox.setAlignmentY(0.0f);
        this.saveTraceBox.setMaximumSize(new Dimension(120, 20));
        ((Container)object2).add(this.saveTraceBox);
        jPanel.add((Component)object2);
        for (int j = 0; j < 2; ++j) {
            jPanel.add(new JSeparator(0));
            object3 = new JPanel();
            ((Container)object3).setLayout(new BoxLayout((Container)object3, 0));
            jComponent = new JLabel("Player " + j + ":");
            jComponent.setAlignmentX(0.5f);
            jComponent.setAlignmentY(0.0f);
            ((Container)object3).add(jComponent);
            object = new String[AIs.length];
            for (int k = 0; k < AIs.length; ++k) {
                object[k] = AIs[k].getSimpleName();
            }
            this.aiComboBox[j] = new JComboBox<String>((E[])object);
            this.aiComboBox[j].setAlignmentX(0.5f);
            this.aiComboBox[j].setAlignmentY(0.0f);
            this.aiComboBox[j].setMaximumSize(new Dimension(300, 24));
            ((Container)object3).add(this.aiComboBox[j]);
            jPanel.add((Component)object3);
            this.continuingBox[j] = new JCheckBox("Continuing");
            this.continuingBox[j].setAlignmentX(0.5f);
            this.continuingBox[j].setAlignmentY(0.0f);
            this.continuingBox[j].setMaximumSize(new Dimension(120, 20));
            this.continuingBox[j].setSelected(true);
            jPanel.add(this.continuingBox[j]);
            this.AIOptionsPanel[j] = new JPanel();
            this.AIOptionsPanel[j].setLayout(new BoxLayout(this.AIOptionsPanel[j], 1));
            jPanel.add(this.AIOptionsPanel[j]);
            this.updateAIOptions(this.AIOptionsPanel[j], j);
        }
        this.aiComboBox[0].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    FEStatePane.this.updateAIOptions(FEStatePane.this.AIOptionsPanel[0], 0);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        this.aiComboBox[1].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    FEStatePane.this.updateAIOptions(FEStatePane.this.AIOptionsPanel[1], 1);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        MapGenerator mapGenerator = new MapGenerator(this.currentUtt);
        object3 = new GameState(mapGenerator.bases8x8(), this.currentUtt);
        jComponent = new JPanel();
        jComponent.setLayout(new BoxLayout(jComponent, 1));
        this.statePanel = new PhysicalGameStatePanel((GameState)object3);
        this.statePanel.setPreferredSize(new Dimension(512, 512));
        jComponent.add(this.statePanel);
        this.textArea = new JTextArea(5, 20);
        object = new JScrollPane(this.textArea);
        this.textArea.setEditable(false);
        ((JComponent)object).setPreferredSize(new Dimension(512, 192));
        jComponent.add((Component)object, "Center");
        this.add((Component)jPanel, "West");
        this.add((Component)jComponent, "East");
        this.mouseListener = new FEStateMouseListener(this.statePanel, this.currentUtt);
        this.statePanel.addMouseListener(this.mouseListener);
    }

    public void setState(GameState gameState) {
        this.statePanel.setStateDirect(gameState);
        this.statePanel.repaint();
        this.mapWidthField.setText(gameState.getPhysicalGameState().getWidth() + "");
        this.mapHeightField.setText(gameState.getPhysicalGameState().getHeight() + "");
    }

    private static String nextTraceName() {
        int n = 1;
        String string;
        File file;
        while ((file = new File(string = "trace" + n + ".xml")).exists()) {
            ++n;
        }
        return string;
    }

    public static JFormattedTextField addTextField(JPanel jPanel, String string, String string2, int n) {
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(new JLabel(string));
        JFormattedTextField jFormattedTextField = new JFormattedTextField();
        jFormattedTextField.setValue(string2);
        jFormattedTextField.setMaximumSize(new Dimension(80, 20));
        jPanel2.add(jFormattedTextField);
        jPanel.add(jPanel2);
        return jFormattedTextField;
    }

    public AI createAI(int n, int n2, UnitTypeTable unitTypeTable) {
        try {
            AI aI = this.createAIInternal(n, n2, unitTypeTable);
            List<ParameterSpecification> list = aI.getParameters();
            for (ParameterSpecification parameterSpecification : list) {
                Method method;
                Method method2;
                JComponent jComponent;
                if (parameterSpecification.type == Integer.TYPE) {
                    jComponent = (JFormattedTextField)this.AIOptionsPanelComponents[n2].get(parameterSpecification.name);
                    int n3 = Integer.parseInt(((JTextComponent)jComponent).getText());
                    method2 = aI.getClass().getMethod("set" + parameterSpecification.name, parameterSpecification.type);
                    method2.invoke((Object)aI, n3);
                    continue;
                }
                if (parameterSpecification.type == Long.TYPE) {
                    jComponent = (JFormattedTextField)this.AIOptionsPanelComponents[n2].get(parameterSpecification.name);
                    long l = Long.parseLong(((JTextComponent)jComponent).getText());
                    method = aI.getClass().getMethod("set" + parameterSpecification.name, parameterSpecification.type);
                    method.invoke((Object)aI, l);
                    continue;
                }
                if (parameterSpecification.type == Float.TYPE) {
                    jComponent = (JFormattedTextField)this.AIOptionsPanelComponents[n2].get(parameterSpecification.name);
                    float f = Float.parseFloat(((JTextComponent)jComponent).getText());
                    method2 = aI.getClass().getMethod("set" + parameterSpecification.name, parameterSpecification.type);
                    method2.invoke((Object)aI, Float.valueOf(f));
                    continue;
                }
                if (parameterSpecification.type == Double.TYPE) {
                    jComponent = (JFormattedTextField)this.AIOptionsPanelComponents[n2].get(parameterSpecification.name);
                    double d = Double.parseDouble(((JTextComponent)jComponent).getText());
                    method = aI.getClass().getMethod("set" + parameterSpecification.name, parameterSpecification.type);
                    method.invoke((Object)aI, d);
                    continue;
                }
                if (parameterSpecification.type == String.class) {
                    jComponent = (JFormattedTextField)this.AIOptionsPanelComponents[n2].get(parameterSpecification.name);
                    Method method3 = aI.getClass().getMethod("set" + parameterSpecification.name, parameterSpecification.type);
                    method3.invoke((Object)aI, ((JTextComponent)jComponent).getText());
                    continue;
                }
                if (parameterSpecification.type == Boolean.TYPE) {
                    jComponent = (JCheckBox)this.AIOptionsPanelComponents[n2].get(parameterSpecification.name);
                    Method method4 = aI.getClass().getMethod("set" + parameterSpecification.name, parameterSpecification.type);
                    method4.invoke((Object)aI, ((AbstractButton)jComponent).isSelected());
                    continue;
                }
                jComponent = (JComboBox)this.AIOptionsPanelComponents[n2].get(parameterSpecification.name);
                Method method5 = aI.getClass().getMethod("set" + parameterSpecification.name, parameterSpecification.type);
                method5.invoke((Object)aI, ((JComboBox)jComponent).getSelectedItem());
            }
            if (this.continuingBox[n2].isSelected() && aI instanceof AIWithComputationBudget) {
                aI = aI instanceof InterruptibleAI ? new ContinuingAI(aI) : new PseudoContinuingAI((AIWithComputationBudget)aI);
            }
            return aI;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public AI createAIInternal(int n, int n2, UnitTypeTable unitTypeTable) throws Exception {
        if (AIs[n] == MouseController.class) {
            return new MouseController(null);
        }
        Constructor constructor = AIs[n].getConstructor(UnitTypeTable.class);
        AI aI = (AI)constructor.newInstance(unitTypeTable);
        return aI;
    }

    private void updateAIOptions(JPanel jPanel, int n) throws Exception {
        HashMap hashMap = this.AIOptionsPanelComponents[n];
        jPanel.removeAll();
        hashMap.clear();
        AI aI = this.createAIInternal(this.aiComboBox[n].getSelectedIndex(), 0, this.currentUtt);
        List<ParameterSpecification> list = aI.getParameters();
        for (ParameterSpecification parameterSpecification : list) {
            JComboBox<Object> jComboBox;
            Object[] objectArray;
            int n2;
            JComponent jComponent;
            if (parameterSpecification.type == Integer.TYPE || parameterSpecification.type == Long.TYPE || parameterSpecification.type == Float.TYPE || parameterSpecification.type == Double.TYPE || parameterSpecification.type == String.class) {
                jComponent = FEStatePane.addTextField(jPanel, parameterSpecification.name, parameterSpecification.defaultValue.toString(), parameterSpecification.defaultValue.toString().length() + 1);
                hashMap.put(parameterSpecification.name, jComponent);
                continue;
            }
            if (parameterSpecification.type == Boolean.TYPE) {
                jComponent = new JCheckBox(parameterSpecification.name);
                jComponent.setAlignmentX(0.5f);
                jComponent.setAlignmentY(0.0f);
                jComponent.setMaximumSize(new Dimension(120, 20));
                ((AbstractButton)jComponent).setSelected((Boolean)parameterSpecification.defaultValue);
                jPanel.add(jComponent);
                hashMap.put(parameterSpecification.name, jComponent);
                continue;
            }
            if (parameterSpecification.type == PathFinding.class) {
                jComponent = new JPanel();
                jComponent.setLayout(new BoxLayout(jComponent, 0));
                jComponent.add(new JLabel(parameterSpecification.name));
                n2 = 0;
                objectArray = new PathFinding[this.pathFinders.length];
                for (int j = 0; j < this.pathFinders.length; ++j) {
                    objectArray[j] = this.pathFinders[j];
                    if (this.pathFinders[j].getClass() != parameterSpecification.defaultValue.getClass()) continue;
                    n2 = j;
                }
                jComboBox = new JComboBox<Object>(objectArray);
                jComboBox.setAlignmentX(0.5f);
                jComboBox.setAlignmentY(0.0f);
                jComboBox.setMaximumSize(new Dimension(300, 24));
                jComboBox.setSelectedIndex(n2);
                jComponent.add(jComboBox);
                jPanel.add(jComponent);
                hashMap.put(parameterSpecification.name, jComboBox);
                continue;
            }
            if (parameterSpecification.type == EvaluationFunction.class) {
                jComponent = new JPanel();
                jComponent.setLayout(new BoxLayout(jComponent, 0));
                jComponent.add(new JLabel(parameterSpecification.name));
                n2 = 0;
                objectArray = new EvaluationFunction[this.efs.length];
                for (int j = 0; j < this.efs.length; ++j) {
                    objectArray[j] = this.efs[j];
                    if (this.efs[j].getClass() != parameterSpecification.defaultValue.getClass()) continue;
                    n2 = j;
                }
                jComboBox = new JComboBox<Object>(objectArray);
                jComboBox.setAlignmentX(0.5f);
                jComboBox.setAlignmentY(0.0f);
                jComboBox.setMaximumSize(new Dimension(300, 24));
                jComboBox.setSelectedIndex(n2);
                jComponent.add(jComboBox);
                jPanel.add(jComponent);
                hashMap.put(parameterSpecification.name, jComboBox);
                continue;
            }
            if (parameterSpecification.type == AI.class) {
                int n3;
                jComponent = new JPanel();
                jComponent.setLayout(new BoxLayout(jComponent, 0));
                jComponent.add(new JLabel(parameterSpecification.name));
                n2 = 0;
                objectArray = null;
                if (parameterSpecification.possibleValues == null) {
                    objectArray = new AI[this.PlayoutAIs.length];
                    for (n3 = 0; n3 < this.PlayoutAIs.length; ++n3) {
                        objectArray[n3] = (AI)this.PlayoutAIs[n3].getConstructor(UnitTypeTable.class).newInstance(this.currentUtt);
                        if (this.PlayoutAIs[n3] != parameterSpecification.defaultValue.getClass()) continue;
                        n2 = n3;
                    }
                } else {
                    objectArray = new AI[parameterSpecification.possibleValues.size()];
                    for (n3 = 0; n3 < parameterSpecification.possibleValues.size(); ++n3) {
                        objectArray[n3] = (AI)parameterSpecification.possibleValues.get(n3);
                        if (parameterSpecification.possibleValues.get(n3) != parameterSpecification.defaultValue) continue;
                        n2 = n3;
                    }
                }
                jComboBox = new JComboBox<Object>(objectArray);
                jComboBox.setAlignmentX(0.5f);
                jComboBox.setAlignmentY(0.0f);
                jComboBox.setMaximumSize(new Dimension(300, 24));
                jComboBox.setSelectedIndex(n2);
                jComponent.add(jComboBox);
                jPanel.add(jComponent);
                hashMap.put(parameterSpecification.name, jComboBox);
                continue;
            }
            if (parameterSpecification.type == UnitActionProbabilityDistribution.class) {
                jComponent = new JPanel();
                jComponent.setLayout(new BoxLayout(jComponent, 0));
                jComponent.add(new JLabel(parameterSpecification.name));
                n2 = 0;
                objectArray = null;
                objectArray = new UnitActionProbabilityDistribution[parameterSpecification.possibleValues.size()];
                for (int j = 0; j < parameterSpecification.possibleValues.size(); ++j) {
                    objectArray[j] = (UnitActionProbabilityDistribution)parameterSpecification.possibleValues.get(j);
                    if (parameterSpecification.possibleValues.get(j) != parameterSpecification.defaultValue) continue;
                    n2 = j;
                }
                jComboBox = new JComboBox<Object>(objectArray);
                jComboBox.setAlignmentX(0.5f);
                jComboBox.setAlignmentY(0.0f);
                jComboBox.setMaximumSize(new Dimension(300, 24));
                jComboBox.setSelectedIndex(n2);
                jComponent.add(jComboBox);
                jPanel.add(jComponent);
                hashMap.put(parameterSpecification.name, jComboBox);
                continue;
            }
            if (parameterSpecification.possibleValues != null) {
                jComponent = new JPanel();
                jComponent.setLayout(new BoxLayout(jComponent, 0));
                jComponent.add(new JLabel(parameterSpecification.name));
                n2 = 0;
                objectArray = new Object[parameterSpecification.possibleValues.size()];
                for (int j = 0; j < parameterSpecification.possibleValues.size(); ++j) {
                    objectArray[j] = parameterSpecification.possibleValues.get(j);
                    if (!parameterSpecification.possibleValues.get(j).equals(parameterSpecification.defaultValue)) continue;
                    n2 = j;
                }
                jComboBox = new JComboBox<Object>(objectArray);
                jComboBox.setAlignmentX(0.5f);
                jComboBox.setAlignmentY(0.0f);
                jComboBox.setMaximumSize(new Dimension(300, 24));
                jComboBox.setSelectedIndex(n2);
                jComponent.add(jComboBox);
                jPanel.add(jComponent);
                hashMap.put(parameterSpecification.name, jComboBox);
                continue;
            }
            throw new Exception("Cannot create GUI component for class" + parameterSpecification.type.getName());
        }
        jPanel.revalidate();
    }
}

