/*
 * Decompiled with CFR 0.152.
 */
package gui.frontend;

import ai.core.AI;
import gui.JTextAreaWriter;
import gui.frontend.FEStatePane;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.text.DefaultCaret;
import rts.units.UnitTypeTable;
import tournaments.FixedOpponentsTournament;
import tournaments.LoadTournamentAIs;
import tournaments.RoundRobinTournament;

public class FETournamentPane
extends JPanel {
    public static final String TOURNAMENT_ROUNDROBIN = "Round Robin";
    public static final String TOURNAMENT_FIXED_OPPONENTS = "Fixed Opponents";
    JComboBox tournamentTypeComboBox = null;
    DefaultListModel availableAIsListModel = null;
    JList availableAIsList = null;
    DefaultListModel selectedAIsListModel = null;
    JList selectedAIsList = null;
    DefaultListModel opponentAIsListModel = null;
    JList opponentAIsList = null;
    JButton opponentAddButton = null;
    JButton opponentRemoveButton = null;
    JFileChooser mapFileChooser = new JFileChooser();
    JList mapList = null;
    DefaultListModel mapListModel = null;
    JFormattedTextField iterationsField = null;
    JFormattedTextField maxGameLengthField = null;
    JFormattedTextField timeBudgetField = null;
    JFormattedTextField iterationsBudgetField = null;
    JFormattedTextField preAnalysisTimeField = null;
    JComboBox unitTypeTableBox = null;
    JCheckBox fullObservabilityCheckBox = null;
    JCheckBox selfMatchesCheckBox = null;
    JCheckBox timeoutCheckBox = null;
    JCheckBox gcCheckBox = null;
    JCheckBox tracesCheckBox = null;
    JTextArea tournamentProgressTextArea = null;
    JFileChooser fileChooser = new JFileChooser();

    public FETournamentPane() {
        this.setLayout(new BoxLayout(this, 1));
        Object object = new String[]{TOURNAMENT_ROUNDROBIN, TOURNAMENT_FIXED_OPPONENTS};
        this.tournamentTypeComboBox = new JComboBox<String>((E[])object);
        this.tournamentTypeComboBox.setAlignmentX(0.5f);
        this.tournamentTypeComboBox.setAlignmentY(0.0f);
        this.tournamentTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                if (jComboBox.getSelectedIndex() == 1) {
                    FETournamentPane.this.opponentAIsList.setEnabled(true);
                    FETournamentPane.this.opponentAddButton.setEnabled(true);
                    FETournamentPane.this.opponentRemoveButton.setEnabled(true);
                } else {
                    FETournamentPane.this.opponentAIsList.setEnabled(false);
                    FETournamentPane.this.opponentAddButton.setEnabled(false);
                    FETournamentPane.this.opponentRemoveButton.setEnabled(false);
                }
            }
        });
        this.tournamentTypeComboBox.setMaximumSize(new Dimension(300, 24));
        this.add(this.tournamentTypeComboBox);
        object = new JPanel();
        ((Container)object).setLayout(new BoxLayout((Container)object, 0));
        JComponent jComponent = new JPanel();
        jComponent.setLayout(new BoxLayout(jComponent, 1));
        jComponent.add(new JLabel("Available AIs"));
        this.availableAIsListModel = new DefaultListModel();
        for (int j = 0; j < FEStatePane.AIs.length; ++j) {
            this.availableAIsListModel.addElement(FEStatePane.AIs[j]);
        }
        this.availableAIsList = new JList(this.availableAIsListModel);
        this.availableAIsList.setSelectionMode(2);
        this.availableAIsList.setLayoutOrientation(0);
        this.availableAIsList.setVisibleRowCount(-1);
        Serializable serializable = new JScrollPane(this.availableAIsList);
        ((JComponent)serializable).setPreferredSize(new Dimension(200, 200));
        jComponent.add((Component)serializable);
        JButton jButton = new JButton("Load Specific JAR");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FETournamentPane.this.fileChooser.setFileSelectionMode(0);
                int n = FETournamentPane.this.fileChooser.showOpenDialog(null);
                if (n == 0) {
                    File file = FETournamentPane.this.fileChooser.getSelectedFile();
                    try {
                        List<Class> list = LoadTournamentAIs.loadTournamentAIsFromJAR(file.getAbsolutePath());
                        for (Class clazz : list) {
                            boolean bl = false;
                            for (int j = 0; j < FETournamentPane.this.availableAIsListModel.size(); ++j) {
                                Class clazz2 = (Class)FETournamentPane.this.availableAIsListModel.get(j);
                                if (!clazz2.getName().equals(clazz.getName())) continue;
                                bl = true;
                                break;
                            }
                            if (bl) continue;
                            FETournamentPane.this.availableAIsListModel.addElement(clazz);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        });
        jComponent.add(jButton);
        JButton jButton2 = new JButton("Load All JARS from Folder");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FETournamentPane.this.fileChooser.setFileSelectionMode(1);
                int n = FETournamentPane.this.fileChooser.showOpenDialog(null);
                if (n == 0) {
                    File file = FETournamentPane.this.fileChooser.getSelectedFile();
                    try {
                        List<Class> list = LoadTournamentAIs.loadTournamentAIsFromFolder(file.getAbsolutePath());
                        for (Class clazz : list) {
                            boolean bl = false;
                            for (int j = 0; j < FETournamentPane.this.availableAIsListModel.size(); ++j) {
                                Class clazz2 = (Class)FETournamentPane.this.availableAIsListModel.get(j);
                                if (!clazz2.getName().equals(clazz.getName())) continue;
                                bl = true;
                                break;
                            }
                            if (bl) continue;
                            FETournamentPane.this.availableAIsListModel.addElement(clazz);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        });
        jComponent.add(jButton2);
        ((Container)object).add(jComponent);
        jComponent = new JPanel();
        jComponent.setLayout(new BoxLayout(jComponent, 1));
        jComponent.add(new JLabel("Selected AIs"));
        this.selectedAIsListModel = new DefaultListModel();
        this.selectedAIsList = new JList(this.selectedAIsListModel);
        this.selectedAIsList.setSelectionMode(0);
        this.selectedAIsList.setLayoutOrientation(0);
        this.selectedAIsList.setVisibleRowCount(-1);
        serializable = new JScrollPane(this.selectedAIsList);
        ((JComponent)serializable).setPreferredSize(new Dimension(200, 200));
        jComponent.add((Component)serializable);
        jButton = new JButton("+");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray;
                for (int n : nArray = FETournamentPane.this.availableAIsList.getSelectedIndices()) {
                    FETournamentPane.this.selectedAIsListModel.addElement(FETournamentPane.this.availableAIsList.getModel().getElementAt(n));
                }
            }
        });
        jComponent.add(jButton);
        jButton2 = new JButton("-");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = FETournamentPane.this.selectedAIsList.getSelectedIndex();
                if (n >= 0) {
                    FETournamentPane.this.selectedAIsListModel.remove(n);
                }
            }
        });
        jComponent.add(jButton2);
        ((Container)object).add(jComponent);
        jComponent = new JPanel();
        jComponent.setLayout(new BoxLayout(jComponent, 1));
        jComponent.add(new JLabel("Opponent AIs"));
        this.opponentAIsListModel = new DefaultListModel();
        this.opponentAIsList = new JList(this.opponentAIsListModel);
        this.opponentAIsList.setSelectionMode(2);
        this.opponentAIsList.setLayoutOrientation(0);
        this.opponentAIsList.setVisibleRowCount(-1);
        serializable = new JScrollPane(this.opponentAIsList);
        ((JComponent)serializable).setPreferredSize(new Dimension(200, 200));
        jComponent.add((Component)serializable);
        this.opponentAddButton = new JButton("+");
        this.opponentAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray;
                for (int n : nArray = FETournamentPane.this.availableAIsList.getSelectedIndices()) {
                    FETournamentPane.this.opponentAIsListModel.addElement(FETournamentPane.this.availableAIsList.getModel().getElementAt(n));
                }
            }
        });
        jComponent.add(this.opponentAddButton);
        this.opponentRemoveButton = new JButton("-");
        this.opponentRemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = FETournamentPane.this.opponentAIsList.getSelectedIndex();
                if (n >= 0) {
                    FETournamentPane.this.opponentAIsListModel.remove(n);
                }
            }
        });
        jComponent.add(this.opponentRemoveButton);
        ((Container)object).add(jComponent);
        this.opponentAIsList.setEnabled(false);
        this.opponentAddButton.setEnabled(false);
        this.opponentRemoveButton.setEnabled(false);
        this.add((Component)object);
        this.add(new JSeparator(0));
        object = new JPanel();
        ((Container)object).setLayout(new BoxLayout((Container)object, 0));
        jComponent = new JPanel();
        jComponent.setLayout(new BoxLayout(jComponent, 1));
        jComponent.add(new JLabel("Maps"));
        this.mapListModel = new DefaultListModel();
        this.mapList = new JList(this.mapListModel);
        this.mapList.setSelectionMode(0);
        this.mapList.setLayoutOrientation(0);
        this.mapList.setVisibleRowCount(-1);
        serializable = new JScrollPane(this.mapList);
        ((JComponent)serializable).setPreferredSize(new Dimension(200, 100));
        jComponent.add((Component)serializable);
        jButton = new JButton("+");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = FETournamentPane.this.mapFileChooser.showOpenDialog(null);
                if (n == 0) {
                    File file = FETournamentPane.this.mapFileChooser.getSelectedFile();
                    try {
                        FETournamentPane.this.mapListModel.addElement(file.getPath());
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        });
        jComponent.add(jButton);
        jButton2 = new JButton("-");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = FETournamentPane.this.mapList.getSelectedIndex();
                if (n >= 0) {
                    FETournamentPane.this.mapListModel.remove(n);
                }
            }
        });
        jComponent.add(jButton2);
        ((Container)object).add(jComponent);
        ((Container)object).add(new JSeparator(1));
        jComponent = new JPanel();
        jComponent.setLayout(new BoxLayout(jComponent, 1));
        this.iterationsField = FEStatePane.addTextField((JPanel)jComponent, "Iterations:", "10", 4);
        this.maxGameLengthField = FEStatePane.addTextField((JPanel)jComponent, "Max Game Length:", "3000", 4);
        this.timeBudgetField = FEStatePane.addTextField((JPanel)jComponent, "Time Budget:", "100", 5);
        this.iterationsBudgetField = FEStatePane.addTextField((JPanel)jComponent, "Iterations Budget:", "-1", 8);
        this.preAnalysisTimeField = FEStatePane.addTextField((JPanel)jComponent, "pre-Analisys time budget:", "1000", 8);
        jComponent.setMaximumSize(new Dimension(1000, 1000));
        ((Container)object).add(jComponent);
        ((Container)object).add(new JSeparator(1));
        jComponent = new JPanel();
        jComponent.setLayout(new BoxLayout(jComponent, 1));
        serializable = new JPanel();
        ((Container)serializable).setLayout(new BoxLayout((Container)serializable, 0));
        ((Container)serializable).add(new JLabel("UnitTypeTable"));
        this.unitTypeTableBox = new JComboBox<String>(FEStatePane.unitTypeTableNames);
        this.unitTypeTableBox.setAlignmentX(0.5f);
        this.unitTypeTableBox.setAlignmentY(0.5f);
        this.unitTypeTableBox.setMaximumSize(new Dimension(160, 20));
        ((Container)serializable).add(this.unitTypeTableBox);
        jComponent.setMaximumSize(new Dimension(1000, 1000));
        jComponent.add((Component)serializable);
        this.fullObservabilityCheckBox = new JCheckBox("Full Obsservability");
        this.fullObservabilityCheckBox.setSelected(true);
        jComponent.add(this.fullObservabilityCheckBox);
        this.selfMatchesCheckBox = new JCheckBox("Include self-play matches");
        this.selfMatchesCheckBox.setSelected(false);
        jComponent.add(this.selfMatchesCheckBox);
        this.timeoutCheckBox = new JCheckBox("Game over if AI times out");
        this.timeoutCheckBox.setSelected(true);
        jComponent.add(this.timeoutCheckBox);
        this.gcCheckBox = new JCheckBox("Call garbage collector right before each AI call");
        this.gcCheckBox.setSelected(false);
        jComponent.add(this.gcCheckBox);
        this.tracesCheckBox = new JCheckBox("Save game traces");
        this.tracesCheckBox.setSelected(false);
        jComponent.add(this.tracesCheckBox);
        ((Container)object).add(jComponent);
        this.add((Component)object);
        object = new JButton("Run Tournament");
        this.add((Component)object);
        ((AbstractButton)object).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    String string;
                    File file;
                    Constructor constructor;
                    Object object;
                    int n;
                    final UnitTypeTable unitTypeTable = FEStatePane.unitTypeTables[FETournamentPane.this.unitTypeTableBox.getSelectedIndex()];
                    String string2 = (String)FETournamentPane.this.tournamentTypeComboBox.getSelectedItem();
                    final ArrayList<AI> arrayList = new ArrayList<AI>();
                    final ArrayList<AI> arrayList2 = new ArrayList<AI>();
                    final ArrayList<Object> arrayList3 = new ArrayList<Object>();
                    for (n = 0; n < FETournamentPane.this.selectedAIsListModel.getSize(); ++n) {
                        object = (Class)FETournamentPane.this.selectedAIsListModel.get(n);
                        constructor = ((Class)object).getConstructor(UnitTypeTable.class);
                        arrayList.add((AI)constructor.newInstance(unitTypeTable));
                    }
                    for (n = 0; n < FETournamentPane.this.opponentAIsListModel.getSize(); ++n) {
                        object = (Class)FETournamentPane.this.opponentAIsListModel.get(n);
                        constructor = ((Class)object).getConstructor(UnitTypeTable.class);
                        arrayList2.add((AI)constructor.newInstance(unitTypeTable));
                    }
                    for (n = 0; n < FETournamentPane.this.mapListModel.getSize(); ++n) {
                        object = (String)FETournamentPane.this.mapListModel.getElementAt(n);
                        arrayList3.add(object);
                    }
                    n = Integer.parseInt(FETournamentPane.this.iterationsField.getText());
                    final int n2 = Integer.parseInt(FETournamentPane.this.maxGameLengthField.getText());
                    final int n3 = Integer.parseInt(FETournamentPane.this.timeBudgetField.getText());
                    final int n4 = Integer.parseInt(FETournamentPane.this.iterationsBudgetField.getText());
                    final int n5 = Integer.parseInt(FETournamentPane.this.preAnalysisTimeField.getText());
                    final boolean bl = FETournamentPane.this.fullObservabilityCheckBox.isSelected();
                    final boolean bl2 = FETournamentPane.this.selfMatchesCheckBox.isSelected();
                    final boolean bl3 = FETournamentPane.this.timeoutCheckBox.isSelected();
                    final boolean bl4 = FETournamentPane.this.gcCheckBox.isSelected();
                    final boolean bl5 = n5 > 0;
                    String string3 = "tournament_";
                    int n6 = 0;
                    while ((file = new File(string3 + ++n6)).exists()) {
                    }
                    file.mkdir();
                    final String string4 = file.getName();
                    final File file2 = new File(string4 + "/tournament.csv");
                    String string5 = string = FETournamentPane.this.tracesCheckBox.isSelected() ? string4 + "/traces" : null;
                    if (string2.equals(FETournamentPane.TOURNAMENT_ROUNDROBIN)) {
                        if (arrayList.size() < 2) {
                            FETournamentPane.this.tournamentProgressTextArea.append("Select at least two AIs\n");
                        } else if (arrayList3.isEmpty()) {
                            FETournamentPane.this.tournamentProgressTextArea.append("Select at least one map\n");
                        } else {
                            try {
                                Runnable runnable = new Runnable(){

                                    @Override
                                    public void run() {
                                        try {
                                            FileWriter fileWriter = new FileWriter(file2);
                                            JTextAreaWriter jTextAreaWriter = new JTextAreaWriter(FETournamentPane.this.tournamentProgressTextArea);
                                            RoundRobinTournament.runTournament(arrayList, -1, arrayList3, n, n2, n3, n4, n5, 1000L, bl, bl2, bl3, bl4, bl5, unitTypeTable, string, fileWriter, jTextAreaWriter, string4);
                                            ((Writer)fileWriter).close();
                                        }
                                        catch (Exception exception) {
                                            exception.printStackTrace();
                                        }
                                    }
                                };
                                new Thread(runnable).start();
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                    } else if (string2.equals(FETournamentPane.TOURNAMENT_FIXED_OPPONENTS)) {
                        if (arrayList.isEmpty()) {
                            FETournamentPane.this.tournamentProgressTextArea.append("Select at least one AI\n");
                        } else if (arrayList2.isEmpty()) {
                            FETournamentPane.this.tournamentProgressTextArea.append("Select at least one opponent AI\n");
                        } else if (arrayList3.isEmpty()) {
                            FETournamentPane.this.tournamentProgressTextArea.append("Select at least one map\n");
                        } else {
                            try {
                                Runnable runnable = new Runnable(){

                                    @Override
                                    public void run() {
                                        try {
                                            FileWriter fileWriter = new FileWriter(file2);
                                            JTextAreaWriter jTextAreaWriter = new JTextAreaWriter(FETournamentPane.this.tournamentProgressTextArea);
                                            FixedOpponentsTournament.runTournament(arrayList, arrayList2, arrayList3, n, n2, n3, n4, n5, 1000L, bl, bl3, bl4, bl5, unitTypeTable, string, fileWriter, jTextAreaWriter, string4);
                                            ((Writer)fileWriter).close();
                                        }
                                        catch (Exception exception) {
                                            exception.printStackTrace();
                                        }
                                    }
                                };
                                new Thread(runnable).start();
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        this.tournamentProgressTextArea = new JTextArea(5, 20);
        jComponent = new JScrollPane(this.tournamentProgressTextArea);
        this.tournamentProgressTextArea.setEditable(false);
        jComponent.setPreferredSize(new Dimension(512, 192));
        this.add(jComponent);
        serializable = (DefaultCaret)this.tournamentProgressTextArea.getCaret();
        ((DefaultCaret)serializable).setUpdatePolicy(2);
    }
}

