/*
 * Decompiled with CFR 0.152.
 */
package gui.frontend;

import gui.PhysicalGameStatePanel;
import gui.frontend.FEStatePane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.util.zip.ZipInputStream;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import org.jdom.input.SAXBuilder;
import rts.GameState;
import rts.Trace;
import rts.TraceEntry;
import util.XMLWriter;

public class FETracePane
extends JPanel {
    Trace currentTrace = null;
    int currentGameCycle = 0;
    PhysicalGameStatePanel statePanel = null;
    JFileChooser fileChooser = new JFileChooser();
    FEStatePane stateTab = null;

    public FETracePane(FEStatePane fEStatePane) {
        this.stateTab = fEStatePane;
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JComponent jComponent = new JButton("Load Trace");
        jComponent.setAlignmentX(0.5f);
        jComponent.setAlignmentY(0.0f);
        ((AbstractButton)jComponent).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = FETracePane.this.fileChooser.showOpenDialog(null);
                if (n == 0) {
                    File file = FETracePane.this.fileChooser.getSelectedFile();
                    try {
                        if (file.getAbsolutePath().endsWith(".zip")) {
                            ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(file));
                            zipInputStream.getNextEntry();
                            FETracePane.this.currentTrace = new Trace(new SAXBuilder().build(zipInputStream).getRootElement());
                        } else {
                            FETracePane.this.currentTrace = new Trace(new SAXBuilder().build(file.getAbsolutePath()).getRootElement());
                        }
                        FETracePane.this.currentGameCycle = 0;
                        FETracePane.this.statePanel.setStateDirect(FETracePane.this.currentTrace.getGameStateAtCycle(FETracePane.this.currentGameCycle));
                        FETracePane.this.statePanel.repaint();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        });
        jPanel2.add(jComponent);
        jComponent = new JButton("Save State");
        jComponent.setAlignmentX(0.5f);
        jComponent.setAlignmentY(0.0f);
        ((AbstractButton)jComponent).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = FETracePane.this.fileChooser.showSaveDialog(null);
                JFileChooser cfr_ignored_0 = FETracePane.this.fileChooser;
                if (n == 0) {
                    File file = FETracePane.this.fileChooser.getSelectedFile();
                    try {
                        XMLWriter xMLWriter = new XMLWriter(new FileWriter(file.getAbsolutePath()));
                        FETracePane.this.statePanel.getState().getPhysicalGameState().toxml(xMLWriter);
                        xMLWriter.flush();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        });
        jPanel2.add(jComponent);
        jComponent = new JButton("Copy to state tab");
        jComponent.setAlignmentX(0.5f);
        jComponent.setAlignmentY(0.0f);
        ((AbstractButton)jComponent).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FETracePane.this.stateTab.setState(FETracePane.this.statePanel.getState().clone());
            }
        });
        jPanel2.add(jComponent);
        jComponent = new JPanel();
        jComponent.setLayout(new BoxLayout(jComponent, 1));
        JComponent jComponent2 = new JButton("+1 Frame");
        jComponent2.setAlignmentX(0.5f);
        jComponent2.setAlignmentY(0.0f);
        ((AbstractButton)jComponent2).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!FETracePane.this.statePanel.getState().gameover()) {
                    ++FETracePane.this.currentGameCycle;
                    GameState gameState = FETracePane.this.currentTrace.getGameStateAtCycle(FETracePane.this.currentGameCycle);
                    FETracePane.this.statePanel.setStateDirect(gameState);
                    FETracePane.this.statePanel.repaint();
                }
            }
        });
        jComponent.add(jComponent2);
        jComponent2 = new JButton("-1 Frame");
        jComponent2.setAlignmentX(0.5f);
        jComponent2.setAlignmentY(0.0f);
        ((AbstractButton)jComponent2).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (FETracePane.this.currentGameCycle > 0) {
                    --FETracePane.this.currentGameCycle;
                    FETracePane.this.statePanel.setStateDirect(FETracePane.this.currentTrace.getGameStateAtCycle(FETracePane.this.currentGameCycle));
                    FETracePane.this.statePanel.repaint();
                }
            }
        });
        jComponent.add(jComponent2);
        jComponent2 = new JButton("+1 Action");
        jComponent2.setAlignmentX(0.5f);
        jComponent2.setAlignmentY(0.0f);
        ((AbstractButton)jComponent2).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (TraceEntry traceEntry : FETracePane.this.currentTrace.getEntries()) {
                    if (traceEntry.getTime() <= FETracePane.this.currentGameCycle) continue;
                    FETracePane.this.currentGameCycle = traceEntry.getTime();
                    FETracePane.this.statePanel.setStateDirect(FETracePane.this.currentTrace.getGameStateAtCycle(FETracePane.this.currentGameCycle));
                    FETracePane.this.statePanel.repaint();
                    break;
                }
            }
        });
        jComponent.add(jComponent2);
        jComponent2 = new JButton("-1 Action");
        jComponent2.setAlignmentX(0.5f);
        jComponent2.setAlignmentY(0.0f);
        ((AbstractButton)jComponent2).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TraceEntry traceEntry = null;
                for (TraceEntry traceEntry2 : FETracePane.this.currentTrace.getEntries()) {
                    if (traceEntry2.getTime() >= FETracePane.this.currentGameCycle || traceEntry != null && traceEntry2.getTime() <= traceEntry.getTime()) continue;
                    traceEntry = traceEntry2;
                }
                if (traceEntry != null) {
                    FETracePane.this.currentGameCycle = traceEntry.getTime();
                    FETracePane.this.statePanel.setStateDirect(FETracePane.this.currentTrace.getGameStateAtCycle(FETracePane.this.currentGameCycle));
                    FETracePane.this.statePanel.repaint();
                }
            }
        });
        jComponent.add(jComponent2);
        jPanel.add(jPanel2);
        jPanel.add(jComponent);
        jComponent2 = new JPanel();
        jComponent2.setLayout(new BoxLayout(jComponent2, 1));
        this.statePanel = new PhysicalGameStatePanel((GameState)null);
        this.statePanel.setPreferredSize(new Dimension(512, 512));
        jComponent2.add(this.statePanel);
        this.add((Component)jPanel, "North");
        this.add((Component)jComponent2, "South");
    }
}

