/*
 * Decompiled with CFR 0.152.
 */
package gui.frontend;

import gui.PhysicalGameStatePanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import rts.GameState;
import rts.PhysicalGameState;
import rts.PlayerAction;
import rts.UnitAction;
import rts.units.Unit;
import rts.units.UnitType;
import rts.units.UnitTypeTable;

public class PopUpStateEditorMenu
extends JPopupMenu {
    public PopUpStateEditorMenu(final GameState gameState, UnitTypeTable unitTypeTable, final int n, final int n2, final PhysicalGameStatePanel physicalGameStatePanel) {
        final PhysicalGameState physicalGameState = gameState.getPhysicalGameState();
        final Unit unit = physicalGameState.getUnitAt(n, n2);
        if (unit == null) {
            if (physicalGameState.getTerrain(n, n2) == 0) {
                JMenuItem jMenuItem = new JMenuItem("Set wall");
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        physicalGameState.setTerrain(n, n2, 1);
                        physicalGameStatePanel.gameStateUpdated();
                        physicalGameStatePanel.repaint();
                    }
                });
                this.add(jMenuItem);
                for (final UnitType unitType : unitTypeTable.getUnitTypes()) {
                    JMenuItem jMenuItem2;
                    if (unitType.isResource) {
                        jMenuItem2 = new JMenuItem("Add " + unitType.name + "");
                        jMenuItem2.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                physicalGameState.addUnit(new Unit(-1, unitType, n, n2, 10));
                                physicalGameStatePanel.gameStateUpdated();
                                physicalGameStatePanel.repaint();
                            }
                        });
                        this.add(jMenuItem2);
                        continue;
                    }
                    jMenuItem2 = new JMenuItem("Add " + unitType.name + " (player 0)");
                    jMenuItem2.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            physicalGameState.addUnit(new Unit(0, unitType, n, n2, 0));
                            physicalGameStatePanel.gameStateUpdated();
                            physicalGameStatePanel.repaint();
                        }
                    });
                    this.add(jMenuItem2);
                    JMenuItem jMenuItem3 = new JMenuItem("Add " + unitType.name + " (player 1)");
                    jMenuItem3.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            physicalGameState.addUnit(new Unit(1, unitType, n, n2, 0));
                            physicalGameStatePanel.gameStateUpdated();
                            physicalGameStatePanel.repaint();
                        }
                    });
                    this.add(jMenuItem3);
                }
            } else {
                JMenuItem jMenuItem = new JMenuItem("Set walkable");
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        physicalGameState.setTerrain(n, n2, 0);
                        physicalGameStatePanel.gameStateUpdated();
                        physicalGameStatePanel.repaint();
                    }
                });
                this.add(jMenuItem);
            }
        } else {
            Object object;
            JMenuItem jMenuItem = new JMenuItem("Remove " + unit.getType().name);
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    physicalGameState.removeUnit(unit);
                    physicalGameStatePanel.gameStateUpdated();
                    physicalGameStatePanel.repaint();
                }
            });
            this.add(jMenuItem);
            if (unit.getType().isResource || unit.getType().canHarvest) {
                if (unit.getResources() > 0) {
                    object = new JMenuItem("-1 resource");
                    ((AbstractButton)object).addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            unit.setResources(unit.getResources() - 1);
                            physicalGameStatePanel.gameStateUpdated();
                            physicalGameStatePanel.repaint();
                        }
                    });
                    this.add((JMenuItem)object);
                }
                if (unit.getType().isResource || unit.getResources() == 0) {
                    object = new JMenuItem("+1 resource");
                    ((AbstractButton)object).addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            unit.setResources(unit.getResources() + 1);
                            physicalGameStatePanel.gameStateUpdated();
                            physicalGameStatePanel.repaint();
                        }
                    });
                    this.add((JMenuItem)object);
                }
                if (unit.getResources() > 9) {
                    object = new JMenuItem("-10 resource");
                    ((AbstractButton)object).addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            unit.setResources(unit.getResources() - 10);
                            physicalGameStatePanel.gameStateUpdated();
                            physicalGameStatePanel.repaint();
                        }
                    });
                    this.add((JMenuItem)object);
                }
                if (unit.getType().isResource) {
                    object = new JMenuItem("+10 resource");
                    ((AbstractButton)object).addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            unit.setResources(unit.getResources() + 10);
                            physicalGameStatePanel.gameStateUpdated();
                            physicalGameStatePanel.repaint();
                        }
                    });
                    this.add((JMenuItem)object);
                }
            }
            if (gameState.getUnitAction(unit) == null) {
                if (unit.getPlayer() != -1) {
                    object = unit.getUnitActions(gameState, 10);
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        final UnitAction unitAction = (UnitAction)iterator.next();
                        JMenuItem jMenuItem4 = new JMenuItem(unitAction.toString());
                        jMenuItem4.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                PlayerAction playerAction = new PlayerAction();
                                playerAction.addUnitAction(unit, unitAction);
                                gameState.issue(playerAction);
                                physicalGameStatePanel.gameStateUpdated();
                                physicalGameStatePanel.repaint();
                            }
                        });
                        this.add(jMenuItem4);
                    }
                }
            } else {
                object = new JMenuItem("Cancel action");
                ((AbstractButton)object).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        gameState.getUnitActions().remove(unit);
                        physicalGameStatePanel.gameStateUpdated();
                        physicalGameStatePanel.repaint();
                    }
                });
                this.add((JMenuItem)object);
            }
        }
    }
}

