/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api.condition;

import org.junit.jupiter.api.condition.DisabledForJreRange;
import org.junit.jupiter.api.condition.EnabledOnJreCondition;
import org.junit.jupiter.api.condition.JRE;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.Preconditions;

class DisabledForJreRangeCondition
implements ExecutionCondition {
    private static final ConditionEvaluationResult ENABLED_BY_DEFAULT = ConditionEvaluationResult.enabled("@DisabledForJreRange is not present");

    DisabledForJreRangeCondition() {
    }

    @Override
    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        return AnnotationUtils.findAnnotation(context.getElement(), DisabledForJreRange.class).map(disabledForJreRange -> {
            JRE min = disabledForJreRange.min();
            JRE max = disabledForJreRange.max();
            Preconditions.condition(max.compareTo(min) >= 0, "@DisabledForJreRange.min must be lower or the same version as @DisabledForJreRange.max");
            if (this.isCurrentVersionWithinRange(min, max)) {
                return EnabledOnJreCondition.DISABLED_ON_CURRENT_JRE;
            }
            return EnabledOnJreCondition.ENABLED_ON_CURRENT_JRE;
        }).orElse(ENABLED_BY_DEFAULT);
    }

    private boolean isCurrentVersionWithinRange(JRE min, JRE max) {
        if (JRE.CURRENT_VERSION == null) {
            return true;
        }
        return JRE.CURRENT_VERSION.compareTo(min) >= 0 && JRE.CURRENT_VERSION.compareTo(max) <= 0;
    }
}

