/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api.condition;

import java.util.Arrays;
import java.util.Optional;
import org.junit.jupiter.api.condition.DisabledOnJre;
import org.junit.jupiter.api.condition.EnabledOnJreCondition;
import org.junit.jupiter.api.condition.JRE;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.Preconditions;

class DisabledOnJreCondition
implements ExecutionCondition {
    private static final ConditionEvaluationResult ENABLED_BY_DEFAULT = ConditionEvaluationResult.enabled("@DisabledOnJre is not present");

    DisabledOnJreCondition() {
    }

    @Override
    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        Optional<DisabledOnJre> optional = AnnotationUtils.findAnnotation(context.getElement(), DisabledOnJre.class);
        if (optional.isPresent()) {
            JRE[] versions = optional.get().value();
            Preconditions.condition(versions.length > 0, "You must declare at least one JRE in @DisabledOnJre");
            return Arrays.stream(versions).anyMatch(JRE::isCurrentVersion) ? EnabledOnJreCondition.DISABLED_ON_CURRENT_JRE : EnabledOnJreCondition.ENABLED_ON_CURRENT_JRE;
        }
        return ENABLED_BY_DEFAULT;
    }
}

