/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.console;

import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import org.apiguardian.api.API;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.console.ConsoleLauncherExecutionResult;
import org.junit.platform.console.options.CommandLineOptions;
import org.junit.platform.console.options.CommandLineOptionsParser;
import org.junit.platform.console.options.PicocliCommandLineOptionsParser;
import org.junit.platform.console.tasks.ConsoleTestExecutor;
import org.junit.platform.launcher.listeners.TestExecutionSummary;

@API(status=API.Status.MAINTAINED, since="1.0")
public class ConsoleLauncher {
    private final CommandLineOptionsParser commandLineOptionsParser;
    private final PrintStream outStream;
    private final PrintStream errStream;
    private final Charset charset;

    public static void main(String ... args) {
        int exitCode = ConsoleLauncher.execute(System.out, System.err, args).getExitCode();
        System.exit(exitCode);
    }

    @API(status=API.Status.INTERNAL, since="1.0")
    public static ConsoleLauncherExecutionResult execute(PrintStream out, PrintStream err, String ... args) {
        PicocliCommandLineOptionsParser parser = new PicocliCommandLineOptionsParser();
        ConsoleLauncher consoleLauncher = new ConsoleLauncher(parser, out, err);
        return consoleLauncher.execute(args);
    }

    ConsoleLauncher(CommandLineOptionsParser commandLineOptionsParser, PrintStream out, PrintStream err) {
        this(commandLineOptionsParser, out, err, Charset.defaultCharset());
    }

    ConsoleLauncher(CommandLineOptionsParser commandLineOptionsParser, PrintStream out, PrintStream err, Charset charset) {
        this.commandLineOptionsParser = commandLineOptionsParser;
        this.outStream = out;
        this.errStream = err;
        this.charset = charset;
    }

    ConsoleLauncherExecutionResult execute(String ... args) {
        CommandLineOptions options = null;
        try {
            options = this.commandLineOptionsParser.parse(args);
        }
        catch (JUnitException ex) {
            this.errStream.println(ex.getMessage());
            StringWriter sw = new StringWriter();
            this.commandLineOptionsParser.printHelp(new PrintWriter(sw));
            this.errStream.println(sw);
            return ConsoleLauncherExecutionResult.failed();
        }
        try {
            PrintWriter out;
            block13: {
                out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)this.outStream, this.charset)));
                try {
                    if (!options.isBannerDisabled()) {
                        this.displayBanner(out);
                    }
                    if (!options.isDisplayHelp()) break block13;
                    this.commandLineOptionsParser.printHelp(out);
                    ConsoleLauncherExecutionResult consoleLauncherExecutionResult = ConsoleLauncherExecutionResult.success();
                    out.close();
                    return consoleLauncherExecutionResult;
                }
                catch (Throwable throwable) {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            ConsoleLauncherExecutionResult consoleLauncherExecutionResult = this.executeTests(options, out);
            out.close();
            return consoleLauncherExecutionResult;
        }
        finally {
            this.outStream.flush();
            this.errStream.flush();
        }
    }

    void displayBanner(PrintWriter out) {
        out.println();
        out.println("Thanks for using JUnit! Support its development at https://junit.org/sponsoring");
        out.println();
    }

    private ConsoleLauncherExecutionResult executeTests(CommandLineOptions options, PrintWriter out) {
        try {
            TestExecutionSummary testExecutionSummary = new ConsoleTestExecutor(options).execute(out);
            return ConsoleLauncherExecutionResult.forSummary(testExecutionSummary, options);
        }
        catch (Exception exception) {
            exception.printStackTrace(this.errStream);
            this.errStream.println();
            this.commandLineOptionsParser.printHelp(out);
            return ConsoleLauncherExecutionResult.failed();
        }
    }
}

