/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import java.io.File;
import java.io.IOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.AFUNIXSocketAddress;

public final class AFUNIXSocketAddressTest {
    @Test
    public void testPort() throws IOException {
        Assertions.assertEquals(0, new AFUNIXSocketAddress(new File("/tmp/whatever")).getPort());
        Assertions.assertEquals(123, new AFUNIXSocketAddress(new File("/tmp/whatever"), 123).getPort());
        Assertions.assertEquals(44444, new AFUNIXSocketAddress(new File("/tmp/whatever"), 44444).getPort());
        try {
            new AFUNIXSocketAddress(new File("/tmp/whatever"), -1);
            Assertions.fail("Expected IllegalArgumentException for illegal port");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new AFUNIXSocketAddress(new File("/tmp/whatever"), 65536);
        }
        catch (IllegalArgumentException e) {
            Assertions.fail("AFUNIXSocketAddress supports ports larger than 65535");
        }
    }
}

