/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.AFUNIXSocketCapability;
import org.newsclub.net.unix.AFUNIXSocketCapabilityRequirement;

public class AFUNIXSocketCapabilityCondition
implements ExecutionCondition {
    @Override
    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        AFUNIXSocketCapabilityRequirement requirement;
        AFUNIXSocketCapability[] requiredCapabilities = new AFUNIXSocketCapability[]{};
        Optional<AnnotatedElement> element = context.getElement();
        if (element.isPresent() && (requirement = element.get().getAnnotation(AFUNIXSocketCapabilityRequirement.class)) != null) {
            requiredCapabilities = requirement.value();
        }
        ArrayList<AFUNIXSocketCapability> unsupported = new ArrayList<AFUNIXSocketCapability>(requiredCapabilities.length);
        for (AFUNIXSocketCapability capability : requiredCapabilities) {
            if (AFUNIXSocket.supports(capability)) continue;
            unsupported.add(capability);
        }
        ConditionEvaluationResult result = unsupported.isEmpty() ? ConditionEvaluationResult.enabled("AFUNIXSocket environment supports all required capabilities: " + Arrays.toString((Object[])requiredCapabilities)) : ConditionEvaluationResult.disabled("AFUNIXSocket environment does not support the following capabilities: " + unsupported);
        return result;
    }
}

