/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import java.io.IOException;
import java.net.Socket;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.AFUNIXSocketCapability;
import org.newsclub.net.unix.AFUNIXSocketCapabilityRequirement;
import org.newsclub.net.unix.AFUNIXSocketCredentials;
import org.newsclub.net.unix.SocketTestBase;
import org.newsclub.net.unix.TestUtils;

@AFUNIXSocketCapabilityRequirement(value={AFUNIXSocketCapability.CAPABILITY_PEER_CREDENTIALS})
public class PeerCredentialsTest
extends SocketTestBase {
    @Test
    public void testSameProcess() throws Exception {
        Assertions.assertTimeout(Duration.ofSeconds(2L), () -> {
            CompletableFuture clientCredsFuture = new CompletableFuture();
            SocketTestBase.ServerThread serverThread = new SocketTestBase.ServerThread(){

                @Override
                protected void handleConnection(Socket sock) throws IOException {
                    AFUNIXSocket socket = (AFUNIXSocket)sock;
                    AFUNIXSocketCredentials clientCreds = socket.getPeerCredentials();
                    clientCredsFuture.complete(clientCreds);
                    this.stopAcceptingConnections();
                }
            };
            try (AFUNIXSocket socket = this.connectToServer();){
                AFUNIXSocketCredentials serverCreds = socket.getPeerCredentials();
                AFUNIXSocketCredentials clientCreds = (AFUNIXSocketCredentials)clientCredsFuture.get();
                Assertions.assertEquals((Object)clientCreds, (Object)serverCreds, "Since our tests run in the same process, the peer credentials must be identical");
                Assertions.assertEquals(TestUtils.getPid(), clientCreds.getPid(), "The returned PID must be the one of our process");
            }
            serverThread.checkException();
        });
    }
}

