/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.SocketTestBase;

public class SoTimeoutTest
extends SocketTestBase {
    @Test
    public void issue14Fail() throws IOException {
        SocketTestBase.ServerThread serverThread = new SocketTestBase.ServerThread(){

            @Override
            protected void handleConnection(Socket sock) throws IOException {
                this.stopAcceptingConnections();
            }

            @Override
            protected void handleException(Exception e) {
            }
        };
        try (AFUNIXSocket sock = this.connectToServer();){
            Thread.yield();
            try {
                sock.setSoTimeout((int)TimeUnit.SECONDS.toMillis(12L));
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
        serverThread.shutdown();
    }

    @Test
    public void issue14Pass() throws IOException {
        SocketTestBase.ServerThread serverThread = new SocketTestBase.ServerThread(){

            @Override
            protected void handleConnection(Socket sock) throws IOException {
                sock.getInputStream().read();
                this.stopAcceptingConnections();
            }

            @Override
            protected void handleException(Exception e) {
            }
        };
        try (AFUNIXSocket sock = this.connectToServer();){
            sock.setSoTimeout((int)TimeUnit.SECONDS.toMillis(12L));
        }
        serverThread.shutdown();
    }
}

