/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.file.Files;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeEach;
import org.newsclub.net.unix.AFUNIXServerSocket;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.AFUNIXSocketAddress;

public abstract class SocketTestBase {
    private static final File SOCKET_FILE = SocketTestBase.initSocketFile();
    private final AFUNIXSocketAddress serverAddress;
    private Exception caller = new Exception();

    public SocketTestBase() throws IOException {
        this.serverAddress = new AFUNIXSocketAddress(SOCKET_FILE);
    }

    @BeforeEach
    public void ensureSocketFileIsDeleted() throws IOException {
        Files.deleteIfExists(SOCKET_FILE.toPath());
    }

    @AfterAll
    public static void tearDownClass() throws IOException {
        Files.deleteIfExists(SOCKET_FILE.toPath());
    }

    protected AFUNIXSocketAddress getServerAddress() {
        return this.serverAddress;
    }

    static File initSocketFile() {
        File f;
        String explicitFile = System.getProperty("org.newsclub.net.unix.testsocket");
        if (explicitFile != null) {
            f = new File(explicitFile);
        } else {
            try {
                f = File.createTempFile("jutest", ".sock");
            }
            catch (IOException e) {
                throw new IllegalStateException("Can't create temporary file", e);
            }
        }
        if (!f.delete()) {
            f.deleteOnExit();
        }
        return f;
    }

    protected File getSocketFile() {
        return SOCKET_FILE;
    }

    protected AFUNIXServerSocket startServer() throws IOException {
        this.caller = new Exception();
        AFUNIXServerSocket server = AFUNIXServerSocket.newInstance();
        server.bind(this.serverAddress);
        return server;
    }

    protected AFUNIXSocket connectToServer() throws IOException {
        return AFUNIXSocket.connectTo(this.serverAddress);
    }

    protected AFUNIXSocket connectToServer(AFUNIXSocket socket) throws IOException {
        socket.connect(this.serverAddress);
        return socket;
    }

    protected void sleepFor(int ms) throws InterruptedIOException {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw (InterruptedIOException)new InterruptedIOException("sleep interrupted").initCause(e);
        }
    }

    protected abstract class ServerThread
    extends Thread {
        private final AFUNIXServerSocket serverSocket;
        private volatile Exception exception = null;
        private final AtomicBoolean loop = new AtomicBoolean(true);
        private final Semaphore sema = new Semaphore(0);

        @SuppressFBWarnings(value={"SC_START_IN_CTOR"})
        protected ServerThread() throws IOException {
            this.serverSocket = SocketTestBase.this.startServer();
            this.setDaemon(true);
            this.start();
        }

        public void shutdown() throws IOException {
            this.stopAcceptingConnections();
            this.serverSocket.close();
        }

        protected abstract void handleConnection(Socket var1) throws IOException;

        protected void stopAcceptingConnections() {
            this.loop.set(false);
        }

        protected void onServerSocketClose() {
        }

        public ServerSocket getServerSocket() {
            return this.serverSocket;
        }

        protected void handleException(Exception e) {
            e.printStackTrace();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public final void run() {
            block11: {
                try {
                    this.loop.set(true);
                    try {
                        while (this.loop.get()) {
                            AFUNIXSocket sock = this.serverSocket.accept();
                            try {
                                this.handleConnection(sock);
                            }
                            finally {
                                if (sock == null) continue;
                                ((Socket)sock).close();
                            }
                        }
                    }
                    finally {
                        this.onServerSocketClose();
                        this.serverSocket.close();
                    }
                }
                catch (IOException e) {
                    if (!this.loop.get() && this.serverSocket.isClosed()) break block11;
                    e.addSuppressed(SocketTestBase.this.caller);
                    this.handleException(e);
                    this.exception = e;
                }
            }
            this.sema.release();
        }

        public void checkException() throws Exception {
            this.sema.acquire();
            if (this.exception != null) {
                throw this.exception;
            }
        }
    }
}

