/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.nio.file.Files;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.SocketTestBase;

public class TcpNoDelayTest
extends SocketTestBase {
    @Test
    public void testStrictImpl() throws Exception {
        new SocketTestBase.ServerThread(){

            @Override
            protected void handleConnection(Socket sock) throws IOException {
                this.stopAcceptingConnections();
            }

            @Override
            protected void onServerSocketClose() {
            }
        };
        try (AFUNIXSocket sock = this.connectToServer(AFUNIXSocket.newStrictInstance());){
            boolean gotException = false;
            try {
                sock.setTcpNoDelay(true);
            }
            catch (SocketException e) {
                gotException = true;
            }
            if (!gotException) {
                Assertions.assertTrue(sock.getTcpNoDelay());
            }
        }
        Files.delete(this.getSocketFile().toPath());
    }

    @Test
    public void testDefaultImpl() throws Exception {
        new SocketTestBase.ServerThread(){

            @Override
            protected void handleConnection(Socket sock) throws IOException {
                this.stopAcceptingConnections();
            }

            @Override
            protected void onServerSocketClose() {
            }
        };
        try (AFUNIXSocket sock = this.connectToServer();){
            sock.setTcpNoDelay(true);
        }
        Files.delete(this.getSocketFile().toPath());
    }
}

