/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.rmi;

import java.io.IOException;
import java.rmi.AccessException;
import java.rmi.AlreadyBoundException;
import java.rmi.NoSuchObjectException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteServer;
import java.rmi.server.UnicastRemoteObject;
import java.util.HashMap;
import java.util.Map;
import org.newsclub.net.unix.rmi.AFUNIXNaming;
import org.newsclub.net.unix.rmi.AFUNIXRMIService;
import org.newsclub.net.unix.rmi.RemoteCloseable;
import org.newsclub.net.unix.rmi.ShutdownHookSupport;

public final class AFUNIXRegistry
implements Registry,
ShutdownHookSupport.ShutdownHook {
    final RemoteCloseable<?> boundCloser;
    private final Registry impl;
    private final Map<String, Remote> bound = new HashMap<String, Remote>();
    private final AFUNIXNaming naming;
    private boolean boundCloserExported = false;

    AFUNIXRegistry(AFUNIXNaming naming, Registry impl) throws RemoteException {
        this.naming = naming;
        this.impl = impl;
        this.boundCloser = new RemoteCloseable<Void>(){

            @Override
            public Void get() throws IOException {
                return null;
            }

            @Override
            public void close() throws IOException {
                AFUNIXRegistry.this.forceUnexportBound();
                AFUNIXNaming.unexportObject(this);
            }
        };
        ShutdownHookSupport.addWeakShutdownHook(this);
    }

    public boolean isRemoteServer() {
        return this.impl instanceof RemoteServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forceUnexportBound() {
        HashMap<String, Remote> map;
        Map<String, Remote> map2 = this.bound;
        synchronized (map2) {
            map = new HashMap<String, Remote>(this.bound);
            this.bound.clear();
        }
        try {
            this.checkBound();
        }
        catch (RemoteException e1) {
            e1.printStackTrace();
        }
        for (Map.Entry entry : map.entrySet()) {
            String name = (String)entry.getKey();
            Remote obj = (Remote)entry.getValue();
            if (obj == null) continue;
            try {
                this.naming.unexportAndUnbind(name, obj);
            }
            catch (RemoteException remoteException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Remote getInstance(String name) throws NoSuchObjectException {
        Remote remote;
        Map<String, Remote> map = this.bound;
        synchronized (map) {
            remote = this.bound.get(name);
        }
        if (remote == null) {
            throw new NoSuchObjectException(name);
        }
        return remote;
    }

    void unexport(String name) throws NoSuchObjectException {
        UnicastRemoteObject.unexportObject(this.getInstance(name), true);
    }

    @Override
    public Remote lookup(String name) throws RemoteException, NotBoundException, AccessException {
        return this.impl.lookup(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bind(String name, Remote obj) throws RemoteException, AlreadyBoundException, AccessException {
        this.impl.bind(name, RemoteObject.toStub(obj));
        Map<String, Remote> map = this.bound;
        synchronized (map) {
            this.bound.put(name, obj);
        }
        this.checkBound();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbind(String name) throws RemoteException, NotBoundException, AccessException {
        this.impl.unbind(name);
        Map<String, Remote> map = this.bound;
        synchronized (map) {
            this.bound.remove(name);
        }
        this.checkBound();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rebind(String name, Remote obj) throws RemoteException, AccessException {
        this.impl.rebind(name, RemoteObject.toStub(obj));
        Map<String, Remote> map = this.bound;
        synchronized (map) {
            this.bound.put(name, obj);
        }
        this.checkBound();
    }

    @Override
    public String[] list() throws RemoteException, AccessException {
        return this.impl.list();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void checkBound() throws RemoteException {
        block14: {
            boolean empty = false;
            Object object = this.bound;
            synchronized (object) {
                empty = this.bound.isEmpty();
            }
            object = this.boundCloser;
            synchronized (object) {
                block13: {
                    if (!empty) break block13;
                    if (!this.boundCloserExported) break block14;
                    this.boundCloserExported = false;
                    try {
                        AFUNIXRMIService service2 = this.naming.getRMIService();
                        service2.unregisterForShutdown(this.boundCloser);
                    }
                    catch (NoSuchObjectException | NotBoundException e) {
                        AFUNIXNaming.unexportObject(this.boundCloser);
                        return;
                        catch (Throwable throwable) {
                            AFUNIXNaming.unexportObject(this.boundCloser);
                            throw throwable;
                        }
                    }
                    AFUNIXNaming.unexportObject(this.boundCloser);
                    break block14;
                }
                if (!this.boundCloserExported) {
                    AFUNIXRMIService service;
                    AFUNIXNaming.exportObject(this.boundCloser, this.naming.getSocketFactory());
                    this.boundCloserExported = true;
                    try {
                        service = this.naming.getRMIService();
                    }
                    catch (NotBoundException e) {
                        return;
                    }
                    service.registerForShutdown(this.boundCloser);
                }
            }
        }
    }

    @Override
    public void onRuntimeShutdown(Thread thread) {
        if (thread != Thread.currentThread() | !(thread instanceof ShutdownHookSupport.ShutdownThread)) {
            throw new IllegalStateException("Illegal caller");
        }
        this.forceUnexportBound();
    }
}

