/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.rmi;

import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Proxy;
import java.nio.charset.StandardCharsets;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.server.RMISocketFactory;
import java.rmi.server.RemoteObject;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.rmi.AFUNIXNaming;
import org.newsclub.net.unix.rmi.AFUNIXRegistry;
import org.newsclub.net.unix.rmi.NaiveFileInputStreamRemote;
import org.newsclub.net.unix.rmi.RemoteFileDescriptor;
import org.newsclub.net.unix.rmi.RemoteFileDescriptorTestService;
import org.newsclub.net.unix.rmi.RemoteFileDescriptorTestServiceImpl;
import org.newsclub.net.unix.rmi.RemotePeerInfo;
import org.newsclub.net.unix.rmi.TestUtils;

public class RemoteFileDescriptorTest {
    private static final String TEST_SERVICE_NAME = RemoteFileDescriptorTest.class.getName();
    private static final byte[] HELLO_WORLD = "Hello World :-)\n".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] SMILEY = ":-)\n".getBytes(StandardCharsets.US_ASCII);
    private static AFUNIXNaming namingInstance;
    private static RemoteFileDescriptorTestServiceImpl testService;

    @BeforeAll
    public static void setupClass() throws IOException, AlreadyBoundException {
        namingInstance = AFUNIXNaming.newPrivateInstance();
        AFUNIXRegistry registry = namingInstance.createRegistry();
        testService = new RemoteFileDescriptorTestServiceImpl(namingInstance.getSocketFactory());
        registry.bind(TEST_SERVICE_NAME, RemoteObject.toStub(testService));
    }

    @AfterAll
    public static void tearDownClass() throws IOException, NotBoundException {
        testService.close();
        namingInstance.shutdownRegistry();
    }

    @Test
    public void testServiceProxy() throws Exception {
        RemoteFileDescriptorTestService svc = (RemoteFileDescriptorTestService)namingInstance.getRegistry().lookup(TEST_SERVICE_NAME);
        Assertions.assertTrue(Proxy.isProxyClass(svc.getClass()));
    }

    @Test
    public void testRemoteStdout() throws Exception {
        RemoteFileDescriptorTestService svc = (RemoteFileDescriptorTestService)namingInstance.getRegistry().lookup(TEST_SERVICE_NAME);
        try (RemoteFileDescriptor stdout = svc.stdout();
             FileOutputStream fos = new FileOutputStream(stdout.getFileDescriptor());){
            fos.flush();
        }
    }

    @Test
    public void testWriteAndReadHello() throws Exception {
        RemoteFileDescriptorTestService svc = (RemoteFileDescriptorTestService)namingInstance.getRegistry().lookup(TEST_SERVICE_NAME);
        try (FileOutputStream fos = svc.output().asFileOutputStream();){
            fos.write(HELLO_WORLD);
        }
        svc.verifyContents(HELLO_WORLD);
        try (FileInputStream fin = svc.input(12L).asFileInputStream();){
            byte[] data = TestUtils.readAllBytes(fin);
            Assertions.assertArrayEquals(SMILEY, data);
        }
        try (NaiveFileInputStreamRemote rfis = svc.naiveInputStreamRemote();
             FileInputStream fin = rfis.getRemoteFileDescriptor().asFileInputStream();){
            Assertions.assertEquals(72, rfis.read());
            Assertions.assertEquals(101, fin.read());
            Assertions.assertEquals(108, fin.read());
            Assertions.assertEquals(108, fin.read());
            fin.close();
            Assertions.assertEquals(111, rfis.read());
        }
    }

    @Test
    public void testFindSocketFactory() throws IOException, NotBoundException {
        RemoteFileDescriptorTestService svc = (RemoteFileDescriptorTestService)namingInstance.getRegistry().lookup(TEST_SERVICE_NAME);
        RemotePeerInfo rci = RemotePeerInfo.getConnectionInfo(svc);
        RMISocketFactory factory = rci.getSocketFactory();
        Assertions.assertNotNull(factory);
        Assertions.assertEquals(namingInstance.getSocketFactory(), factory);
    }

    @Test
    public void testReadWrite() throws IOException, NotBoundException {
        byte[] actual;
        RemoteFileDescriptorTestService svc = (RemoteFileDescriptorTestService)namingInstance.getRegistry().lookup(TEST_SERVICE_NAME);
        byte[] expected = new byte[5000];
        for (int i2 = 0; i2 < expected.length; ++i2) {
            expected[i2] = (byte)((i2 + 123) % 256);
        }
        try (FileOutputStream fos = svc.output().asFileOutputStream();){
            fos.write(expected);
        }
        try (Closeable fin = svc.input().asFileInputStream();){
            actual = TestUtils.readAllBytes((InputStream)fin);
        }
        Assertions.assertArrayEquals(expected, actual);
        fin = svc.naiveInputStreamRemote();
        try {
            actual = fin.readAllBytes();
        }
        finally {
            if (fin != null) {
                fin.close();
            }
        }
        Assertions.assertArrayEquals(expected, actual);
    }
}

