/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.rmi;

import java.io.Closeable;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import org.newsclub.net.unix.rmi.AFUNIXNaming;
import org.newsclub.net.unix.rmi.AFUNIXRMISocketFactory;
import org.newsclub.net.unix.rmi.NaiveFileInputStreamRemote;
import org.newsclub.net.unix.rmi.NaiveFileInputStreamRemoteImpl;
import org.newsclub.net.unix.rmi.RemoteFileDescriptor;
import org.newsclub.net.unix.rmi.RemoteFileDescriptorTestService;
import org.newsclub.net.unix.rmi.RemoteFileInput;
import org.newsclub.net.unix.rmi.RemoteFileOutput;
import org.newsclub.net.unix.rmi.TestUtils;

public class RemoteFileDescriptorTestServiceImpl
implements RemoteFileDescriptorTestService,
Closeable {
    private final File tmpFile;
    private final AFUNIXRMISocketFactory socketFactory;

    public RemoteFileDescriptorTestServiceImpl(AFUNIXRMISocketFactory socketFactory) throws IOException {
        this.socketFactory = socketFactory;
        this.tmpFile = File.createTempFile("FDTestService", ".tmp");
        AFUNIXNaming.exportObject(this, socketFactory);
    }

    @Override
    public RemoteFileDescriptor stdout() throws IOException {
        return new RemoteFileDescriptor(this.socketFactory, FileDescriptor.out);
    }

    @Override
    public RemoteFileInput input() throws IOException {
        return new RemoteFileInput(this.socketFactory, new FileInputStream(this.tmpFile));
    }

    @Override
    public RemoteFileInput input(long skipBytes) throws IOException {
        FileInputStream fin = new FileInputStream(this.tmpFile);
        try {
            long skipped;
            while (skipBytes > 0L && (skipped = fin.skip(skipBytes)) >= 0L) {
                skipBytes -= skipped;
            }
            return new RemoteFileInput(this.socketFactory, fin);
        }
        catch (IOException e) {
            fin.close();
            throw e;
        }
    }

    @Override
    public RemoteFileOutput output() throws IOException {
        return new RemoteFileOutput(this.socketFactory, new FileOutputStream(this.tmpFile));
    }

    @Override
    public void verifyContents(byte[] expectedData) throws IOException {
        try (FileInputStream fin = new FileInputStream(this.tmpFile);){
            byte[] bytes = TestUtils.readAllBytes(fin);
            if (!Arrays.equals(bytes, expectedData)) {
                throw new IOException("Unexpected bytes");
            }
        }
    }

    @Override
    public void verifyContents(int numBytes, byte[] expectedData) throws IOException {
        try (FileInputStream fin = new FileInputStream(this.tmpFile);){
            byte[] bytes = new byte[numBytes];
            int numRead = fin.read(bytes);
            if (numRead != bytes.length || !Arrays.equals(bytes, expectedData)) {
                throw new IOException("Unexpected bytes");
            }
        }
    }

    @Override
    public void deleteFile() throws IOException {
        Files.deleteIfExists(this.tmpFile.toPath());
    }

    @Override
    public void touchFile() throws IOException {
        Files.createFile(this.tmpFile.toPath(), new FileAttribute[0]);
    }

    @Override
    public NaiveFileInputStreamRemote naiveInputStreamRemote() throws IOException {
        return new NaiveFileInputStreamRemoteImpl(this.socketFactory, this.tmpFile);
    }

    @Override
    public void close() throws IOException {
        AFUNIXNaming.unexportObject(this);
        this.deleteFile();
    }
}

