/*
 * Decompiled with CFR 0.152.
 */
package rts;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class GameSettings {
    private String serverAddress = "";
    private int serverPort = 9898;
    private LaunchMode launchMode;
    private int serializationType = 1;
    private String mapLocation = "";
    private int maxCycles = 5000;
    private boolean partiallyObservable = false;
    private int uttVersion = 1;
    private int conflictPolicy = 1;
    private String AI1 = "";
    private String AI2 = "";

    private GameSettings(LaunchMode launchMode, String string, int n, int n2, String string2, int n3, boolean bl, int n4, int n5, String string3, String string4) {
        this.launchMode = launchMode;
        this.serverAddress = string;
        this.serverPort = n;
        this.serializationType = n2;
        this.mapLocation = string2;
        this.maxCycles = n3;
        this.partiallyObservable = bl;
        this.uttVersion = n4;
        this.conflictPolicy = n5;
        this.AI1 = string3;
        this.AI2 = string4;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public int getSerializationType() {
        return this.serializationType;
    }

    public String getMapLocation() {
        return this.mapLocation;
    }

    public int getMaxCycles() {
        return this.maxCycles;
    }

    public boolean isPartiallyObservable() {
        return this.partiallyObservable;
    }

    public int getUTTVersion() {
        return this.uttVersion;
    }

    public int getConflictPolicy() {
        return this.conflictPolicy;
    }

    public LaunchMode getLaunchMode() {
        return this.launchMode;
    }

    public String getAI1() {
        return this.AI1;
    }

    public String getAI2() {
        return this.AI2;
    }

    public static Properties fetchDefaultConfig() throws IOException {
        Properties properties = new Properties();
        InputStream inputStream = GameSettings.class.getResourceAsStream("/config.properties");
        if (inputStream == null) {
            inputStream = new FileInputStream("resources/config.properties");
        }
        properties.load(inputStream);
        return properties;
    }

    public static Properties fetchConfig(String string) throws IOException {
        Properties properties = new Properties();
        InputStream inputStream = GameSettings.class.getResourceAsStream(string);
        if (inputStream == null) {
            inputStream = new FileInputStream(string);
        }
        properties.load(inputStream);
        return properties;
    }

    public static GameSettings loadFromConfig(Properties properties) {
        assert (!properties.isEmpty());
        String string = properties.getProperty("server_address");
        int n = GameSettings.readIntegerProperty(properties, "server_port", 9898);
        int n2 = GameSettings.readIntegerProperty(properties, "serialization_type", 2);
        String string2 = properties.getProperty("map_location");
        int n3 = GameSettings.readIntegerProperty(properties, "max_cycles", 5000);
        boolean bl = Boolean.parseBoolean(properties.getProperty("partially_observable"));
        int n4 = GameSettings.readIntegerProperty(properties, "UTT_version", 2);
        int n5 = GameSettings.readIntegerProperty(properties, "conflict_policy", 1);
        LaunchMode launchMode = LaunchMode.valueOf(properties.getProperty("launch_mode"));
        String string3 = properties.getProperty("AI1");
        String string4 = properties.getProperty("AI2");
        return new GameSettings(launchMode, string, n, n2, string2, n3, bl, n4, n5, string3, string4);
    }

    public static int readIntegerProperty(Properties properties, String string, int n) {
        String string2 = properties.getProperty(string);
        if (string2 == null) {
            return n;
        }
        return Integer.parseInt(string2);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("----------Game Settings----------\n");
        stringBuilder.append("Running as Server: ").append(this.getLaunchMode().toString()).append("\n");
        stringBuilder.append("Server Address: ").append(this.getServerAddress()).append("\n");
        stringBuilder.append("Server Port: ").append(this.getServerPort()).append("\n");
        stringBuilder.append("Serialization Type: ").append(this.getSerializationType()).append("\n");
        stringBuilder.append("Map Location: ").append(this.getMapLocation()).append("\n");
        stringBuilder.append("Max Cycles: ").append(this.getMaxCycles()).append("\n");
        stringBuilder.append("Partially Observable: ").append(this.isPartiallyObservable()).append("\n");
        stringBuilder.append("Rules Version: ").append(this.getUTTVersion()).append("\n");
        stringBuilder.append("Conflict Policy: ").append(this.getConflictPolicy()).append("\n");
        stringBuilder.append("AI1: ").append(this.getAI1()).append("\n");
        stringBuilder.append("AI2: ").append(this.getAI2()).append("\n");
        stringBuilder.append("------------------------------------------------");
        return stringBuilder.toString();
    }

    static enum LaunchMode {
        STANDALONE,
        GUI,
        SERVER,
        CLIENT;

    }
}

