/*
 * Decompiled with CFR 0.152.
 */
package rts;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.io.Serializable;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.jdom.Element;
import rts.PhysicalGameState;
import rts.Player;
import rts.PlayerAction;
import rts.ResourceUsage;
import rts.UnitAction;
import rts.UnitActionAssignment;
import rts.units.Unit;
import rts.units.UnitType;
import rts.units.UnitTypeTable;
import util.Pair;
import util.XMLWriter;

public class GameState {
    public static final boolean REPORT_ILLEGAL_ACTIONS = false;
    static Random r = new Random();
    protected int unitCancelationCounter = 0;
    protected int time = 0;
    protected PhysicalGameState pgs = null;
    protected HashMap<Unit, UnitActionAssignment> unitActions = new LinkedHashMap<Unit, UnitActionAssignment>();
    protected UnitTypeTable utt = null;

    public GameState(PhysicalGameState physicalGameState, UnitTypeTable unitTypeTable) {
        this.pgs = physicalGameState;
        this.utt = unitTypeTable;
    }

    public int getTime() {
        return this.time;
    }

    public void removeUnit(Unit unit) {
        this.pgs.removeUnit(unit);
        this.unitActions.remove(unit);
    }

    public Player getPlayer(int n) {
        return this.pgs.getPlayer(n);
    }

    public Unit getUnit(long l) {
        return this.pgs.getUnit(l);
    }

    public List<Unit> getUnits() {
        return this.pgs.getUnits();
    }

    public HashMap<Unit, UnitActionAssignment> getUnitActions() {
        return this.unitActions;
    }

    public UnitTypeTable getUnitTypeTable() {
        return this.utt;
    }

    public UnitAction getUnitAction(Unit unit) {
        UnitActionAssignment unitActionAssignment = this.unitActions.get(unit);
        if (unitActionAssignment == null) {
            return null;
        }
        return unitActionAssignment.action;
    }

    public UnitActionAssignment getActionAssignment(Unit unit) {
        return this.unitActions.get(unit);
    }

    public boolean isComplete() {
        for (Unit unit : this.pgs.units) {
            if (unit.getPlayer() == -1) continue;
            UnitActionAssignment unitActionAssignment = this.unitActions.get(unit);
            if (unitActionAssignment == null) {
                return false;
            }
            if (unitActionAssignment.action != null) continue;
            return false;
        }
        return true;
    }

    public int winner() {
        return this.pgs.winner();
    }

    public boolean gameover() {
        return this.pgs.gameover();
    }

    public PhysicalGameState getPhysicalGameState() {
        return this.pgs;
    }

    public boolean free(int n, int n2) {
        if (this.pgs.getTerrain(n, n2) != 0) {
            return false;
        }
        for (Unit object : this.pgs.units) {
            if (object.getX() != n || object.getY() != n2) continue;
            return false;
        }
        for (UnitActionAssignment unitActionAssignment : this.unitActions.values()) {
            if (unitActionAssignment.action.type != 1 && unitActionAssignment.action.type != 4) continue;
            Unit unit = unitActionAssignment.unit;
            if (unitActionAssignment.action.getDirection() == 0 && unit.getX() == n && unit.getY() == n2 + 1) {
                return false;
            }
            if (unitActionAssignment.action.getDirection() == 1 && unit.getX() == n - 1 && unit.getY() == n2) {
                return false;
            }
            if (unitActionAssignment.action.getDirection() == 2 && unit.getX() == n && unit.getY() == n2 - 1) {
                return false;
            }
            if (unitActionAssignment.action.getDirection() != 3 || unit.getX() != n + 1 || unit.getY() != n2) continue;
            return false;
        }
        return true;
    }

    public boolean[][] getAllFree() {
        boolean[][] blArray = this.pgs.getAllFree();
        for (UnitActionAssignment unitActionAssignment : this.unitActions.values()) {
            if (unitActionAssignment.action.type != 1 && unitActionAssignment.action.type != 4) continue;
            Unit unit = unitActionAssignment.unit;
            if (unitActionAssignment.action.getDirection() == 0) {
                blArray[unit.getX()][unit.getY() - 1] = false;
            }
            if (unitActionAssignment.action.getDirection() == 1) {
                blArray[unit.getX() + 1][unit.getY()] = false;
            }
            if (unitActionAssignment.action.getDirection() == 2) {
                blArray[unit.getX()][unit.getY() + 1] = false;
            }
            if (unitActionAssignment.action.getDirection() != 3) continue;
            blArray[unit.getX() - 1][unit.getY()] = false;
        }
        return blArray;
    }

    public boolean observable(int n, int n2) {
        return true;
    }

    public boolean issue(PlayerAction playerAction) {
        boolean bl = false;
        for (Pair<Unit, UnitAction> pair : playerAction.actions) {
            ResourceUsage resourceUsage = ((UnitAction)pair.m_b).resourceUsage((Unit)pair.m_a, this.pgs);
            for (UnitActionAssignment unitActionAssignment : this.unitActions.values()) {
                if (unitActionAssignment.action.resourceUsage(unitActionAssignment.unit, this.pgs).consistentWith(resourceUsage, this)) continue;
                if (unitActionAssignment.time == this.time) {
                    boolean bl2 = false;
                    boolean bl3 = false;
                    switch (this.utt.getMoveConflictResolutionStrategy()) {
                        default: {
                            System.err.println("Unknown move conflict resolution strategy in the UnitTypeTable!: " + this.utt.getMoveConflictResolutionStrategy());
                            System.err.println("Defaulting to MOVE_CONFLICT_RESOLUTION_CANCEL_BOTH");
                        }
                        case 1: {
                            bl3 = true;
                            bl2 = true;
                            break;
                        }
                        case 2: {
                            if (r.nextInt(2) == 0) {
                                bl3 = true;
                                break;
                            }
                            bl2 = true;
                            break;
                        }
                        case 3: {
                            if (this.unitCancelationCounter % 2 == 0) {
                                bl3 = true;
                            } else {
                                bl2 = true;
                            }
                            ++this.unitCancelationCounter;
                        }
                    }
                    int n = unitActionAssignment.action.ETA(unitActionAssignment.unit);
                    int n2 = ((UnitAction)pair.m_b).ETA((Unit)pair.m_a);
                    if (bl2) {
                        unitActionAssignment.action = new UnitAction(0, Math.min(n, n2));
                    }
                    if (!bl3) continue;
                    pair = new Pair(pair.m_a, new UnitAction(0, Math.min(n, n2)));
                    continue;
                }
                System.err.println("Inconsistent actions were executed!");
                System.err.println(unitActionAssignment);
                System.err.println("  Resources: " + unitActionAssignment.action.resourceUsage(unitActionAssignment.unit, this.pgs));
                System.err.println(pair.m_a + " assigned action " + pair.m_b + " at time " + this.time);
                System.err.println("  Resources: " + resourceUsage);
                System.err.println("Player resources: " + this.pgs.getPlayer(0).getResources() + ", " + this.pgs.getPlayer(1).getResources());
                System.err.println("Resource Consistency: " + unitActionAssignment.action.resourceUsage(unitActionAssignment.unit, this.pgs).consistentWith(resourceUsage, this));
                try {
                    throw new Exception("dummy");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    pair.m_b = new UnitAction(0);
                }
            }
            UnitActionAssignment unitActionAssignment = new UnitActionAssignment((Unit)pair.m_a, (UnitAction)pair.m_b, this.time);
            this.unitActions.put((Unit)pair.m_a, unitActionAssignment);
            if (((UnitAction)pair.m_b).type == 0) continue;
            bl = true;
        }
        return bl;
    }

    public boolean issueSafe(PlayerAction playerAction) {
        if (!playerAction.integrityCheck()) {
            throw new Error("PlayerAction inconsistent before 'issueSafe'");
        }
        if (!this.integrityCheck()) {
            throw new Error("GameState inconsistent before 'issueSafe'");
        }
        for (Pair<Unit, UnitAction> pair : playerAction.actions) {
            int n;
            if (pair.m_a == null) {
                System.err.println("Issuing an action to a null unit!!!");
                System.exit(1);
            }
            if (!((Unit)pair.m_a).canExecuteAction((UnitAction)pair.m_b, this)) {
                n = ((UnitAction)pair.m_b).ETA((Unit)pair.m_a);
                pair.m_b = new UnitAction(0, n);
            }
            if (this.pgs.units.indexOf(pair.m_a) == -1) {
                n = 0;
                for (Unit unit : this.pgs.units) {
                    if (unit.getClass() != ((Unit)pair.m_a).getClass() || unit.getX() != ((Unit)pair.m_a).getX() || unit.getY() != ((Unit)pair.m_a).getY()) continue;
                    pair.m_a = unit;
                    n = 1;
                    break;
                }
                if (n == 0) {
                    System.err.println("Inconsistent order: " + playerAction);
                    System.err.println(this);
                    System.err.println("The problem was with unit " + pair.m_a);
                }
            }
            ResourceUsage resourceUsage = ((UnitAction)pair.m_b).resourceUsage((Unit)pair.m_a, this.pgs);
            Iterator<Serializable> iterator = resourceUsage.getPositionsUsed().iterator();
            while (iterator.hasNext()) {
                int n2 = (Integer)iterator.next();
                int n3 = n2 / this.pgs.getWidth();
                int n4 = n2 % this.pgs.getWidth();
                if (this.pgs.getTerrain(n4, n3) == 0 && this.pgs.getUnitAt(n4, n3) == null) continue;
                UnitAction unitAction = new UnitAction(0, ((UnitAction)pair.m_b).ETA((Unit)pair.m_a));
                System.err.println("Player " + ((Unit)pair.m_a).getPlayer() + " issued an illegal move action (to " + n4 + "," + n3 + ") to unit " + ((Unit)pair.m_a).getID() + " at time " + this.getTime() + ", cancelling and replacing by " + unitAction);
                System.err.println("    Action: " + pair.m_b);
                System.err.println("    Resources used by the action: " + resourceUsage);
                System.err.println("    Unit at that coordinate " + this.pgs.getUnitAt(n4, n3));
                pair.m_b = unitAction;
            }
        }
        boolean bl = this.issue(playerAction);
        if (!this.integrityCheck()) {
            throw new Error("GameState inconsistent after 'issueSafe': " + playerAction);
        }
        return bl;
    }

    public boolean canExecuteAnyAction(int n) {
        for (Unit unit : this.pgs.getUnits()) {
            if (unit.getPlayer() != n || this.unitActions.get(unit) != null) continue;
            return true;
        }
        return false;
    }

    public boolean isUnitActionAllowed(Unit unit, UnitAction unitAction) {
        PlayerAction playerAction = new PlayerAction();
        if (unitAction.getType() == 1) {
            int n = unit.getX() + UnitAction.DIRECTION_OFFSET_X[unitAction.getDirection()];
            int n2 = unit.getY() + UnitAction.DIRECTION_OFFSET_Y[unitAction.getDirection()];
            if (n < 0 || n2 < 0 || n >= this.getPhysicalGameState().getWidth() || n2 >= this.getPhysicalGameState().getHeight() || this.getPhysicalGameState().getTerrain(n, n2) == 1 || this.getPhysicalGameState().getUnitAt(n, n2) != null) {
                return false;
            }
        }
        for (Unit unit2 : this.pgs.getUnits()) {
            UnitActionAssignment unitActionAssignment = this.unitActions.get(unit2);
            if (unitActionAssignment == null) continue;
            ResourceUsage resourceUsage = unitActionAssignment.action.resourceUsage(unit2, this.pgs);
            playerAction.r.merge(resourceUsage);
        }
        return unitAction.resourceUsage(unit, this.pgs).consistentWith(playerAction.getResourceUsage(), this);
    }

    public List<PlayerAction> getPlayerActionsSingleUnit(int n, Unit unit) {
        Object object;
        Object object2 = new LinkedList<PlayerAction>();
        PlayerAction playerAction = new PlayerAction();
        object2.add(playerAction);
        for (Unit object3 : this.pgs.getUnits()) {
            object = this.unitActions.get(object3);
            if (object == null) continue;
            ResourceUsage resourceUsage = ((UnitActionAssignment)object).action.resourceUsage(object3, this.pgs);
            playerAction.r.merge(resourceUsage);
        }
        if (this.unitActions.get(unit) == null) {
            LinkedList linkedList = new LinkedList();
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                object = (PlayerAction)iterator.next();
                linkedList.addAll(((PlayerAction)object).cartesianProduct(unit.getUnitActions(this), unit, this));
            }
            object2 = linkedList;
        }
        return object2;
    }

    public List<PlayerAction> getPlayerActions(int n) {
        Object object;
        Object object2;
        Object object3 = new LinkedList<PlayerAction>();
        PlayerAction playerAction = new PlayerAction();
        object3.add(playerAction);
        for (Unit unit : this.pgs.getUnits()) {
            object2 = this.unitActions.get(unit);
            if (object2 == null) continue;
            object = ((UnitActionAssignment)object2).action.resourceUsage(unit, this.pgs);
            playerAction.r.merge((ResourceUsage)object);
        }
        for (Unit unit : this.pgs.getUnits()) {
            if (unit.getPlayer() != n || this.unitActions.get(unit) != null) continue;
            object2 = new LinkedList();
            object = object3.iterator();
            while (object.hasNext()) {
                PlayerAction playerAction2 = (PlayerAction)object.next();
                object2.addAll(playerAction2.cartesianProduct(unit.getUnitActions(this), unit, this));
            }
            object3 = object2;
        }
        return object3;
    }

    public int getNextChangeTime() {
        int n = -1;
        for (Player object : this.pgs.players) {
            if (!this.canExecuteAnyAction(object.ID)) continue;
            return this.time;
        }
        for (UnitActionAssignment unitActionAssignment : this.unitActions.values()) {
            int n2 = unitActionAssignment.time + unitActionAssignment.action.ETA(unitActionAssignment.unit);
            if (n != -1 && n2 >= n) continue;
            n = n2;
        }
        if (n == -1) {
            return this.time;
        }
        return n;
    }

    public boolean cycle() {
        ++this.time;
        LinkedList<UnitActionAssignment> linkedList = new LinkedList<UnitActionAssignment>();
        for (UnitActionAssignment unitActionAssignment : this.unitActions.values()) {
            if (unitActionAssignment.action.ETA(unitActionAssignment.unit) + unitActionAssignment.time > this.time) continue;
            linkedList.add(unitActionAssignment);
        }
        for (UnitActionAssignment unitActionAssignment : linkedList) {
            this.unitActions.remove(unitActionAssignment.unit);
            unitActionAssignment.action.execute(unitActionAssignment.unit, this);
        }
        return this.gameover();
    }

    public void forceExecuteAllActions() {
        LinkedList<UnitActionAssignment> linkedList = new LinkedList<UnitActionAssignment>();
        for (UnitActionAssignment unitActionAssignment : this.unitActions.values()) {
            linkedList.add(unitActionAssignment);
        }
        for (UnitActionAssignment unitActionAssignment : linkedList) {
            this.unitActions.remove(unitActionAssignment.unit);
            unitActionAssignment.action.execute(unitActionAssignment.unit, this);
        }
    }

    public GameState clone() {
        GameState gameState = new GameState(this.pgs.clone(), this.utt);
        gameState.time = this.time;
        gameState.unitCancelationCounter = this.unitCancelationCounter;
        for (UnitActionAssignment unitActionAssignment : this.unitActions.values()) {
            Unit unit = unitActionAssignment.unit;
            int n = this.pgs.getUnits().indexOf(unit);
            if (n == -1) {
                System.out.println("Problematic game state:");
                System.out.println(this);
                System.out.println("Problematic action:");
                System.out.println(unitActionAssignment);
                throw new Error("Inconsistent game state during cloning...");
            }
            Unit unit2 = gameState.pgs.getUnits().get(n);
            gameState.unitActions.put(unit2, new UnitActionAssignment(unit2, unitActionAssignment.action, unitActionAssignment.time));
        }
        return gameState;
    }

    public GameState cloneIssue(PlayerAction playerAction) {
        GameState gameState = new GameState(this.pgs, this.utt);
        gameState.time = this.time;
        gameState.unitCancelationCounter = this.unitCancelationCounter;
        gameState.unitActions.putAll(this.unitActions);
        gameState.issue(playerAction);
        return gameState;
    }

    public GameState cloneChangingUTT(UnitTypeTable unitTypeTable) {
        GameState gameState = this.clone();
        gameState.utt = unitTypeTable;
        for (Unit unit : gameState.getUnits()) {
            UnitType unitType = unitTypeTable.getUnitType(unit.getType().name);
            if (unitType == null) {
                return null;
            }
            if (unit.getHitPoints() == unit.getType().hp) {
                unit.setHitPoints(unitType.hp);
            }
            unit.setType(unitType);
        }
        return gameState;
    }

    public ResourceUsage getResourceUsage() {
        ResourceUsage resourceUsage = new ResourceUsage();
        for (Unit unit : this.pgs.getUnits()) {
            UnitActionAssignment unitActionAssignment = this.unitActions.get(unit);
            if (unitActionAssignment == null) continue;
            ResourceUsage resourceUsage2 = unitActionAssignment.action.resourceUsage(unit, this.pgs);
            resourceUsage.merge(resourceUsage2);
        }
        return resourceUsage;
    }

    public boolean equals(Object object) {
        if (!(object instanceof GameState)) {
            return false;
        }
        GameState gameState = (GameState)object;
        if (!this.pgs.equivalents(gameState.pgs)) {
            return false;
        }
        int n = this.pgs.units.size();
        for (int j = 0; j < n; ++j) {
            UnitActionAssignment unitActionAssignment = this.unitActions.get(this.pgs.units.get(j));
            UnitActionAssignment unitActionAssignment2 = gameState.unitActions.get(gameState.pgs.units.get(j));
            if (unitActionAssignment == null) {
                if (unitActionAssignment2 == null) continue;
                return false;
            }
            if (unitActionAssignment2 == null) {
                return false;
            }
            if (unitActionAssignment.time != unitActionAssignment2.time) {
                return false;
            }
            if (unitActionAssignment.action.equals(unitActionAssignment2.action)) continue;
            return false;
        }
        return true;
    }

    public boolean integrityCheck() {
        LinkedList<Unit> linkedList = new LinkedList<Unit>();
        for (UnitActionAssignment unitActionAssignment : this.unitActions.values()) {
            Unit unit = unitActionAssignment.unit;
            int n = this.pgs.getUnits().indexOf(unit);
            if (n == -1) {
                System.err.println("integrityCheck: unit does not exist!");
                return false;
            }
            if (linkedList.contains(unit)) {
                System.err.println("integrityCheck: two actions to the same unit!");
                return false;
            }
            linkedList.add(unit);
        }
        return true;
    }

    public void dumpActionAssignments() {
        for (Unit unit : this.pgs.getUnits()) {
            if (unit.getPlayer() < 0) continue;
            UnitActionAssignment unitActionAssignment = this.unitActions.get(unit);
            if (unitActionAssignment == null) {
                System.out.println(unit + " : -");
                continue;
            }
            System.out.println(unit + " : " + unitActionAssignment.action + " at " + unitActionAssignment.time);
        }
    }

    public String toString() {
        String string = "ObservableGameState: " + this.time + "\n";
        for (Player object : this.pgs.getPlayers()) {
            string = string + "player " + object.ID + ": " + object.getResources() + "\n";
        }
        for (Unit unit : this.unitActions.keySet()) {
            UnitActionAssignment unitActionAssignment = this.unitActions.get(unit);
            if (unitActionAssignment == null) {
                string = string + "    " + unit + " -> null (ERROR!)\n";
                continue;
            }
            string = string + "    " + unit + " -> " + unitActionAssignment.time + " " + unitActionAssignment.action + "\n";
        }
        string = string + this.pgs;
        return string;
    }

    public void toxml(XMLWriter xMLWriter) {
        xMLWriter.tagWithAttributes(this.getClass().getName(), "time=\"" + this.time + "\"");
        this.pgs.toxml(xMLWriter);
        xMLWriter.tag("actions");
        for (Unit unit : this.unitActions.keySet()) {
            UnitActionAssignment unitActionAssignment = this.unitActions.get(unit);
            xMLWriter.tagWithAttributes("unitAction", "ID=\"" + unitActionAssignment.unit.getID() + "\" time=\"" + unitActionAssignment.time + "\"");
            unitActionAssignment.action.toxml(xMLWriter);
            xMLWriter.tag("/unitAction");
        }
        xMLWriter.tag("/actions");
        xMLWriter.tag("/" + this.getClass().getName());
    }

    public void toJSON(Writer writer) throws Exception {
        writer.write("{");
        writer.write("\"time\":" + this.time + ",\"pgs\":");
        this.pgs.toJSON(writer);
        writer.write(",\"actions\":[");
        boolean bl = true;
        for (Unit unit : this.unitActions.keySet()) {
            if (!bl) {
                writer.write(",");
            }
            bl = false;
            UnitActionAssignment unitActionAssignment = this.unitActions.get(unit);
            writer.write("{\"ID\":" + unitActionAssignment.unit.getID() + ", \"time\":" + unitActionAssignment.time + ", \"action\":");
            unitActionAssignment.action.toJSON(writer);
            writer.write("}");
        }
        writer.write("]");
        writer.write("}");
    }

    public int[][][] getMatrixObservation() {
        int n;
        int[][] nArray = new int[this.pgs.height][this.pgs.width];
        int[][] nArray2 = new int[this.pgs.height][this.pgs.width];
        int[][] nArray3 = new int[this.pgs.height][this.pgs.width];
        int[][] nArray4 = new int[this.pgs.height][this.pgs.width];
        int[][] nArray5 = new int[this.pgs.height][this.pgs.width];
        for (n = 0; n < nArray4.length; ++n) {
            Arrays.fill(nArray4[n], -1);
            Arrays.fill(nArray3[n], -1);
        }
        for (n = 0; n < this.pgs.units.size(); ++n) {
            Unit unit = this.pgs.units.get(n);
            UnitActionAssignment unitActionAssignment = this.unitActions.get(unit);
            nArray[unit.getY()][unit.getX()] = unit.getHitPoints();
            nArray2[unit.getY()][unit.getX()] = unit.getResources();
            nArray3[unit.getY()][unit.getX()] = unit.getPlayer();
            nArray4[unit.getY()][unit.getX()] = unit.getType().ID;
            nArray5[unit.getY()][unit.getX()] = unitActionAssignment != null ? unitActionAssignment.action.type : 0;
        }
        for (n = 0; n < nArray3.length; ++n) {
            int n2 = 0;
            while (n2 < nArray3[n].length) {
                int[] nArray6 = nArray4[n];
                int n3 = n2;
                nArray6[n3] = nArray6[n3] + 1;
                int[] nArray7 = nArray3[n];
                int n4 = n2++;
                nArray7[n4] = nArray7[n4] + 1;
            }
        }
        return new int[][][]{nArray, nArray2, nArray3, nArray4, nArray5};
    }

    public int[][][] getUnitObservation(Unit unit, int n) {
        int n2;
        int n3;
        int n4;
        int[][] nArray = new int[n * 2 + 1][n * 2 + 1];
        int[][] nArray2 = new int[n * 2 + 1][n * 2 + 1];
        int[][] nArray3 = new int[n * 2 + 1][n * 2 + 1];
        int[][] nArray4 = new int[n * 2 + 1][n * 2 + 1];
        int[][] nArray5 = new int[n * 2 + 1][n * 2 + 1];
        for (n4 = 0; n4 < nArray4.length; ++n4) {
            Arrays.fill(nArray3[n4], -1);
            Arrays.fill(nArray4[n4], -1);
        }
        n4 = n;
        int n5 = n;
        for (n3 = 0; n3 < nArray.length; ++n3) {
            for (n2 = 0; n2 < nArray.length; ++n2) {
                int n6 = n3 - n4;
                int n7 = n2 - n5;
                if (unit.getX() + n6 >= 0 && unit.getX() + n6 < this.pgs.width && unit.getY() + n7 >= 0 && unit.getY() + n7 < this.pgs.height) {
                    Unit unit2 = this.pgs.getUnitAt(unit.getX() + n6, unit.getY() + n7);
                    if (unit2 == null) continue;
                    UnitActionAssignment unitActionAssignment = this.unitActions.get(unit2);
                    nArray[n2][n3] = unit2.getHitPoints();
                    nArray2[n2][n3] = unit2.getResources();
                    nArray3[n2][n3] = unit2.getPlayer();
                    nArray4[n2][n3] = unit2.getType().ID;
                    if (unitActionAssignment != null) {
                        nArray5[n2][n3] = unitActionAssignment.action.type;
                        continue;
                    }
                    nArray5[n2][n3] = 0;
                    continue;
                }
                nArray[n2][n3] = -1;
                nArray2[n2][n3] = -1;
                nArray3[n2][n3] = -2;
                nArray4[n2][n3] = -2;
                nArray5[n2][n3] = -1;
            }
        }
        for (n3 = 0; n3 < nArray3.length; ++n3) {
            n2 = 0;
            while (n2 < nArray3[n3].length) {
                int[] nArray6 = nArray[n3];
                int n8 = n2;
                nArray6[n8] = nArray6[n8] + 1;
                int[] nArray7 = nArray2[n3];
                int n9 = n2;
                nArray7[n9] = nArray7[n9] + 1;
                int[] nArray8 = nArray3[n3];
                int n10 = n2;
                nArray8[n10] = nArray8[n10] + 2;
                int[] nArray9 = nArray4[n3];
                int n11 = n2;
                nArray9[n11] = nArray9[n11] + 2;
                int[] nArray10 = nArray5[n3];
                int n12 = n2++;
                nArray10[n12] = nArray10[n12] + 1;
            }
        }
        return new int[][][]{nArray, nArray2, nArray3, nArray4, nArray5};
    }

    public static GameState fromXML(Element element, UnitTypeTable unitTypeTable) throws Exception {
        PhysicalGameState physicalGameState = PhysicalGameState.fromXML(element.getChild(PhysicalGameState.class.getName()), unitTypeTable);
        GameState gameState = new GameState(physicalGameState, unitTypeTable);
        gameState.time = Integer.parseInt(element.getAttributeValue("time"));
        Element element2 = element.getChild("actions");
        for (Object e : element2.getChildren()) {
            Element element3 = (Element)e;
            long l = Long.parseLong(element3.getAttributeValue("ID"));
            Unit unit = gameState.getUnit(l);
            int n = Integer.parseInt(element3.getAttributeValue("time"));
            UnitAction unitAction = UnitAction.fromXML(element3.getChild("UnitAction"), unitTypeTable);
            UnitActionAssignment unitActionAssignment = new UnitActionAssignment(unit, unitAction, n);
            gameState.unitActions.put(unit, unitActionAssignment);
        }
        return gameState;
    }

    public static GameState fromJSON(String string, UnitTypeTable unitTypeTable) {
        JsonObject jsonObject = Json.parse(string).asObject();
        PhysicalGameState physicalGameState = PhysicalGameState.fromJSON(jsonObject.get("pgs").asObject(), unitTypeTable);
        GameState gameState = new GameState(physicalGameState, unitTypeTable);
        gameState.time = jsonObject.getInt("time", 0);
        JsonArray jsonArray = jsonObject.get("actions").asArray();
        for (JsonValue jsonValue : jsonArray.values()) {
            JsonObject jsonObject2 = jsonValue.asObject();
            long l = jsonObject2.getLong("ID", -1L);
            Unit unit = gameState.getUnit(l);
            int n = jsonObject2.getInt("time", 0);
            UnitAction unitAction = UnitAction.fromJSON(jsonObject2.get("action").asObject(), unitTypeTable);
            UnitActionAssignment unitActionAssignment = new UnitActionAssignment(unit, unitAction, n);
            gameState.unitActions.put(unit, unitActionAssignment);
        }
        return gameState;
    }
}

