/*
 * Decompiled with CFR 0.152.
 */
package rts;

import ai.core.AI;
import gui.PhysicalGameStateJFrame;
import gui.PhysicalGameStatePanel;
import gui.frontend.FrontEnd;
import java.lang.reflect.Constructor;
import java.net.ServerSocket;
import java.net.Socket;
import rts.GameSettings;
import rts.GameState;
import rts.PartiallyObservableGameState;
import rts.PhysicalGameState;
import rts.PlayerAction;
import rts.RemoteGame;
import rts.units.UnitTypeTable;

public class MicroRTS {
    public static void main(String[] stringArray) throws Exception {
        String string = "resources/config.properties";
        for (int j = stringArray.length; j > 0; --j) {
            if (!stringArray[j - 1].equals("-f")) continue;
            string = stringArray[j];
        }
        GameSettings gameSettings = GameSettings.loadFromConfig(GameSettings.fetchConfig(string));
        System.out.println(gameSettings);
        switch (gameSettings.getLaunchMode()) {
            case STANDALONE: {
                MicroRTS.runStandAloneGame(gameSettings);
            }
            case GUI: {
                FrontEnd.main(stringArray);
            }
            case SERVER: {
                MicroRTS.startServer(gameSettings);
                break;
            }
            case CLIENT: {
                MicroRTS.startClient(gameSettings);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void startServer(GameSettings gameSettings) throws Exception {
        ServerSocket serverSocket = new ServerSocket(gameSettings.getServerPort());
        Throwable throwable = null;
        try {
            try {
                while (true) {
                    try {
                        while (true) {
                            Socket socket;
                            block20: {
                                socket = serverSocket.accept();
                                Throwable throwable2 = null;
                                try {
                                    new RemoteGame(socket, gameSettings).run();
                                    if (socket == null) continue;
                                    if (throwable2 == null) break block20;
                                }
                                catch (Throwable throwable3) {
                                    try {
                                        throwable2 = throwable3;
                                        throw throwable3;
                                    }
                                    catch (Throwable throwable4) {
                                        if (socket == null) throw throwable4;
                                        if (throwable2 == null) {
                                            socket.close();
                                            throw throwable4;
                                        }
                                        try {
                                            socket.close();
                                            throw throwable4;
                                        }
                                        catch (Throwable throwable5) {
                                            throwable2.addSuppressed(throwable5);
                                            throw throwable4;
                                        }
                                    }
                                }
                                try {
                                    socket.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable2.addSuppressed(throwable6);
                                }
                                continue;
                            }
                            socket.close();
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable throwable7) {
                throwable = throwable7;
                throw throwable7;
            }
        }
        catch (Throwable throwable8) {
            if (serverSocket == null) throw throwable8;
            if (throwable == null) {
                serverSocket.close();
                throw throwable8;
            }
            try {
                serverSocket.close();
                throw throwable8;
            }
            catch (Throwable throwable9) {
                throwable.addSuppressed(throwable9);
                throw throwable8;
            }
        }
    }

    private static void startClient(GameSettings gameSettings) throws Exception {
        Socket socket = new Socket(gameSettings.getServerAddress(), gameSettings.getServerPort());
        new RemoteGame(socket, gameSettings).run();
    }

    public static void runStandAloneGame(GameSettings gameSettings) throws Exception {
        UnitTypeTable unitTypeTable = new UnitTypeTable(gameSettings.getUTTVersion(), gameSettings.getConflictPolicy());
        PhysicalGameState physicalGameState = PhysicalGameState.load(gameSettings.getMapLocation(), unitTypeTable);
        GameState gameState = new GameState(physicalGameState, unitTypeTable);
        int n = 20;
        boolean bl = false;
        Constructor<?> constructor = Class.forName(gameSettings.getAI1()).getConstructor(UnitTypeTable.class);
        AI aI = (AI)constructor.newInstance(unitTypeTable);
        Constructor<?> constructor2 = Class.forName(gameSettings.getAI2()).getConstructor(UnitTypeTable.class);
        AI aI2 = (AI)constructor2.newInstance(unitTypeTable);
        PhysicalGameStateJFrame physicalGameStateJFrame = PhysicalGameStatePanel.newVisualizer(gameState, 640, 640, gameSettings.isPartiallyObservable(), PhysicalGameStatePanel.COLORSCHEME_BLACK);
        long l = System.currentTimeMillis() + (long)n;
        do {
            if (System.currentTimeMillis() >= l) {
                PlayerAction playerAction;
                PlayerAction playerAction2;
                if (gameSettings.isPartiallyObservable()) {
                    playerAction2 = aI.getAction(0, new PartiallyObservableGameState(gameState, 0));
                    playerAction = aI2.getAction(1, new PartiallyObservableGameState(gameState, 1));
                    gameState.issueSafe(playerAction2);
                    gameState.issueSafe(playerAction);
                } else {
                    playerAction2 = aI.getAction(0, gameState);
                    playerAction = aI2.getAction(1, gameState);
                    gameState.issueSafe(playerAction2);
                    gameState.issueSafe(playerAction);
                }
                bl = gameState.cycle();
                physicalGameStateJFrame.repaint();
                l += (long)n;
                continue;
            }
            try {
                Thread.sleep(1L);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } while (!bl && gameState.getTime() < gameSettings.getMaxCycles());
        aI.gameOver(gameState.winner());
        aI2.gameOver(gameState.winner());
    }
}

