/*
 * Decompiled with CFR 0.152.
 */
package rts;

import java.util.LinkedList;
import rts.GameState;
import rts.units.Unit;

public class PartiallyObservableGameState
extends GameState {
    protected int player;

    public PartiallyObservableGameState(GameState gameState, int n) {
        super(gameState.getPhysicalGameState().cloneKeepingUnits(), gameState.getUnitTypeTable());
        this.unitCancelationCounter = gameState.unitCancelationCounter;
        this.time = gameState.time;
        this.player = n;
        this.unitActions.putAll(gameState.unitActions);
        LinkedList<Unit> linkedList = new LinkedList<Unit>();
        for (Unit unit : this.pgs.getUnits()) {
            if (unit.getPlayer() == this.player || this.observable(unit.getX(), unit.getY())) continue;
            linkedList.add(unit);
        }
        for (Unit unit : linkedList) {
            this.removeUnit(unit);
        }
    }

    @Override
    public boolean observable(int n, int n2) {
        for (Unit unit : this.pgs.getUnits()) {
            double d;
            if (unit.getPlayer() != this.player || !((d = Math.sqrt((unit.getX() - n) * (unit.getX() - n) + (unit.getY() - n2) * (unit.getY() - n2))) <= (double)unit.getType().sightRadius)) continue;
            return true;
        }
        return false;
    }

    @Override
    public PartiallyObservableGameState clone() {
        return new PartiallyObservableGameState(super.clone(), this.player);
    }
}

