/*
 * Decompiled with CFR 0.152.
 */
package rts;

import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import rts.Player;
import rts.units.Unit;
import rts.units.UnitTypeTable;
import util.XMLWriter;

public class PhysicalGameState {
    public static final int TERRAIN_NONE = 0;
    public static final int TERRAIN_WALL = 1;
    int width = 8;
    int height = 8;
    int[] terrain = null;
    List<Player> players = new ArrayList<Player>();
    List<Unit> units = new LinkedList<Unit>();
    public static final int NO_UNIT_ID = -1;
    int[] hitpointsShape;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PhysicalGameState load(String string, UnitTypeTable unitTypeTable) throws JDOMException, IOException, Exception {
        try {
            return PhysicalGameState.fromXML(new SAXBuilder().build(string).getRootElement(), unitTypeTable);
        }
        catch (FileNotFoundException | IllegalArgumentException exception) {
            try (InputStream inputStream = PhysicalGameState.class.getClassLoader().getResourceAsStream(string);){
                PhysicalGameState physicalGameState = PhysicalGameState.fromXML(new SAXBuilder().build(inputStream).getRootElement(), unitTypeTable);
                return physicalGameState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException("Error loading map: " + string, illegalArgumentException);
            }
        }
    }

    public PhysicalGameState(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.terrain = new int[this.width * this.height];
        this.hitpointsShape = new int[]{this.width, this.height, 2};
    }

    PhysicalGameState(int n, int n2, int[] nArray) {
        this.width = n;
        this.height = n2;
        this.terrain = nArray;
        this.hitpointsShape = new int[]{this.width, this.height, 2};
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public int getTerrain(int n, int n2) {
        return this.terrain[n + n2 * this.width];
    }

    public void setTerrain(int n, int n2, int n3) {
        this.terrain[n + n2 * this.width] = n3;
    }

    public void setTerrain(int[] nArray) {
        this.terrain = nArray;
    }

    public void addPlayer(Player player) {
        if (player.getID() != this.players.size()) {
            throw new IllegalArgumentException("PhysicalGameState.addPlayer: player added in the wrong order.");
        }
        this.players.add(player);
    }

    public void addUnit(Unit unit) throws IllegalArgumentException {
        for (Unit unit2 : this.units) {
            if (unit.getX() != unit2.getX() || unit.getY() != unit2.getY()) continue;
            throw new IllegalArgumentException("PhysicalGameState.addUnit: added two units in position: (" + unit.getX() + ", " + unit.getY() + ")");
        }
        this.units.add(unit);
    }

    public void removeUnit(Unit unit) {
        this.units.remove(unit);
    }

    public List<Unit> getUnits() {
        return this.units;
    }

    public List<Player> getPlayers() {
        return this.players;
    }

    public Player getPlayer(int n) {
        return this.players.get(n);
    }

    public Unit getUnit(long l) {
        for (Unit unit : this.units) {
            if (unit.getID() != l) continue;
            return unit;
        }
        return null;
    }

    public Unit getUnitAt(int n, int n2) {
        for (Unit unit : this.units) {
            if (unit.getX() != n || unit.getY() != n2) continue;
            return unit;
        }
        return null;
    }

    public Collection<Unit> getUnitsAround(int n, int n2, int n3) {
        return this.getUnitsAround(n, n2, n3, n3);
    }

    public Collection<Unit> getUnitsAround(int n, int n2, int n3, int n4) {
        LinkedList<Unit> linkedList = new LinkedList<Unit>();
        for (Unit unit : this.units) {
            if (Math.abs(unit.getX() - n) > n3 || Math.abs(unit.getY() - n2) > n4) continue;
            linkedList.add(unit);
        }
        return linkedList;
    }

    public int winner() {
        int[] nArray = new int[this.players.size()];
        for (Unit unit : this.units) {
            if (unit.getPlayer() < 0) continue;
            int n = unit.getPlayer();
            nArray[n] = nArray[n] + 1;
        }
        int n = -1;
        for (int j = 0; j < nArray.length; ++j) {
            if (nArray[j] <= 0) continue;
            if (n == -1) {
                n = j;
                continue;
            }
            return -1;
        }
        return n;
    }

    boolean gameover() {
        int[] nArray = new int[this.players.size()];
        int n = 0;
        for (Unit unit : this.units) {
            if (unit.getPlayer() < 0) continue;
            int n2 = unit.getPlayer();
            nArray[n2] = nArray[n2] + 1;
            ++n;
        }
        if (n == 0) {
            return true;
        }
        int n3 = -1;
        for (int j = 0; j < nArray.length; ++j) {
            if (nArray[j] <= 0) continue;
            if (n3 == -1) {
                n3 = j;
                continue;
            }
            return false;
        }
        return n3 != -1;
    }

    public PhysicalGameState clone() {
        PhysicalGameState physicalGameState = new PhysicalGameState(this.width, this.height, this.terrain);
        for (Player object : this.players) {
            physicalGameState.players.add(object.clone());
        }
        for (Unit unit : this.units) {
            physicalGameState.units.add(unit.clone());
        }
        return physicalGameState;
    }

    public PhysicalGameState cloneKeepingUnits() {
        PhysicalGameState physicalGameState = new PhysicalGameState(this.width, this.height, this.terrain);
        for (Player object : this.players) {
            physicalGameState.players.add(object);
        }
        for (Unit unit : this.units) {
            physicalGameState.units.add(unit);
        }
        return physicalGameState;
    }

    public PhysicalGameState cloneIncludingTerrain() {
        int[] nArray = new int[this.terrain.length];
        for (int j = 0; j < this.terrain.length; ++j) {
            nArray[j] = this.terrain[j];
        }
        PhysicalGameState physicalGameState = new PhysicalGameState(this.width, this.height, nArray);
        for (Player object : this.players) {
            physicalGameState.players.add(object.clone());
        }
        for (Unit unit : this.units) {
            physicalGameState.units.add(unit.clone());
        }
        return physicalGameState;
    }

    public String toString() {
        String string = "PhysicalGameState:\n";
        for (Player object : this.players) {
            string = string + "  " + object + "\n";
        }
        for (Unit unit : this.units) {
            string = string + "  " + unit + "\n";
        }
        return string;
    }

    public boolean equivalents(PhysicalGameState physicalGameState) {
        int n;
        if (this.width != physicalGameState.width) {
            return false;
        }
        if (this.height != physicalGameState.height) {
            return false;
        }
        if (this.players.size() != physicalGameState.players.size()) {
            return false;
        }
        for (n = 0; n < this.players.size(); ++n) {
            if (this.players.get((int)n).ID != physicalGameState.players.get((int)n).ID) {
                return false;
            }
            if (this.players.get((int)n).resources == physicalGameState.players.get((int)n).resources) continue;
            return false;
        }
        if (this.units.size() != physicalGameState.units.size()) {
            return false;
        }
        for (n = 0; n < this.units.size(); ++n) {
            if (this.units.get(n).getType() != physicalGameState.units.get(n).getType()) {
                return false;
            }
            if (this.units.get(n).getHitPoints() != physicalGameState.units.get(n).getHitPoints()) {
                return false;
            }
            if (this.units.get(n).getX() != physicalGameState.units.get(n).getX()) {
                return false;
            }
            if (this.units.get(n).getY() == physicalGameState.units.get(n).getY()) continue;
            return false;
        }
        return true;
    }

    public boolean[][] getAllFree() {
        boolean[][] blArray = new boolean[this.getWidth()][this.getHeight()];
        for (int j = 0; j < this.getWidth(); ++j) {
            for (int k = 0; k < this.getHeight(); ++k) {
                blArray[j][k] = this.getTerrain(j, k) == 0;
            }
        }
        for (Unit unit : this.units) {
            blArray[unit.getX()][unit.getY()] = false;
        }
        return blArray;
    }

    public void toxml(XMLWriter xMLWriter) {
        xMLWriter.tagWithAttributes(this.getClass().getName(), "width=\"" + this.width + "\" height=\"" + this.height + "\"");
        StringBuilder stringBuilder = new StringBuilder(this.height * this.width);
        for (int j = 0; j < this.height * this.width; ++j) {
            stringBuilder.append(this.terrain[j]);
        }
        xMLWriter.tag("terrain", stringBuilder.toString());
        xMLWriter.tag("players");
        for (Player object : this.players) {
            object.toxml(xMLWriter);
        }
        xMLWriter.tag("/players");
        xMLWriter.tag("units");
        for (Unit unit : this.units) {
            unit.toxml(xMLWriter);
        }
        xMLWriter.tag("/units");
        xMLWriter.tag("/" + this.getClass().getName());
    }

    public void toJSON(Writer writer) throws Exception {
        int n;
        writer.write("{");
        writer.write("\"width\":" + this.width + ",\"height\":" + this.height + ",");
        writer.write("\"terrain\":\"");
        for (n = 0; n < this.height * this.width; ++n) {
            writer.write("" + this.terrain[n]);
        }
        writer.write("\",");
        writer.write("\"players\":[");
        for (n = 0; n < this.players.size(); ++n) {
            this.players.get(n).toJSON(writer);
            if (n >= this.players.size() - 1) continue;
            writer.write(",");
        }
        writer.write("],");
        writer.write("\"units\":[");
        for (n = 0; n < this.units.size(); ++n) {
            this.units.get(n).toJSON(writer);
            if (n >= this.units.size() - 1) continue;
            writer.write(",");
        }
        writer.write("]");
        writer.write("}");
    }

    public static PhysicalGameState fromXML(Element element, UnitTypeTable unitTypeTable) throws Exception {
        Element element2;
        Element element3 = element.getChild("terrain");
        Element element4 = element.getChild("players");
        Element element5 = element.getChild("units");
        int n = Integer.parseInt(element.getAttributeValue("width"));
        int n2 = Integer.parseInt(element.getAttributeValue("height"));
        int[] nArray = new int[n * n2];
        String string = element3.getValue();
        for (int j = 0; j < n * n2; ++j) {
            Iterator iterator = string.substring(j, j + 1);
            nArray[j] = Integer.parseInt((String)((Object)iterator));
        }
        PhysicalGameState physicalGameState = new PhysicalGameState(n, n2, nArray);
        for (Object e : element4.getChildren()) {
            element2 = (Element)e;
            physicalGameState.addPlayer(Player.fromXML(element2));
        }
        for (Object e : element5.getChildren()) {
            element2 = (Element)e;
            Unit unit = Unit.fromXML(element2, unitTypeTable);
            if (physicalGameState.getUnit(unit.getID()) != null) {
                throw new Exception("Repeated unit ID " + unit.getID() + " in map!");
            }
            physicalGameState.addUnit(unit);
        }
        return physicalGameState;
    }

    public static PhysicalGameState fromJSON(JsonObject jsonObject, UnitTypeTable unitTypeTable) {
        JsonObject jsonObject2;
        String string = jsonObject.getString("terrain", null);
        JsonArray jsonArray = jsonObject.get("players").asArray();
        JsonArray jsonArray2 = jsonObject.get("units").asArray();
        int n = jsonObject.getInt("width", 8);
        int n2 = jsonObject.getInt("height", 8);
        int[] nArray = new int[n * n2];
        for (int j = 0; j < n * n2; ++j) {
            Iterator<JsonValue> iterator = string.substring(j, j + 1);
            nArray[j] = Integer.parseInt((String)((Object)iterator));
        }
        PhysicalGameState physicalGameState = new PhysicalGameState(n, n2, nArray);
        for (JsonValue jsonValue : jsonArray.values()) {
            jsonObject2 = (JsonObject)jsonValue;
            physicalGameState.addPlayer(Player.fromJSON(jsonObject2));
        }
        for (JsonValue jsonValue : jsonArray2.values()) {
            jsonObject2 = (JsonObject)jsonValue;
            physicalGameState.addUnit(Unit.fromJSON(jsonObject2, unitTypeTable));
        }
        return physicalGameState;
    }
}

