/*
 * Decompiled with CFR 0.152.
 */
package rts;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import org.jdom.Element;
import rts.GameState;
import rts.InvalidPlayerActionStats;
import rts.PhysicalGameState;
import rts.ResourceUsage;
import rts.UnitAction;
import rts.UnitActionAssignment;
import rts.units.Unit;
import rts.units.UnitTypeTable;
import util.Pair;
import util.XMLWriter;

public class PlayerAction {
    List<Pair<Unit, UnitAction>> actions = new LinkedList<Pair<Unit, UnitAction>>();
    ResourceUsage r = new ResourceUsage();

    public boolean equals(Object object) {
        if (!(object instanceof PlayerAction)) {
            return false;
        }
        PlayerAction playerAction = (PlayerAction)object;
        for (Pair<Unit, UnitAction> pair : this.actions) {
            for (Pair<Unit, UnitAction> pair2 : playerAction.actions) {
                if (((Unit)pair.m_a).getID() != ((Unit)pair2.m_a).getID() || ((UnitAction)pair.m_b).equals(pair2.m_b)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isEmpty() {
        return this.actions.isEmpty();
    }

    public boolean hasNonNoneActions() {
        for (Pair<Unit, UnitAction> pair : this.actions) {
            if (((UnitAction)pair.m_b).type == 0) continue;
            return true;
        }
        return false;
    }

    public int hasNamNoneActions() {
        int n = 0;
        for (Pair<Unit, UnitAction> pair : this.actions) {
            if (((UnitAction)pair.m_b).type == 0) continue;
            ++n;
        }
        return n;
    }

    public ResourceUsage getResourceUsage() {
        return this.r;
    }

    public void setResourceUsage(ResourceUsage resourceUsage) {
        this.r = resourceUsage;
    }

    public void addUnitAction(Unit unit, UnitAction unitAction) {
        this.actions.add(new Pair<Unit, UnitAction>(unit, unitAction));
    }

    public void removeUnitAction(Unit unit, UnitAction unitAction) {
        Pair<Unit, UnitAction> pair = null;
        for (Pair<Unit, UnitAction> pair2 : this.actions) {
            if (pair2.m_a != unit || pair2.m_b != unitAction) continue;
            pair = pair2;
            break;
        }
        if (pair != null) {
            this.actions.remove(pair);
        }
    }

    public PlayerAction merge(PlayerAction playerAction) {
        PlayerAction playerAction2 = new PlayerAction();
        for (Pair<Unit, UnitAction> pair : this.actions) {
            playerAction2.actions.add(pair);
        }
        for (Pair<Unit, UnitAction> pair : playerAction.actions) {
            playerAction2.actions.add(pair);
        }
        playerAction2.r = this.r.mergeIntoNew(playerAction.r);
        return playerAction2;
    }

    public List<Pair<Unit, UnitAction>> getActions() {
        return this.actions;
    }

    public UnitAction getAction(Unit unit) {
        for (Pair<Unit, UnitAction> pair : this.actions) {
            if (pair.m_a != unit) continue;
            return (UnitAction)pair.m_b;
        }
        return null;
    }

    public List<PlayerAction> cartesianProduct(List<UnitAction> list, Unit unit, GameState gameState) {
        LinkedList<PlayerAction> linkedList = new LinkedList<PlayerAction>();
        for (UnitAction unitAction : list) {
            ResourceUsage resourceUsage = unitAction.resourceUsage(unit, gameState.getPhysicalGameState());
            if (!this.r.consistentWith(resourceUsage, gameState)) continue;
            PlayerAction playerAction = new PlayerAction();
            playerAction.r = this.r.mergeIntoNew(resourceUsage);
            playerAction.actions.addAll(this.actions);
            playerAction.addUnitAction(unit, unitAction);
            linkedList.add(playerAction);
        }
        return linkedList;
    }

    public boolean consistentWith(ResourceUsage resourceUsage, GameState gameState) {
        return this.r.consistentWith(resourceUsage, gameState);
    }

    public void fillWithNones(GameState gameState, int n, int n2) {
        PhysicalGameState physicalGameState = gameState.getPhysicalGameState();
        for (Unit unit : physicalGameState.getUnits()) {
            if (unit.getPlayer() != n || gameState.unitActions.get(unit) != null) continue;
            boolean bl = false;
            for (Pair<Unit, UnitAction> pair : this.actions) {
                if (pair.m_a != unit) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            this.actions.add(new Pair<Unit, UnitAction>(unit, new UnitAction(0, n2)));
        }
    }

    public boolean integrityCheck() {
        int n = -1;
        for (Pair<Unit, UnitAction> pair : this.actions) {
            Unit unit = (Unit)pair.m_a;
            if (n == -1) {
                n = unit.getPlayer();
                continue;
            }
            if (n == unit.getPlayer()) continue;
            System.err.println("integrityCheck: units from more than one player!");
            return false;
        }
        return true;
    }

    public PlayerAction clone() {
        PlayerAction playerAction = new PlayerAction();
        playerAction.actions = new LinkedList<Pair<Unit, UnitAction>>();
        for (Pair<Unit, UnitAction> pair : this.actions) {
            playerAction.actions.add(new Pair(pair.m_a, pair.m_b));
        }
        playerAction.r = this.r.clone();
        return playerAction;
    }

    public void clear() {
        this.actions.clear();
        this.r = new ResourceUsage();
    }

    public String toString() {
        String string = "{ ";
        for (Pair<Unit, UnitAction> pair : this.actions) {
            string = string + "(" + pair.m_a + "," + pair.m_b + ")";
        }
        return string + " }";
    }

    public void toxml(XMLWriter xMLWriter) {
        xMLWriter.tag("PlayerAction");
        for (Pair<Unit, UnitAction> pair : this.actions) {
            xMLWriter.tagWithAttributes("action", "unitID=\"" + ((Unit)pair.m_a).getID() + "\"");
            ((UnitAction)pair.m_b).toxml(xMLWriter);
            xMLWriter.tag("/action");
        }
        xMLWriter.tag("/PlayerAction");
    }

    public void toJSON(Writer writer) throws Exception {
        boolean bl = true;
        writer.write("[");
        for (Pair<Unit, UnitAction> pair : this.actions) {
            if (!bl) {
                writer.write(" ,");
            }
            writer.write("{\"unitID\":" + ((Unit)pair.m_a).getID() + ", \"unitAction\":");
            ((UnitAction)pair.m_b).toJSON(writer);
            writer.write("}");
            bl = false;
        }
        writer.write("]");
    }

    public static PlayerAction fromXML(Element element, GameState gameState, UnitTypeTable unitTypeTable) {
        PlayerAction playerAction = new PlayerAction();
        List list = element.getChildren("action");
        for (Object e : list) {
            Element element2 = (Element)e;
            int n = Integer.parseInt(element2.getAttributeValue("unitID"));
            Unit unit = gameState.getUnit(n);
            UnitAction unitAction = UnitAction.fromXML(element2.getChild("UnitAction"), unitTypeTable);
            playerAction.addUnitAction(unit, unitAction);
        }
        return playerAction;
    }

    public static PlayerAction fromJSON(String string, GameState gameState, UnitTypeTable unitTypeTable) {
        PlayerAction playerAction = new PlayerAction();
        JsonArray jsonArray = Json.parse(string).asArray();
        for (JsonValue jsonValue : jsonArray.values()) {
            JsonObject jsonObject = jsonValue.asObject();
            int n = jsonObject.getInt("unitID", -1);
            Unit unit = gameState.getUnit(n);
            UnitAction unitAction = UnitAction.fromJSON(jsonObject.get("unitAction").asObject(), unitTypeTable);
            playerAction.addUnitAction(unit, unitAction);
        }
        return playerAction;
    }

    public static Pair<PlayerAction, InvalidPlayerActionStats> fromActionArrays(int[][] nArray, GameState gameState, UnitTypeTable unitTypeTable, int n) {
        PlayerAction playerAction = new PlayerAction();
        InvalidPlayerActionStats invalidPlayerActionStats = new InvalidPlayerActionStats();
        for (int[] nArray2 : nArray) {
            Unit unit = gameState.pgs.getUnitAt(nArray2[0] % gameState.pgs.width, nArray2[0] / gameState.pgs.width);
            UnitActionAssignment unitActionAssignment = gameState.unitActions.get(unit);
            if (unit == null) {
                ++invalidPlayerActionStats.numInvalidActionNull;
            } else if (unit.getPlayer() != n) {
                ++invalidPlayerActionStats.numInvalidActionOwnership;
            }
            if (unitActionAssignment != null && UnitAction.fromActionArray((int[])nArray2, (UnitTypeTable)unitTypeTable, (GameState)gameState).type != 0) {
                ++invalidPlayerActionStats.numInvalidActionBusyUnit;
            }
            if (unit == null || unit.getPlayer() != n || unitActionAssignment != null) continue;
            UnitAction unitAction = UnitAction.fromActionArray(nArray2, unitTypeTable, gameState);
            playerAction.addUnitAction(unit, unitAction);
        }
        return new Pair<PlayerAction, InvalidPlayerActionStats>(playerAction, invalidPlayerActionStats);
    }

    public static PlayerAction fromActionArrayForUnit(int[][] nArray, GameState gameState, UnitTypeTable unitTypeTable, int n, Unit unit) {
        PlayerAction playerAction = new PlayerAction();
        if (nArray.length > 0) {
            UnitActionAssignment unitActionAssignment = gameState.unitActions.get(unit);
            if (unit != null && unit.getPlayer() == n && unitActionAssignment == null) {
                UnitAction unitAction = UnitAction.fromActionArrayForUnit(nArray[0], unitTypeTable, gameState, unit);
                playerAction.addUnitAction(unit, unitAction);
            }
        }
        return playerAction;
    }

    public static Pair<PlayerAction, Integer> fromActionArrays(String string, GameState gameState, UnitTypeTable unitTypeTable, int n) {
        int n2 = 0;
        PlayerAction playerAction = new PlayerAction();
        JsonArray jsonArray = Json.parse(string).asArray();
        for (JsonValue jsonValue : jsonArray.values()) {
            JsonArray jsonArray2 = jsonValue.asArray();
            n2 = jsonArray2.get(10).asInt();
            Unit unit = gameState.pgs.getUnitAt(jsonArray2.get(0).asInt(), jsonArray2.get(1).asInt());
            UnitActionAssignment unitActionAssignment = gameState.unitActions.get(unit);
            if (unit == null || unit.getPlayer() != n || unitActionAssignment != null) continue;
            int n3 = (int)unit.getID();
            UnitAction unitAction = UnitAction.fromActionArray(jsonArray2, unitTypeTable);
            playerAction.addUnitAction(unit, unitAction);
        }
        return new Pair<PlayerAction, Integer>(playerAction, n2);
    }

    public static Pair<PlayerAction, Integer> fromActionArrayForUnit(String string, GameState gameState, UnitTypeTable unitTypeTable, int n, Unit unit) {
        int n2 = 0;
        PlayerAction playerAction = new PlayerAction();
        JsonArray jsonArray = Json.parse(string).asArray();
        for (JsonValue jsonValue : jsonArray.values()) {
            JsonArray jsonArray2 = jsonValue.asArray();
            n2 = jsonArray2.get(8).asInt();
            UnitActionAssignment unitActionAssignment = gameState.unitActions.get(unit);
            if (unit == null || unit.getPlayer() != n || unitActionAssignment != null) continue;
            UnitAction unitAction = UnitAction.fromActionArrayForUnit(jsonArray2, unitTypeTable, gameState, unit);
            playerAction.addUnitAction(unit, unitAction);
        }
        return new Pair<PlayerAction, Integer>(playerAction, n2);
    }

    public static Pair<PlayerAction, InvalidPlayerActionStats> fromActionArraysWithPenalty(String string, GameState gameState, UnitTypeTable unitTypeTable, int n) {
        PlayerAction playerAction = new PlayerAction();
        JsonArray jsonArray = Json.parse(string).asArray();
        InvalidPlayerActionStats invalidPlayerActionStats = new InvalidPlayerActionStats();
        for (JsonValue jsonValue : jsonArray.values()) {
            JsonArray jsonArray2 = jsonValue.asArray();
            Unit unit = gameState.pgs.getUnitAt(jsonArray2.get(0).asInt(), jsonArray2.get(1).asInt());
            UnitAction unitAction = UnitAction.fromActionArray(jsonArray2, unitTypeTable);
            if (unit == null) {
                ++invalidPlayerActionStats.numInvalidActionNull;
                return new Pair<PlayerAction, InvalidPlayerActionStats>(playerAction, invalidPlayerActionStats);
            }
            UnitActionAssignment unitActionAssignment = gameState.unitActions.get(unit);
            if (unit.getPlayer() != n) {
                ++invalidPlayerActionStats.numInvalidActionOwnership;
            }
            if (unitActionAssignment != null && unitAction.type != 0) {
                ++invalidPlayerActionStats.numInvalidActionBusyUnit;
            }
            if (unit == null || unit.getPlayer() != n || unitActionAssignment != null) continue;
            playerAction.addUnitAction(unit, unitAction);
        }
        return new Pair<PlayerAction, InvalidPlayerActionStats>(playerAction, invalidPlayerActionStats);
    }
}

