/*
 * Decompiled with CFR 0.152.
 */
package rts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import rts.GameState;
import rts.PhysicalGameState;
import rts.PlayerAction;
import rts.ResourceUsage;
import rts.UnitAction;
import rts.UnitActionAssignment;
import rts.units.Unit;
import util.Pair;

public class PlayerActionGenerator {
    static Random r = new Random();
    GameState gameState;
    PhysicalGameState physicalGameState;
    ResourceUsage base_ru = new ResourceUsage();
    List<Pair<Unit, List<UnitAction>>> choices;
    PlayerAction lastAction = null;
    long size = 1L;
    long generated = 0L;
    int[] choiceSizes = null;
    int[] currentChoice = null;
    boolean moreActions = true;

    public long getGenerated() {
        return this.generated;
    }

    public long getSize() {
        return this.size;
    }

    public PlayerAction getLastAction() {
        return this.lastAction;
    }

    public List<Pair<Unit, List<UnitAction>>> getChoices() {
        return this.choices;
    }

    public PlayerActionGenerator(GameState gameState, int n) throws Exception {
        this.gameState = gameState;
        this.physicalGameState = this.gameState.getPhysicalGameState();
        for (Unit object2 : this.physicalGameState.getUnits()) {
            UnitActionAssignment unitActionAssignment = this.gameState.unitActions.get(object2);
            if (unitActionAssignment == null) continue;
            ResourceUsage resourceUsage = unitActionAssignment.action.resourceUsage(object2, this.physicalGameState);
            this.base_ru.merge(resourceUsage);
        }
        this.choices = new ArrayList<Pair<Unit, List<UnitAction>>>();
        for (Unit unit : this.physicalGameState.getUnits()) {
            if (unit.getPlayer() != n || this.gameState.unitActions.get(unit) != null) continue;
            List<UnitAction> list = unit.getUnitActions(this.gameState);
            this.choices.add(new Pair<Unit, List<UnitAction>>(unit, list));
            long l = list.size();
            if (Long.MAX_VALUE / this.size <= l) {
                this.size = Long.MAX_VALUE;
                continue;
            }
            this.size *= (long)list.size();
        }
        if (this.choices.size() == 0) {
            System.err.println("Problematic game state:");
            System.err.println(gameState);
            throw new Exception("Move generator for player " + n + " created with no units that can execute actions! (status: " + gameState.canExecuteAnyAction(0) + ", " + gameState.canExecuteAnyAction(1) + ")");
        }
        this.choiceSizes = new int[this.choices.size()];
        this.currentChoice = new int[this.choices.size()];
        int n2 = 0;
        for (Pair<Unit, List<UnitAction>> pair : this.choices) {
            this.choiceSizes[n2] = ((List)pair.m_b).size();
            this.currentChoice[n2] = 0;
            ++n2;
        }
    }

    public void randomizeOrder() {
        for (Pair<Unit, List<UnitAction>> pair : this.choices) {
            LinkedList linkedList = new LinkedList();
            linkedList.addAll((Collection)pair.m_b);
            ((List)pair.m_b).clear();
            while (!linkedList.isEmpty()) {
                ((List)pair.m_b).add(linkedList.remove(r.nextInt(linkedList.size())));
            }
        }
    }

    public void incrementCurrentChoice(int n) {
        for (int j = 0; j < n; ++j) {
            this.currentChoice[j] = 0;
        }
        int n2 = n;
        this.currentChoice[n2] = this.currentChoice[n2] + 1;
        if (this.currentChoice[n] >= this.choiceSizes[n]) {
            if (n < this.currentChoice.length - 1) {
                this.incrementCurrentChoice(n + 1);
            } else {
                this.moreActions = false;
            }
        }
    }

    public PlayerAction getNextAction(long l) throws Exception {
        int n = 0;
        while (this.moreActions) {
            boolean bl = true;
            PlayerAction playerAction = new PlayerAction();
            playerAction.setResourceUsage(this.base_ru.clone());
            int n2 = this.choices.size();
            if (n2 == 0) {
                throw new Exception("Move generator created with no units that can execute actions!");
            }
            while (n2 > 0) {
                Pair<Unit, List<UnitAction>> pair = this.choices.get(--n2);
                int n3 = this.currentChoice[n2];
                Unit unit = (Unit)pair.m_a;
                UnitAction unitAction = (UnitAction)((List)pair.m_b).get(n3);
                ResourceUsage resourceUsage = unitAction.resourceUsage(unit, this.physicalGameState);
                if (playerAction.getResourceUsage().consistentWith(resourceUsage, this.gameState)) {
                    playerAction.getResourceUsage().merge(resourceUsage);
                    playerAction.addUnitAction(unit, unitAction);
                    continue;
                }
                bl = false;
                break;
            }
            this.incrementCurrentChoice(n2);
            if (bl) {
                this.lastAction = playerAction;
                ++this.generated;
                return playerAction;
            }
            if (l > 0L && n % 1000 == 0 && System.currentTimeMillis() > l) {
                this.lastAction = null;
                return null;
            }
            ++n;
        }
        this.lastAction = null;
        return null;
    }

    public PlayerAction getRandom() {
        Random random = new Random();
        PlayerAction playerAction = new PlayerAction();
        playerAction.setResourceUsage(this.base_ru.clone());
        for (Pair<Unit, List<UnitAction>> pair : this.choices) {
            LinkedList linkedList = new LinkedList();
            linkedList.addAll((Collection)pair.m_b);
            Unit unit = (Unit)pair.m_a;
            boolean bl = false;
            do {
                UnitAction unitAction = (UnitAction)linkedList.remove(random.nextInt(linkedList.size()));
                ResourceUsage resourceUsage = unitAction.resourceUsage(unit, this.physicalGameState);
                if (!playerAction.getResourceUsage().consistentWith(resourceUsage, this.gameState)) continue;
                playerAction.getResourceUsage().merge(resourceUsage);
                playerAction.addUnitAction(unit, unitAction);
                bl = true;
            } while (!bl);
        }
        return playerAction;
    }

    public long getActionIndex(PlayerAction playerAction) {
        int[] nArray = new int[this.choices.size()];
        for (Pair<Unit, UnitAction> pair : playerAction.actions) {
            int n = 0;
            Pair<Unit, List<UnitAction>> pair2 = null;
            for (Pair<Unit, List<UnitAction>> pair3 : this.choices) {
                if (pair.m_a == pair3.m_a) {
                    pair2 = pair3;
                    break;
                }
                ++n;
            }
            if (pair2 == null) {
                return -1L;
            }
            nArray[n] = ((List)pair2.m_b).indexOf(pair.m_b);
        }
        long l = 0L;
        long l2 = 1L;
        for (int j = 0; j < nArray.length; ++j) {
            l += (long)nArray[j] * l2;
            l2 *= (long)this.choiceSizes[j];
        }
        return l;
    }

    public String toString() {
        String string = "PlayerActionGenerator:\n";
        for (Pair<Unit, List<UnitAction>> pair : this.choices) {
            string = string + "  (" + pair.m_a + "," + ((List)pair.m_b).size() + ")\n";
        }
        string = string + "currentChoice: ";
        for (int j = 0; j < this.currentChoice.length; ++j) {
            string = string + this.currentChoice[j] + " ";
        }
        string = string + "\nactions generated so far: " + this.generated;
        return string;
    }
}

