/*
 * Decompiled with CFR 0.152.
 */
package rts;

import ai.RandomBiasedAI;
import ai.core.AI;
import ai.socket.SocketAI;
import gui.PhysicalGameStateJFrame;
import gui.PhysicalGameStatePanel;
import java.net.Socket;
import rts.GameSettings;
import rts.GameState;
import rts.PartiallyObservableGameState;
import rts.PhysicalGameState;
import rts.PlayerAction;
import rts.units.UnitTypeTable;

class RemoteGame
extends Thread {
    private Socket socket;
    private UnitTypeTable unitTypeTable;
    private PhysicalGameState pgs;
    private GameState gameState;
    private GameSettings gameSettings;
    private boolean gameOver = false;
    private static int PERIOD = 20;

    RemoteGame(Socket socket, GameSettings gameSettings) {
        this.socket = socket;
        this.gameSettings = gameSettings;
        this.unitTypeTable = new UnitTypeTable(gameSettings.getUTTVersion(), gameSettings.getConflictPolicy());
        try {
            this.pgs = PhysicalGameState.load(gameSettings.getMapLocation(), this.unitTypeTable);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.gameState = new GameState(this.pgs, this.unitTypeTable);
    }

    @Override
    public void run() {
        try {
            SocketAI socketAI = SocketAI.createFromExistingSocket(100, 0, this.unitTypeTable, this.gameSettings.getSerializationType(), this.socket);
            RandomBiasedAI randomBiasedAI = new RandomBiasedAI();
            ((AI)socketAI).reset();
            ((AI)randomBiasedAI).reset();
            PhysicalGameStateJFrame physicalGameStateJFrame = PhysicalGameStatePanel.newVisualizer(this.gameState, 640, 640, false, PhysicalGameStatePanel.COLORSCHEME_BLACK);
            long l = System.currentTimeMillis() + (long)PERIOD;
            do {
                if (System.currentTimeMillis() >= l) {
                    GameState gameState = this.gameSettings.isPartiallyObservable() ? new PartiallyObservableGameState(this.gameState, 0) : this.gameState;
                    GameState gameState2 = this.gameSettings.isPartiallyObservable() ? new PartiallyObservableGameState(this.gameState, 1) : this.gameState;
                    PlayerAction playerAction = ((AI)socketAI).getAction(0, gameState);
                    PlayerAction playerAction2 = ((AI)randomBiasedAI).getAction(1, gameState2);
                    this.gameState.issueSafe(playerAction);
                    this.gameState.issueSafe(playerAction2);
                    this.gameOver = this.gameState.cycle();
                    physicalGameStateJFrame.repaint();
                    l += (long)PERIOD;
                    continue;
                }
                try {
                    Thread.sleep(1L);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } while (!this.gameOver && this.gameState.getTime() < this.gameSettings.getMaxCycles());
            ((AI)socketAI).gameOver(this.gameState.winner());
            randomBiasedAI.gameOver(this.gameState.winner());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

