/*
 * Decompiled with CFR 0.152.
 */
package rts;

import java.util.LinkedList;
import java.util.List;
import rts.GameState;

public class ResourceUsage {
    List<Integer> positionsUsed = new LinkedList<Integer>();
    int[] resourcesUsed = new int[2];

    public boolean consistentWith(ResourceUsage resourceUsage, GameState gameState) {
        for (Integer n : resourceUsage.positionsUsed) {
            if (!this.positionsUsed.contains(n)) continue;
            return false;
        }
        for (int j = 0; j < this.resourcesUsed.length; ++j) {
            if (resourceUsage.resourcesUsed[j] == 0 || this.resourcesUsed[j] + resourceUsage.resourcesUsed[j] <= 0 || this.resourcesUsed[j] + resourceUsage.resourcesUsed[j] <= gameState.getPlayer(j).getResources()) continue;
            return false;
        }
        return true;
    }

    public List<Integer> getPositionsUsed() {
        return this.positionsUsed;
    }

    public int getResourcesUsed(int n) {
        return this.resourcesUsed[n];
    }

    public ResourceUsage mergeIntoNew(ResourceUsage resourceUsage) {
        ResourceUsage resourceUsage2 = new ResourceUsage();
        resourceUsage2.positionsUsed.addAll(this.positionsUsed);
        resourceUsage2.positionsUsed.addAll(resourceUsage.positionsUsed);
        for (int j = 0; j < this.resourcesUsed.length; ++j) {
            resourceUsage2.resourcesUsed[j] = this.resourcesUsed[j] + resourceUsage.resourcesUsed[j];
        }
        return resourceUsage2;
    }

    public void merge(ResourceUsage resourceUsage) {
        this.positionsUsed.addAll(resourceUsage.positionsUsed);
        for (int j = 0; j < this.resourcesUsed.length; ++j) {
            int n = j;
            this.resourcesUsed[n] = this.resourcesUsed[n] + resourceUsage.resourcesUsed[j];
        }
    }

    public ResourceUsage clone() {
        ResourceUsage resourceUsage = new ResourceUsage();
        resourceUsage.positionsUsed.addAll(this.positionsUsed);
        resourceUsage.resourcesUsed[0] = this.resourcesUsed[0];
        resourceUsage.resourcesUsed[1] = this.resourcesUsed[1];
        return resourceUsage;
    }

    public String toString() {
        return "ResourceUsage: " + this.resourcesUsed[0] + "," + this.resourcesUsed[1] + " positions: " + this.positionsUsed;
    }
}

