/*
 * Decompiled with CFR 0.152.
 */
package rts;

import java.util.LinkedList;
import java.util.List;
import org.jdom.Element;
import rts.GameState;
import rts.PlayerAction;
import rts.TraceEntry;
import rts.UnitAction;
import rts.units.Unit;
import rts.units.UnitTypeTable;
import util.Pair;
import util.XMLWriter;

public class Trace {
    UnitTypeTable utt = null;
    List<TraceEntry> entries = new LinkedList<TraceEntry>();
    GameState getGameStateAtCycle_cache = null;

    public Trace(UnitTypeTable unitTypeTable) {
        this.utt = unitTypeTable;
    }

    public List<TraceEntry> getEntries() {
        return this.entries;
    }

    public UnitTypeTable getUnitTypeTable() {
        return this.utt;
    }

    public int getLength() {
        return this.entries.get(this.entries.size() - 1).getTime();
    }

    public int winner() {
        if (this.entries.isEmpty()) {
            return -1;
        }
        return this.entries.get((int)(this.entries.size() - 1)).pgs.winner();
    }

    public void addEntry(TraceEntry traceEntry) {
        this.entries.add(traceEntry);
    }

    public void toxml(XMLWriter xMLWriter) {
        xMLWriter.tag(this.getClass().getName());
        this.utt.toxml(xMLWriter);
        xMLWriter.tag("entries");
        for (TraceEntry traceEntry : this.entries) {
            traceEntry.toxml(xMLWriter);
        }
        xMLWriter.tag("/entries");
        xMLWriter.tag("/" + this.getClass().getName());
    }

    public Trace(Element element) throws Exception {
        this.utt = UnitTypeTable.fromXML(element.getChild(UnitTypeTable.class.getName()));
        Element element2 = element.getChild("entries");
        for (Object e : element2.getChildren()) {
            Element element3 = (Element)e;
            this.entries.add(new TraceEntry(element3, this.utt));
        }
    }

    public Trace(Element element, UnitTypeTable unitTypeTable) throws Exception {
        this.utt = unitTypeTable;
        Element element2 = element.getChild("entries");
        for (Object e : element2.getChildren()) {
            Element element3 = (Element)e;
            this.entries.add(new TraceEntry(element3, this.utt));
        }
    }

    public GameState getGameStateAtCycle(int n) {
        GameState gameState = null;
        for (TraceEntry traceEntry : this.getEntries()) {
            if (gameState == null) {
                if (this.getGameStateAtCycle_cache != null && n >= this.getGameStateAtCycle_cache.getTime()) {
                    if (traceEntry.getTime() < this.getGameStateAtCycle_cache.getTime()) continue;
                    gameState = this.getGameStateAtCycle_cache.clone();
                } else {
                    gameState = new GameState(traceEntry.getPhysicalGameState().clone(), this.utt);
                }
            }
            while (gameState.getTime() < traceEntry.getTime() && gameState.getTime() < n) {
                gameState.cycle();
            }
            for (Unit unit : gameState.getUnits()) {
                for (Unit unit2 : traceEntry.getPhysicalGameState().getUnits()) {
                    if (unit.getX() != unit2.getX() || unit.getY() != unit2.getY() || unit.getType() != unit2.getType() || unit.getID() == unit2.getID()) continue;
                    unit.setID(unit2.getID());
                }
            }
            if (gameState.getTime() == n) {
                this.getGameStateAtCycle_cache = gameState;
                return gameState;
            }
            PlayerAction playerAction = new PlayerAction();
            PlayerAction object2 = new PlayerAction();
            for (Pair pair : traceEntry.getActions()) {
                if (pair.m_a != null) {
                    if (((Unit)pair.m_a).getPlayer() == 0) {
                        playerAction.addUnitAction((Unit)pair.m_a, (UnitAction)pair.m_b);
                    }
                    if (((Unit)pair.m_a).getPlayer() != 1) continue;
                    object2.addUnitAction((Unit)pair.m_a, (UnitAction)pair.m_b);
                    continue;
                }
                System.err.println("TraceEntry at time " + traceEntry.getTime() + " has actions for undefined units! This will probably cause errors down the line...");
            }
            gameState.issueSafe(playerAction);
            gameState.issueSafe(object2);
            if (gameState.getTime() != n) continue;
            this.getGameStateAtCycle_cache = gameState;
            return gameState;
        }
        while (gameState.getTime() < n) {
            gameState.cycle();
        }
        this.getGameStateAtCycle_cache = gameState;
        return gameState;
    }
}

