/*
 * Decompiled with CFR 0.152.
 */
package rts;

import java.util.LinkedList;
import java.util.List;
import org.jdom.Element;
import rts.PhysicalGameState;
import rts.PlayerAction;
import rts.UnitAction;
import rts.units.Unit;
import rts.units.UnitTypeTable;
import util.Pair;
import util.XMLWriter;

public class TraceEntry {
    int time;
    PhysicalGameState pgs = null;
    List<Pair<Unit, UnitAction>> actions = new LinkedList<Pair<Unit, UnitAction>>();

    public TraceEntry(PhysicalGameState physicalGameState, int n) {
        this.pgs = physicalGameState;
        this.time = n;
    }

    public void addUnitAction(Unit unit, UnitAction unitAction) {
        this.actions.add(new Pair<Unit, UnitAction>(unit, unitAction));
    }

    public void addPlayerAction(PlayerAction playerAction) {
        for (Pair<Unit, UnitAction> pair : playerAction.actions) {
            if (this.pgs.getUnit(((Unit)pair.m_a).getID()) == null) {
                boolean bl = false;
                for (Unit unit : this.pgs.units) {
                    if (unit.getClass() != ((Unit)pair.m_a).getClass() || unit.getX() != ((Unit)pair.m_a).getX() || unit.getY() != ((Unit)pair.m_a).getY()) continue;
                    pair.m_a = unit;
                    bl = true;
                    break;
                }
                if (!bl) {
                    System.err.println("Inconsistent order: " + playerAction);
                    System.err.println(this);
                    System.err.println("The problem was with unit " + pair.m_a);
                }
            }
            this.actions.add(pair);
        }
    }

    public PhysicalGameState getPhysicalGameState() {
        return this.pgs;
    }

    public List<Pair<Unit, UnitAction>> getActions() {
        return this.actions;
    }

    public int getTime() {
        return this.time;
    }

    public void toxml(XMLWriter xMLWriter) {
        xMLWriter.tagWithAttributes(this.getClass().getName(), "time = \"" + this.time + "\"");
        this.pgs.toxml(xMLWriter);
        xMLWriter.tag("actions");
        for (Pair<Unit, UnitAction> pair : this.actions) {
            xMLWriter.tagWithAttributes("action", "unitID=\"" + ((Unit)pair.m_a).getID() + "\"");
            ((UnitAction)pair.m_b).toxml(xMLWriter);
            xMLWriter.tag("/action");
        }
        xMLWriter.tag("/actions");
        xMLWriter.tag("/" + this.getClass().getName());
    }

    public TraceEntry(Element element, UnitTypeTable unitTypeTable) throws Exception {
        Element element2 = element.getChild("actions");
        this.time = Integer.parseInt(element.getAttributeValue("time"));
        Element element3 = element.getChild(PhysicalGameState.class.getName());
        this.pgs = PhysicalGameState.fromXML(element3, unitTypeTable);
        for (Object e : element2.getChildren()) {
            Element element4 = (Element)e;
            long l = Long.parseLong(element4.getAttributeValue("unitID"));
            UnitAction unitAction = new UnitAction(element4.getChild("UnitAction"), unitTypeTable);
            Unit unit = this.pgs.getUnit(l);
            if (unit == null) {
                System.err.println("Undefined unit ID " + l + " in action " + unitAction + " at time " + this.time);
            }
            this.actions.add(new Pair<Unit, UnitAction>(unit, unitAction));
        }
    }
}

