/*
 * Decompiled with CFR 0.152.
 */
package rts;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import org.jdom.Element;
import rts.GameState;
import rts.PhysicalGameState;
import rts.Player;
import rts.ResourceUsage;
import rts.VariableSpec;
import rts.units.Unit;
import rts.units.UnitType;
import rts.units.UnitTypeTable;
import util.XMLWriter;

public class UnitAction {
    public static Random r = new Random();
    public static final int TYPE_NONE = 0;
    public static final int TYPE_MOVE = 1;
    public static final int TYPE_HARVEST = 2;
    public static final int TYPE_RETURN = 3;
    public static final int TYPE_PRODUCE = 4;
    public static final int TYPE_ATTACK_LOCATION = 5;
    public static final int NUMBER_OF_ACTION_TYPES = 6;
    public static String[] actionName = new String[]{"wait", "move", "harvest", "return", "produce", "attack_location"};
    public static final int DIRECTION_NONE = -1;
    public static final int DIRECTION_UP = 0;
    public static final int DIRECTION_RIGHT = 1;
    public static final int DIRECTION_DOWN = 2;
    public static final int DIRECTION_LEFT = 3;
    public static final int[] DIRECTION_OFFSET_X = new int[]{0, 1, 0, -1};
    public static final int[] DIRECTION_OFFSET_Y = new int[]{-1, 0, 1, 0};
    public static final String[] DIRECTION_NAMES = new String[]{"up", "right", "down", "left"};
    public static final String PARAMETER_DIRECTION = "direction";
    public static final Map<Integer, Object> UnitActionSpec;
    int type = 0;
    int parameter = -1;
    int x = 0;
    int y = 0;
    UnitType unitType = null;
    ResourceUsage r_cache = null;

    public UnitAction(int n) {
        this.type = n;
    }

    public UnitAction(int n, int n2) {
        this.type = n;
        this.parameter = n2;
    }

    public UnitAction(int n, int n2, UnitType unitType) {
        this.type = n;
        this.parameter = n2;
        this.unitType = unitType;
    }

    public UnitAction(int n, int n2, int n3) {
        this.type = n;
        this.x = n2;
        this.y = n3;
    }

    public UnitAction(UnitAction unitAction) {
        this.type = unitAction.type;
        this.parameter = unitAction.parameter;
        this.x = unitAction.x;
        this.y = unitAction.y;
        this.unitType = unitAction.unitType;
    }

    public boolean equals(Object object) {
        if (!(object instanceof UnitAction)) {
            return false;
        }
        UnitAction unitAction = (UnitAction)object;
        if (unitAction.type != this.type) {
            return false;
        }
        return !(this.type == 0 || this.type == 1 || this.type == 2 || this.type == 3 ? unitAction.parameter != this.parameter : (this.type == 5 ? unitAction.x != this.x || unitAction.y != this.y : unitAction.parameter != this.parameter || unitAction.unitType != this.unitType));
    }

    public int hashCode() {
        int n = this.type;
        n = 19 * n + this.parameter;
        n = 19 * n + this.x;
        n = 19 * n + this.y;
        n = 19 * n + Objects.hashCode(this.unitType);
        return n;
    }

    public int getType() {
        return this.type;
    }

    public UnitType getUnitType() {
        return this.unitType;
    }

    public ResourceUsage resourceUsage(Unit unit, PhysicalGameState physicalGameState) {
        if (this.r_cache != null) {
            return this.r_cache;
        }
        this.r_cache = new ResourceUsage();
        switch (this.type) {
            case 1: {
                int n = unit.getX() + unit.getY() * physicalGameState.getWidth();
                switch (this.parameter) {
                    case 0: {
                        n -= physicalGameState.getWidth();
                        break;
                    }
                    case 1: {
                        ++n;
                        break;
                    }
                    case 2: {
                        n += physicalGameState.getWidth();
                        break;
                    }
                    case 3: {
                        --n;
                    }
                }
                this.r_cache.positionsUsed.add(n);
                break;
            }
            case 4: {
                int n = unit.getPlayer();
                this.r_cache.resourcesUsed[n] = this.r_cache.resourcesUsed[n] + this.unitType.cost;
                int n2 = unit.getX() + unit.getY() * physicalGameState.getWidth();
                switch (this.parameter) {
                    case 0: {
                        n2 -= physicalGameState.getWidth();
                        break;
                    }
                    case 1: {
                        ++n2;
                        break;
                    }
                    case 2: {
                        n2 += physicalGameState.getWidth();
                        break;
                    }
                    case 3: {
                        --n2;
                    }
                }
                this.r_cache.positionsUsed.add(n2);
            }
        }
        return this.r_cache;
    }

    public int ETA(Unit unit) {
        switch (this.type) {
            case 0: {
                return this.parameter;
            }
            case 1: {
                return unit.getMoveTime();
            }
            case 5: {
                return unit.getAttackTime();
            }
            case 2: {
                return unit.getHarvestTime();
            }
            case 3: {
                return unit.getMoveTime();
            }
            case 4: {
                return this.unitType.produceTime;
            }
        }
        return 0;
    }

    public void execute(Unit unit, GameState gameState) {
        PhysicalGameState physicalGameState = gameState.getPhysicalGameState();
        switch (this.type) {
            case 0: {
                break;
            }
            case 1: {
                switch (this.parameter) {
                    case 0: {
                        unit.setY(unit.getY() - 1);
                        break;
                    }
                    case 1: {
                        unit.setX(unit.getX() + 1);
                        break;
                    }
                    case 2: {
                        unit.setY(unit.getY() + 1);
                        break;
                    }
                    case 3: {
                        unit.setX(unit.getX() - 1);
                    }
                }
                break;
            }
            case 5: {
                Unit unit2 = physicalGameState.getUnitAt(this.x, this.y);
                if (unit2 == null) break;
                int n = unit.getMinDamage() == unit.getMaxDamage() ? unit.getMinDamage() : unit.getMinDamage() + r.nextInt(1 + (unit.getMaxDamage() - unit.getMinDamage()));
                unit2.setHitPoints(unit2.getHitPoints() - n);
                if (unit2.getHitPoints() > 0) break;
                gameState.removeUnit(unit2);
                break;
            }
            case 2: {
                Unit unit3 = null;
                switch (this.parameter) {
                    case 0: {
                        unit3 = physicalGameState.getUnitAt(unit.getX(), unit.getY() - 1);
                        break;
                    }
                    case 1: {
                        unit3 = physicalGameState.getUnitAt(unit.getX() + 1, unit.getY());
                        break;
                    }
                    case 2: {
                        unit3 = physicalGameState.getUnitAt(unit.getX(), unit.getY() + 1);
                        break;
                    }
                    case 3: {
                        unit3 = physicalGameState.getUnitAt(unit.getX() - 1, unit.getY());
                    }
                }
                if (unit3 == null || !unit.getType().canHarvest || unit.getResources() != 0) break;
                unit3.setResources(unit3.getResources() - unit.getHarvestAmount());
                if (unit3.getResources() <= 0) {
                    gameState.removeUnit(unit3);
                }
                unit.setResources(unit.getHarvestAmount());
                break;
            }
            case 3: {
                Unit unit4 = null;
                switch (this.parameter) {
                    case 0: {
                        unit4 = physicalGameState.getUnitAt(unit.getX(), unit.getY() - 1);
                        break;
                    }
                    case 1: {
                        unit4 = physicalGameState.getUnitAt(unit.getX() + 1, unit.getY());
                        break;
                    }
                    case 2: {
                        unit4 = physicalGameState.getUnitAt(unit.getX(), unit.getY() + 1);
                        break;
                    }
                    case 3: {
                        unit4 = physicalGameState.getUnitAt(unit.getX() - 1, unit.getY());
                    }
                }
                if (unit4 == null || !unit4.getType().isStockpile || unit.getResources() <= 0) break;
                Player player = physicalGameState.getPlayer(unit.getPlayer());
                player.setResources(player.getResources() + unit.getResources());
                unit.setResources(0);
                break;
            }
            case 4: {
                Unit unit5 = null;
                int n = unit.getX();
                int n2 = unit.getY();
                switch (this.parameter) {
                    case 0: {
                        --n2;
                        break;
                    }
                    case 1: {
                        ++n;
                        break;
                    }
                    case 2: {
                        ++n2;
                        break;
                    }
                    case 3: {
                        --n;
                    }
                }
                unit5 = new Unit(unit.getPlayer(), this.unitType, n, n2, 0);
                physicalGameState.addUnit(unit5);
                Player player = physicalGameState.getPlayer(unit.getPlayer());
                player.setResources(player.getResources() - unit5.getCost());
                if (player.getResources() >= 0) break;
                System.err.print("Illegal action executed! resources of player " + player.ID + " are now " + player.getResources() + "\n");
                System.err.print(gameState);
            }
        }
    }

    public String toString() {
        String string = actionName[this.type] + "(";
        if (this.type == 5) {
            string = string + this.x + "," + this.y;
        } else if (this.type == 0) {
            string = string + this.parameter;
        } else {
            if (this.parameter != -1) {
                if (this.parameter == 0) {
                    string = string + "up";
                }
                if (this.parameter == 1) {
                    string = string + "right";
                }
                if (this.parameter == 2) {
                    string = string + "down";
                }
                if (this.parameter == 3) {
                    string = string + "left";
                }
            }
            if (this.parameter != -1 && this.unitType != null) {
                string = string + ",";
            }
            if (this.unitType != null) {
                string = string + this.unitType.name;
            }
        }
        return string + ")";
    }

    public static int[] getValidActionArray(List<UnitAction> list, GameState gameState, UnitTypeTable unitTypeTable) {
        int[] nArray = new int[22 + unitTypeTable.getUnitTypes().size() + gameState.pgs.width * gameState.pgs.height];
        for (UnitAction unitAction : list) {
            nArray[unitAction.type] = 1;
            switch (unitAction.type) {
                case 0: {
                    break;
                }
                case 1: {
                    nArray[6 + unitAction.parameter] = 1;
                    break;
                }
                case 2: {
                    nArray[10 + unitAction.parameter] = 1;
                    break;
                }
                case 3: {
                    nArray[14 + unitAction.parameter] = 1;
                    break;
                }
                case 4: {
                    nArray[18 + unitAction.parameter] = 1;
                    nArray[22 + unitAction.unitType.ID] = 1;
                    break;
                }
                case 5: {
                    nArray[22 + unitTypeTable.getUnitTypes().size() + unitAction.y * gameState.pgs.width + unitAction.x] = 1;
                }
            }
        }
        return nArray;
    }

    public String getActionName() {
        return actionName[this.type];
    }

    public int getDirection() {
        return this.parameter;
    }

    public int getLocationX() {
        return this.x;
    }

    public int getLocationY() {
        return this.y;
    }

    public void toxml(XMLWriter xMLWriter) {
        String string = "type=\"" + this.type + "\" ";
        if (this.type == 5) {
            string = string + "x=\"" + this.x + "\" y=\"" + this.y + "\"";
        } else {
            if (this.parameter != -1) {
                string = string + "parameter=\"" + this.parameter + "\"";
                if (this.unitType != null) {
                    string = string + " ";
                }
            }
            if (this.unitType != null) {
                string = string + "unitType=\"" + this.unitType.name + "\"";
            }
        }
        xMLWriter.tagWithAttributes("UnitAction", string);
        xMLWriter.tag("/UnitAction");
    }

    public void toJSON(Writer writer) throws Exception {
        String string = "\"type\":" + this.type + "";
        if (this.type == 5) {
            string = string + ", \"x\":" + this.x + ",\"y\":" + this.y;
        } else {
            if (this.parameter != -1) {
                string = string + ", \"parameter\":" + this.parameter;
            }
            if (this.unitType != null) {
                string = string + ", \"unitType\":\"" + this.unitType.name + "\"";
            }
        }
        writer.write("{" + string + "}");
    }

    public UnitAction(Element element, UnitTypeTable unitTypeTable) {
        String string = element.getAttributeValue("type");
        String string2 = element.getAttributeValue("parameter");
        String string3 = element.getAttributeValue("x");
        String string4 = element.getAttributeValue("y");
        String string5 = element.getAttributeValue("unitType");
        this.type = Integer.parseInt(string);
        if (string2 != null) {
            this.parameter = Integer.parseInt(string2);
        }
        if (string3 != null) {
            this.x = Integer.parseInt(string3);
        }
        if (string4 != null) {
            this.y = Integer.parseInt(string4);
        }
        if (string5 != null) {
            this.unitType = unitTypeTable.getUnitType(string5);
        }
    }

    public void clearResourceUSageCache() {
        this.r_cache = null;
    }

    public static UnitAction fromXML(Element element, UnitTypeTable unitTypeTable) {
        return new UnitAction(element, unitTypeTable);
    }

    public static UnitAction fromJSON(String string, UnitTypeTable unitTypeTable) {
        JsonObject jsonObject = Json.parse(string).asObject();
        return UnitAction.fromJSON(jsonObject, unitTypeTable);
    }

    public static UnitAction fromJSON(JsonObject jsonObject, UnitTypeTable unitTypeTable) {
        UnitAction unitAction = new UnitAction(jsonObject.getInt("type", 0));
        unitAction.parameter = jsonObject.getInt("parameter", -1);
        unitAction.x = jsonObject.getInt("x", -1);
        unitAction.y = jsonObject.getInt("y", -1);
        String string = jsonObject.getString("unitType", null);
        if (string != null) {
            unitAction.unitType = unitTypeTable.getUnitType(string);
        }
        return unitAction;
    }

    public static UnitAction fromActionArray(int[] nArray, UnitTypeTable unitTypeTable, GameState gameState) {
        int n = nArray[1];
        UnitAction unitAction = new UnitAction(n);
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                unitAction.parameter = nArray[2];
                break;
            }
            case 2: {
                unitAction.parameter = nArray[3];
                break;
            }
            case 3: {
                unitAction.parameter = nArray[4];
                break;
            }
            case 4: {
                unitAction.parameter = nArray[5];
                unitAction.unitType = unitTypeTable.getUnitType(nArray[6]);
            }
            case 5: {
                unitAction.x = nArray[7] % gameState.pgs.width;
                unitAction.y = nArray[7] / gameState.pgs.width;
            }
        }
        return unitAction;
    }

    public static UnitAction fromActionArrayForUnit(int[] nArray, UnitTypeTable unitTypeTable, GameState gameState, Unit unit) {
        int n = nArray[0];
        UnitAction unitAction = new UnitAction(n);
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                unitAction.parameter = nArray[1];
                break;
            }
            case 2: {
                unitAction.parameter = nArray[2];
                break;
            }
            case 3: {
                unitAction.parameter = nArray[3];
                break;
            }
            case 4: {
                unitAction.parameter = nArray[4];
                unitAction.unitType = unitTypeTable.getUnitType(nArray[5]);
            }
            case 5: {
                int n2 = nArray[6] % gameState.pgs.width;
                int n3 = nArray[6] / gameState.pgs.width;
                int n4 = unit.getX() + n2;
                if (n4 < 0) {
                    n4 = 0;
                } else if (n4 > gameState.pgs.width) {
                    n4 = gameState.pgs.width;
                }
                int n5 = unit.getY() + n3;
                if (n5 < 0) {
                    n5 = 0;
                } else if (n5 > gameState.pgs.height) {
                    n5 = gameState.pgs.height;
                }
                unitAction.x = n4;
                unitAction.y = n5;
                break;
            }
        }
        return unitAction;
    }

    public static UnitAction fromActionArray(JsonArray jsonArray, UnitTypeTable unitTypeTable) {
        int n = jsonArray.get(2).asInt();
        UnitAction unitAction = new UnitAction(n);
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                unitAction.parameter = jsonArray.get(3).asInt();
                break;
            }
            case 2: {
                unitAction.parameter = jsonArray.get(4).asInt();
                break;
            }
            case 3: {
                unitAction.parameter = jsonArray.get(5).asInt();
                break;
            }
            case 4: {
                unitAction.parameter = jsonArray.get(6).asInt();
                unitAction.unitType = unitTypeTable.getUnitType(jsonArray.get(7).asInt());
            }
            case 5: {
                unitAction.x = jsonArray.get(8).asInt();
                unitAction.y = jsonArray.get(9).asInt();
            }
        }
        return unitAction;
    }

    public static UnitAction fromActionArrayForUnit(JsonArray jsonArray, UnitTypeTable unitTypeTable, GameState gameState, Unit unit) {
        int n = jsonArray.get(0).asInt();
        UnitAction unitAction = new UnitAction(n);
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                unitAction.parameter = jsonArray.get(1).asInt();
                break;
            }
            case 2: {
                unitAction.parameter = jsonArray.get(2).asInt();
                break;
            }
            case 3: {
                unitAction.parameter = jsonArray.get(3).asInt();
                break;
            }
            case 4: {
                unitAction.parameter = jsonArray.get(4).asInt();
                unitAction.unitType = unitTypeTable.getUnitType(jsonArray.get(5).asInt());
            }
            case 5: {
                int n2 = jsonArray.get(6).asInt() - 1;
                int n3 = jsonArray.get(7).asInt() - 1;
                int n4 = unit.getX() + n2;
                if (n4 < 0) {
                    n4 = 0;
                } else if (n4 > gameState.pgs.height) {
                    n4 = gameState.pgs.height;
                }
                int n5 = unit.getY() + n3;
                if (n5 < 0) {
                    n5 = 0;
                } else if (n5 > gameState.pgs.width) {
                    n5 = gameState.pgs.width;
                }
                unitAction.x = n4;
                unitAction.y = n5;
                break;
            }
        }
        return unitAction;
    }

    static {
        HashMap<Integer, VariableSpec[]> hashMap = new HashMap<Integer, VariableSpec[]>();
        hashMap.put(0, new VariableSpec[0]);
        hashMap.put(1, new VariableSpec[]{new VariableSpec(PARAMETER_DIRECTION, 0, DIRECTION_NAMES.length)});
        hashMap.put(2, new VariableSpec[]{new VariableSpec(PARAMETER_DIRECTION, 0, DIRECTION_NAMES.length)});
        hashMap.put(3, new VariableSpec[]{new VariableSpec(PARAMETER_DIRECTION, 0, DIRECTION_NAMES.length)});
        UnitActionSpec = Collections.unmodifiableMap(hashMap);
    }
}

