/*
 * Decompiled with CFR 0.152.
 */
package rts.units;

import com.eclipsesource.json.JsonObject;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import rts.GameState;
import rts.PhysicalGameState;
import rts.Player;
import rts.UnitAction;
import rts.units.UnitType;
import rts.units.UnitTypeTable;
import util.XMLWriter;

public class Unit
implements Serializable {
    UnitType type;
    public static long next_ID = 0L;
    long ID;
    int player;
    int x;
    int y;
    int resources;
    int hitpoints = 0;

    public Unit(long l, int n, UnitType unitType, int n2, int n3, int n4) {
        this.player = n;
        this.type = unitType;
        this.x = n2;
        this.y = n3;
        this.resources = n4;
        this.hitpoints = unitType.hp;
        this.ID = l;
        if (this.ID >= next_ID) {
            next_ID = this.ID + 1L;
        }
    }

    public Unit(int n, UnitType unitType, int n2, int n3, int n4) {
        this.player = n;
        this.type = unitType;
        this.x = n2;
        this.y = n3;
        this.resources = n4;
        this.hitpoints = unitType.hp;
        this.ID = next_ID++;
    }

    public Unit(int n, UnitType unitType, int n2, int n3) {
        this.player = n;
        this.type = unitType;
        this.x = n2;
        this.y = n3;
        this.resources = 0;
        this.hitpoints = unitType.hp;
        this.ID = next_ID++;
    }

    public Unit(Unit unit) {
        this.player = unit.player;
        this.type = unit.type;
        this.x = unit.x;
        this.y = unit.y;
        this.resources = unit.resources;
        this.hitpoints = unit.hitpoints;
        this.ID = unit.ID;
    }

    public int getPlayer() {
        return this.player;
    }

    public UnitType getType() {
        return this.type;
    }

    public void setType(UnitType unitType) {
        this.type = unitType;
    }

    public long getID() {
        return this.ID;
    }

    public void setID(long l) {
        this.ID = l;
    }

    public int getPosition(PhysicalGameState physicalGameState) {
        return this.x + physicalGameState.getWidth() * this.y;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void setX(int n) {
        this.x = n;
    }

    public void setY(int n) {
        this.y = n;
    }

    public int getResources() {
        return this.resources;
    }

    public void setResources(int n) {
        this.resources = n;
    }

    public int getHitPoints() {
        return this.hitpoints;
    }

    public int getMaxHitPoints() {
        return this.type.hp;
    }

    public void setHitPoints(int n) {
        this.hitpoints = n;
    }

    public int getCost() {
        return this.type.cost;
    }

    public int getMoveTime() {
        return this.type.moveTime;
    }

    public int getAttackTime() {
        return this.type.attackTime;
    }

    public int getHarvestTime() {
        return this.type.harvestTime;
    }

    public int getAttackRange() {
        return this.type.attackRange;
    }

    public int getMinDamage() {
        return this.type.minDamage;
    }

    public int getMaxDamage() {
        return this.type.maxDamage;
    }

    public int getHarvestAmount() {
        return this.type.harvestAmount;
    }

    public List<UnitAction> getUnitActions(GameState gameState) {
        return this.getUnitActions(gameState, 10);
    }

    public List<UnitAction> getUnitActions(GameState gameState, int n) {
        int n2;
        int n3;
        ArrayList<UnitAction> arrayList = new ArrayList<UnitAction>();
        PhysicalGameState physicalGameState = gameState.getPhysicalGameState();
        Player player = physicalGameState.getPlayer(this.player);
        Unit unit = null;
        Unit iterator = null;
        Unit iterator2 = null;
        Unit iterator3 = null;
        for (Unit iterator4 : physicalGameState.getUnits()) {
            if (iterator4.x == this.x) {
                if (iterator4.y == this.y - 1) {
                    unit = iterator4;
                    continue;
                }
                if (iterator4.y != this.y + 1) continue;
                iterator2 = iterator4;
                continue;
            }
            if (iterator4.y != this.y) continue;
            if (iterator4.x == this.x - 1) {
                iterator3 = iterator4;
                continue;
            }
            if (iterator4.x != this.x + 1) continue;
            iterator = iterator4;
        }
        if (this.type.canAttack) {
            if (this.type.attackRange == 1) {
                if (this.y > 0 && unit != null && unit.player != this.player && unit.player >= 0) {
                    arrayList.add(new UnitAction(5, unit.x, unit.y));
                }
                if (this.x < physicalGameState.getWidth() - 1 && iterator != null && iterator.player != this.player && iterator.player >= 0) {
                    arrayList.add(new UnitAction(5, iterator.x, iterator.y));
                }
                if (this.y < physicalGameState.getHeight() - 1 && iterator2 != null && iterator2.player != this.player && iterator2.player >= 0) {
                    arrayList.add(new UnitAction(5, iterator2.x, iterator2.y));
                }
                if (this.x > 0 && iterator3 != null && iterator3.player != this.player && iterator3.player >= 0) {
                    arrayList.add(new UnitAction(5, iterator3.x, iterator3.y));
                }
            } else {
                int n4 = this.type.attackRange * this.type.attackRange;
                for (Unit unit2 : physicalGameState.getUnits()) {
                    if (unit2.player < 0 || unit2.player == this.player || (n3 = (unit2.x - this.x) * (unit2.x - this.x)) + (n2 = (unit2.y - this.y) * (unit2.y - this.y)) > n4) continue;
                    arrayList.add(new UnitAction(5, unit2.x, unit2.y));
                }
            }
        }
        if (this.type.canHarvest) {
            if (this.resources == 0) {
                if (this.y > 0 && unit != null && unit.type.isResource) {
                    arrayList.add(new UnitAction(2, 0));
                }
                if (this.x < physicalGameState.getWidth() - 1 && iterator != null && iterator.type.isResource) {
                    arrayList.add(new UnitAction(2, 1));
                }
                if (this.y < physicalGameState.getHeight() - 1 && iterator2 != null && iterator2.type.isResource) {
                    arrayList.add(new UnitAction(2, 2));
                }
                if (this.x > 0 && iterator3 != null && iterator3.type.isResource) {
                    arrayList.add(new UnitAction(2, 3));
                }
            }
            if (this.resources > 0) {
                if (this.y > 0 && unit != null && unit.type.isStockpile && unit.player == this.player) {
                    arrayList.add(new UnitAction(3, 0));
                }
                if (this.x < physicalGameState.getWidth() - 1 && iterator != null && iterator.type.isStockpile && iterator.player == this.player) {
                    arrayList.add(new UnitAction(3, 1));
                }
                if (this.y < physicalGameState.getHeight() - 1 && iterator2 != null && iterator2.type.isStockpile && iterator2.player == this.player) {
                    arrayList.add(new UnitAction(3, 2));
                }
                if (this.x > 0 && iterator3 != null && iterator3.type.isStockpile && iterator3.player == this.player) {
                    arrayList.add(new UnitAction(3, 3));
                }
            }
        }
        for (UnitType unitType : this.type.produces) {
            int n4;
            if (player.getResources() < unitType.cost) continue;
            int n5 = this.y > 0 ? physicalGameState.getTerrain(this.x, this.y - 1) : 1;
            n3 = this.x < physicalGameState.getWidth() - 1 ? physicalGameState.getTerrain(this.x + 1, this.y) : 1;
            n2 = this.y < physicalGameState.getHeight() - 1 ? physicalGameState.getTerrain(this.x, this.y + 1) : 1;
            int n6 = n4 = this.x > 0 ? physicalGameState.getTerrain(this.x - 1, this.y) : 1;
            if (n5 == 0 && physicalGameState.getUnitAt(this.x, this.y - 1) == null) {
                arrayList.add(new UnitAction(4, 0, unitType));
            }
            if (n3 == 0 && physicalGameState.getUnitAt(this.x + 1, this.y) == null) {
                arrayList.add(new UnitAction(4, 1, unitType));
            }
            if (n2 == 0 && physicalGameState.getUnitAt(this.x, this.y + 1) == null) {
                arrayList.add(new UnitAction(4, 2, unitType));
            }
            if (n4 != 0 || physicalGameState.getUnitAt(this.x - 1, this.y) != null) continue;
            arrayList.add(new UnitAction(4, 3, unitType));
        }
        if (this.type.canMove) {
            int n8 = this.y > 0 ? physicalGameState.getTerrain(this.x, this.y - 1) : 1;
            int n7 = this.x < physicalGameState.getWidth() - 1 ? physicalGameState.getTerrain(this.x + 1, this.y) : 1;
            int n9 = this.y < physicalGameState.getHeight() - 1 ? physicalGameState.getTerrain(this.x, this.y + 1) : 1;
            int n10 = n3 = this.x > 0 ? physicalGameState.getTerrain(this.x - 1, this.y) : 1;
            if (n8 == 0 && unit == null) {
                arrayList.add(new UnitAction(1, 0));
            }
            if (n7 == 0 && iterator == null) {
                arrayList.add(new UnitAction(1, 1));
            }
            if (n9 == 0 && iterator2 == null) {
                arrayList.add(new UnitAction(1, 2));
            }
            if (n3 == 0 && iterator3 == null) {
                arrayList.add(new UnitAction(1, 3));
            }
        }
        arrayList.add(new UnitAction(0, n));
        return arrayList;
    }

    public boolean canExecuteAction(UnitAction unitAction, GameState gameState) {
        List<UnitAction> list = this.getUnitActions(gameState, unitAction.ETA(this));
        return list.contains(unitAction);
    }

    public String toString() {
        return this.type.name + "(" + this.ID + ")(" + this.player + ", (" + this.x + "," + this.y + "), " + this.hitpoints + ", " + this.resources + ")";
    }

    public Unit clone() {
        return new Unit(this);
    }

    public int hashCode() {
        return (int)this.ID;
    }

    public void toxml(XMLWriter xMLWriter) {
        xMLWriter.tagWithAttributes(this.getClass().getName(), "type=\"" + this.type.name + "\" ID=\"" + this.ID + "\" player=\"" + this.player + "\" x=\"" + this.x + "\" y=\"" + this.y + "\" resources=\"" + this.resources + "\" hitpoints=\"" + this.hitpoints + "\" ");
        xMLWriter.tag("/" + this.getClass().getName());
    }

    public void toJSON(Writer writer) throws Exception {
        writer.write("{\"type\":\"" + this.type.name + "\", \"ID\":" + this.ID + ", \"player\":" + this.player + ", \"x\":" + this.x + ", \"y\":" + this.y + ", \"resources\":" + this.resources + ", \"hitpoints\":" + this.hitpoints + "}");
    }

    public static Unit fromXML(Element element, UnitTypeTable unitTypeTable) {
        String string = element.getAttributeValue("type");
        String string2 = element.getAttributeValue("ID");
        String string3 = element.getAttributeValue("player");
        String string4 = element.getAttributeValue("x");
        String string5 = element.getAttributeValue("y");
        String string6 = element.getAttributeValue("resources");
        String string7 = element.getAttributeValue("hitpoints");
        long l = Long.parseLong(string2);
        if (l >= next_ID) {
            next_ID = l + 1L;
        }
        UnitType unitType = unitTypeTable.getUnitType(string);
        int n = Integer.parseInt(string3);
        int n2 = Integer.parseInt(string4);
        int n3 = Integer.parseInt(string5);
        int n4 = Integer.parseInt(string6);
        int n5 = Integer.parseInt(string7);
        Unit unit = new Unit(l, n, unitType, n2, n3, n4);
        unit.hitpoints = n5;
        return unit;
    }

    public static Unit fromJSON(JsonObject jsonObject, UnitTypeTable unitTypeTable) {
        Unit unit = new Unit(jsonObject.getLong("ID", -1L), jsonObject.getInt("player", -1), unitTypeTable.getUnitType(jsonObject.getString("type", null)), jsonObject.getInt("x", 0), jsonObject.getInt("y", 0), jsonObject.getInt("resources", 0));
        unit.hitpoints = jsonObject.getInt("hitpoints", 1);
        return unit;
    }
}

