/*
 * Decompiled with CFR 0.152.
 */
package rts.units;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.io.Writer;
import java.util.ArrayList;
import org.jdom.Element;
import rts.units.UnitTypeTable;
import util.XMLWriter;

public class UnitType {
    public int ID = 0;
    public String name = null;
    public int cost = 1;
    public int hp = 1;
    public int minDamage = 1;
    public int maxDamage = 1;
    public int attackRange = 1;
    public int produceTime = 10;
    public int moveTime = 10;
    public int attackTime = 10;
    public int harvestTime = 10;
    public int returnTime = 10;
    public int harvestAmount = 1;
    public int sightRadius = 4;
    public boolean isResource = false;
    public boolean isStockpile = false;
    public boolean canHarvest = false;
    public boolean canMove = true;
    public boolean canAttack = true;
    public ArrayList<UnitType> produces = new ArrayList();
    public ArrayList<UnitType> producedBy = new ArrayList();

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof UnitType)) {
            return false;
        }
        return this.name.equals(((UnitType)object).name);
    }

    public void produces(UnitType unitType) {
        this.produces.add(unitType);
        unitType.producedBy.add(this);
    }

    static UnitType createStub(Element element) {
        UnitType unitType = new UnitType();
        unitType.ID = Integer.parseInt(element.getAttributeValue("ID"));
        unitType.name = element.getAttributeValue("name");
        return unitType;
    }

    static UnitType createStub(JsonObject jsonObject) {
        UnitType unitType = new UnitType();
        unitType.ID = jsonObject.getInt("ID", -1);
        unitType.name = jsonObject.getString("name", null);
        return unitType;
    }

    void updateFromXML(Element element, UnitTypeTable unitTypeTable) {
        Element element2;
        this.cost = Integer.parseInt(element.getAttributeValue("cost"));
        this.hp = Integer.parseInt(element.getAttributeValue("hp"));
        this.minDamage = Integer.parseInt(element.getAttributeValue("minDamage"));
        this.maxDamage = Integer.parseInt(element.getAttributeValue("maxDamage"));
        this.attackRange = Integer.parseInt(element.getAttributeValue("attackRange"));
        this.produceTime = Integer.parseInt(element.getAttributeValue("produceTime"));
        this.moveTime = Integer.parseInt(element.getAttributeValue("moveTime"));
        this.attackTime = Integer.parseInt(element.getAttributeValue("attackTime"));
        this.harvestTime = Integer.parseInt(element.getAttributeValue("harvestTime"));
        this.returnTime = Integer.parseInt(element.getAttributeValue("returnTime"));
        this.harvestAmount = Integer.parseInt(element.getAttributeValue("harvestAmount"));
        this.sightRadius = Integer.parseInt(element.getAttributeValue("sightRadius"));
        this.isResource = Boolean.parseBoolean(element.getAttributeValue("isResource"));
        this.isStockpile = Boolean.parseBoolean(element.getAttributeValue("isStockpile"));
        this.canHarvest = Boolean.parseBoolean(element.getAttributeValue("canHarvest"));
        this.canMove = Boolean.parseBoolean(element.getAttributeValue("canMove"));
        this.canAttack = Boolean.parseBoolean(element.getAttributeValue("canAttack"));
        for (Object e : element.getChildren("produces")) {
            element2 = (Element)e;
            this.produces.add(unitTypeTable.getUnitType(element2.getAttributeValue("type")));
        }
        for (Object e : element.getChildren("producedBy")) {
            element2 = (Element)e;
            this.producedBy.add(unitTypeTable.getUnitType(element2.getAttributeValue("type")));
        }
    }

    void updateFromJSON(String string, UnitTypeTable unitTypeTable) {
        JsonObject jsonObject = Json.parse(string).asObject();
        this.updateFromJSON(jsonObject, unitTypeTable);
    }

    void updateFromJSON(JsonObject jsonObject, UnitTypeTable unitTypeTable) {
        this.cost = jsonObject.getInt("cost", 1);
        this.hp = jsonObject.getInt("hp", 1);
        this.minDamage = jsonObject.getInt("minDamage", 1);
        this.maxDamage = jsonObject.getInt("maxDamage", 1);
        this.attackRange = jsonObject.getInt("attackRange", 1);
        this.produceTime = jsonObject.getInt("produceTime", 10);
        this.moveTime = jsonObject.getInt("moveTime", 10);
        this.attackTime = jsonObject.getInt("attackTime", 10);
        this.harvestTime = jsonObject.getInt("produceTime", 10);
        this.produceTime = jsonObject.getInt("produceTime", 10);
        this.harvestAmount = jsonObject.getInt("harvestAmount", 10);
        this.sightRadius = jsonObject.getInt("sightRadius", 10);
        this.isResource = jsonObject.getBoolean("isResource", false);
        this.isStockpile = jsonObject.getBoolean("isStockpile", false);
        this.canHarvest = jsonObject.getBoolean("canHarvest", false);
        this.canMove = jsonObject.getBoolean("canMove", false);
        this.canAttack = jsonObject.getBoolean("canAttack", false);
        JsonArray jsonArray = jsonObject.get("produces").asArray();
        for (JsonValue object : jsonArray.values()) {
            this.produces.add(unitTypeTable.getUnitType(object.asString()));
        }
        JsonArray jsonArray2 = jsonObject.get("producedBy").asArray();
        for (JsonValue jsonValue : jsonArray2.values()) {
            this.producedBy.add(unitTypeTable.getUnitType(jsonValue.asString()));
        }
    }

    public void toxml(XMLWriter xMLWriter) {
        xMLWriter.tagWithAttributes(this.getClass().getName(), "ID=\"" + this.ID + "\" name=\"" + this.name + "\" cost=\"" + this.cost + "\" hp=\"" + this.hp + "\" minDamage=\"" + this.minDamage + "\" maxDamage=\"" + this.maxDamage + "\" attackRange=\"" + this.attackRange + "\" produceTime=\"" + this.produceTime + "\" moveTime=\"" + this.moveTime + "\" attackTime=\"" + this.attackTime + "\" harvestTime=\"" + this.harvestTime + "\" returnTime=\"" + this.returnTime + "\" harvestAmount=\"" + this.harvestAmount + "\" sightRadius=\"" + this.sightRadius + "\" isResource=\"" + this.isResource + "\" isStockpile=\"" + this.isStockpile + "\" canHarvest=\"" + this.canHarvest + "\" canMove=\"" + this.canMove + "\" canAttack=\"" + this.canAttack + "\"");
        for (UnitType unitType : this.produces) {
            xMLWriter.tagWithAttributes("produces", "type=\"" + unitType.name + "\"");
            xMLWriter.tag("/produces");
        }
        for (UnitType unitType : this.producedBy) {
            xMLWriter.tagWithAttributes("producedBy", "type=\"" + unitType.name + "\"");
            xMLWriter.tag("/producedBy");
        }
        xMLWriter.tag("/" + this.getClass().getName());
    }

    public void toJSON(Writer writer) throws Exception {
        writer.write("{\"ID\":" + this.ID + ", \"name\":\"" + this.name + "\", \"cost\":" + this.cost + ", \"hp\":" + this.hp + ", \"minDamage\":" + this.minDamage + ", \"maxDamage\":" + this.maxDamage + ", \"attackRange\":" + this.attackRange + ", \"produceTime\":" + this.produceTime + ", \"moveTime\":" + this.moveTime + ", \"attackTime\":" + this.attackTime + ", \"harvestTime\":" + this.harvestTime + ", \"returnTime\":" + this.returnTime + ", \"harvestAmount\":" + this.harvestAmount + ", \"sightRadius\":" + this.sightRadius + ", \"isResource\":" + this.isResource + ", \"isStockpile\":" + this.isStockpile + ", \"canHarvest\":" + this.canHarvest + ", \"canMove\":" + this.canMove + ", \"canAttack\":" + this.canAttack + ", ");
        boolean bl = true;
        writer.write("\"produces\":[");
        for (UnitType unitType : this.produces) {
            if (!bl) {
                writer.write(", ");
            }
            writer.write("\"" + unitType.name + "\"");
            bl = false;
        }
        bl = true;
        writer.write("], \"producedBy\":[");
        for (UnitType unitType : this.producedBy) {
            if (!bl) {
                writer.write(", ");
            }
            writer.write("\"" + unitType.name + "\"");
            bl = false;
        }
        writer.write("]}");
    }

    public static UnitType fromXML(Element element, UnitTypeTable unitTypeTable) {
        UnitType unitType = new UnitType();
        unitType.updateFromXML(element, unitTypeTable);
        return unitType;
    }

    public static UnitType fromJSON(String string, UnitTypeTable unitTypeTable) {
        UnitType unitType = new UnitType();
        unitType.updateFromJSON(string, unitTypeTable);
        return unitType;
    }

    public static UnitType fromJSON(JsonObject jsonObject, UnitTypeTable unitTypeTable) {
        UnitType unitType = new UnitType();
        unitType.updateFromJSON(jsonObject, unitTypeTable);
        return unitType;
    }
}

