/*
 * Decompiled with CFR 0.152.
 */
package rts.units;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import rts.units.UnitType;
import util.XMLWriter;

public class UnitTypeTable {
    public static final int EMPTY_TYPE_TABLE = -1;
    public static final int VERSION_ORIGINAL = 1;
    public static final int VERSION_ORIGINAL_FINETUNED = 2;
    public static final int VERSION_NON_DETERMINISTIC = 3;
    public static final int MOVE_CONFLICT_RESOLUTION_CANCEL_BOTH = 1;
    public static final int MOVE_CONFLICT_RESOLUTION_CANCEL_RANDOM = 2;
    public static final int MOVE_CONFLICT_RESOLUTION_CANCEL_ALTERNATING = 3;
    List<UnitType> unitTypes = new ArrayList<UnitType>();
    int moveConflictResolutionStrategy = 1;

    public UnitTypeTable() {
        this.setUnitTypeTable(1, 1);
    }

    public UnitTypeTable(int n) {
        this.setUnitTypeTable(n, 1);
    }

    public UnitTypeTable(int n, int n2) {
        this.setUnitTypeTable(n, n2);
    }

    public void setUnitTypeTable(int n, int n2) {
        this.moveConflictResolutionStrategy = n2;
        if (n == -1) {
            return;
        }
        UnitType unitType = new UnitType();
        unitType.name = "Resource";
        unitType.isResource = true;
        unitType.isStockpile = false;
        unitType.canHarvest = false;
        unitType.canMove = false;
        unitType.canAttack = false;
        unitType.sightRadius = 0;
        this.addUnitType(unitType);
        UnitType unitType2 = new UnitType();
        unitType2.name = "Base";
        unitType2.cost = 10;
        unitType2.hp = 10;
        switch (n) {
            case 1: {
                unitType2.produceTime = 250;
                break;
            }
            case 2: {
                unitType2.produceTime = 200;
            }
        }
        unitType2.isResource = false;
        unitType2.isStockpile = true;
        unitType2.canHarvest = false;
        unitType2.canMove = false;
        unitType2.canAttack = false;
        unitType2.sightRadius = 5;
        this.addUnitType(unitType2);
        UnitType unitType3 = new UnitType();
        unitType3.name = "Barracks";
        unitType3.cost = 5;
        unitType3.hp = 4;
        switch (n) {
            case 1: {
                unitType3.produceTime = 200;
                break;
            }
            case 2: 
            case 3: {
                unitType3.produceTime = 100;
            }
        }
        unitType3.isResource = false;
        unitType3.isStockpile = false;
        unitType3.canHarvest = false;
        unitType3.canMove = false;
        unitType3.canAttack = false;
        unitType3.sightRadius = 3;
        this.addUnitType(unitType3);
        UnitType unitType4 = new UnitType();
        unitType4.name = "Worker";
        unitType4.cost = 1;
        unitType4.hp = 1;
        switch (n) {
            case 1: 
            case 2: {
                unitType4.maxDamage = 1;
                unitType4.minDamage = 1;
                break;
            }
            case 3: {
                unitType4.minDamage = 0;
                unitType4.maxDamage = 2;
            }
        }
        unitType4.attackRange = 1;
        unitType4.produceTime = 50;
        unitType4.moveTime = 10;
        unitType4.attackTime = 5;
        unitType4.harvestTime = 20;
        unitType4.returnTime = 10;
        unitType4.isResource = false;
        unitType4.isStockpile = false;
        unitType4.canHarvest = true;
        unitType4.canMove = true;
        unitType4.canAttack = true;
        unitType4.sightRadius = 3;
        this.addUnitType(unitType4);
        UnitType unitType5 = new UnitType();
        unitType5.name = "Light";
        unitType5.cost = 2;
        unitType5.hp = 4;
        switch (n) {
            case 1: 
            case 2: {
                unitType5.maxDamage = 2;
                unitType5.minDamage = 2;
                break;
            }
            case 3: {
                unitType5.minDamage = 1;
                unitType5.maxDamage = 3;
            }
        }
        unitType5.attackRange = 1;
        unitType5.produceTime = 80;
        unitType5.moveTime = 8;
        unitType5.attackTime = 5;
        unitType5.isResource = false;
        unitType5.isStockpile = false;
        unitType5.canHarvest = false;
        unitType5.canMove = true;
        unitType5.canAttack = true;
        unitType5.sightRadius = 2;
        this.addUnitType(unitType5);
        UnitType unitType6 = new UnitType();
        unitType6.name = "Heavy";
        switch (n) {
            case 1: 
            case 2: {
                unitType6.maxDamage = 4;
                unitType6.minDamage = 4;
                break;
            }
            case 3: {
                unitType6.minDamage = 0;
                unitType6.maxDamage = 6;
            }
        }
        unitType6.attackRange = 1;
        unitType6.produceTime = 120;
        switch (n) {
            case 1: {
                unitType6.moveTime = 12;
                unitType6.hp = 4;
                unitType6.cost = 2;
                break;
            }
            case 2: 
            case 3: {
                unitType6.moveTime = 10;
                unitType6.hp = 8;
                unitType6.cost = 3;
            }
        }
        unitType6.attackTime = 5;
        unitType6.isResource = false;
        unitType6.isStockpile = false;
        unitType6.canHarvest = false;
        unitType6.canMove = true;
        unitType6.canAttack = true;
        unitType6.sightRadius = 2;
        this.addUnitType(unitType6);
        UnitType unitType7 = new UnitType();
        unitType7.name = "Ranged";
        unitType7.cost = 2;
        unitType7.hp = 1;
        switch (n) {
            case 1: 
            case 2: {
                unitType7.maxDamage = 1;
                unitType7.minDamage = 1;
                break;
            }
            case 3: {
                unitType7.minDamage = 1;
                unitType7.maxDamage = 2;
            }
        }
        unitType7.attackRange = 3;
        unitType7.produceTime = 100;
        unitType7.moveTime = 10;
        unitType7.attackTime = 5;
        unitType7.isResource = false;
        unitType7.isStockpile = false;
        unitType7.canHarvest = false;
        unitType7.canMove = true;
        unitType7.canAttack = true;
        unitType7.sightRadius = 3;
        this.addUnitType(unitType7);
        unitType2.produces(unitType4);
        unitType3.produces(unitType5);
        unitType3.produces(unitType6);
        unitType3.produces(unitType7);
        unitType4.produces(unitType2);
        unitType4.produces(unitType3);
    }

    public void addUnitType(UnitType unitType) {
        unitType.ID = this.unitTypes.size();
        this.unitTypes.add(unitType);
    }

    public UnitType getUnitType(int n) {
        return this.unitTypes.get(n);
    }

    public UnitType getUnitType(String string) {
        for (UnitType unitType : this.unitTypes) {
            if (!unitType.name.equals(string)) continue;
            return unitType;
        }
        return null;
    }

    public List<UnitType> getUnitTypes() {
        return this.unitTypes;
    }

    public int getMoveConflictResolutionStrategy() {
        return this.moveConflictResolutionStrategy;
    }

    public void toxml(XMLWriter xMLWriter) {
        xMLWriter.tagWithAttributes(this.getClass().getName(), "moveConflictResolutionStrategy=\"" + this.moveConflictResolutionStrategy + "\"");
        for (UnitType unitType : this.unitTypes) {
            unitType.toxml(xMLWriter);
        }
        xMLWriter.tag("/" + this.getClass().getName());
    }

    public void toJSON(Writer writer) throws Exception {
        boolean bl = true;
        writer.write("{\"moveConflictResolutionStrategy\":" + this.moveConflictResolutionStrategy + ",");
        writer.write("\"unitTypes\":[");
        for (UnitType unitType : this.unitTypes) {
            if (!bl) {
                writer.write(", ");
            }
            unitType.toJSON(writer);
            bl = false;
        }
        writer.write("]}");
    }

    public static UnitTypeTable fromXML(Element element) {
        Element element2;
        UnitTypeTable unitTypeTable = new UnitTypeTable(-1);
        unitTypeTable.moveConflictResolutionStrategy = Integer.parseInt(element.getAttributeValue("moveConflictResolutionStrategy"));
        for (Object e : element.getChildren()) {
            element2 = (Element)e;
            unitTypeTable.unitTypes.add(UnitType.createStub(element2));
        }
        for (Object e : element.getChildren()) {
            element2 = (Element)e;
            unitTypeTable.getUnitType(element2.getAttributeValue("name")).updateFromXML(element2, unitTypeTable);
        }
        return unitTypeTable;
    }

    public static UnitTypeTable fromJSON(String string) {
        JsonObject jsonObject;
        JsonObject jsonObject2 = Json.parse(string).asObject();
        UnitTypeTable unitTypeTable = new UnitTypeTable(-1);
        unitTypeTable.moveConflictResolutionStrategy = jsonObject2.getInt("moveConflictResolutionStrategy", 1);
        JsonArray jsonArray = jsonObject2.get("unitTypes").asArray();
        for (JsonValue jsonValue : jsonArray.values()) {
            jsonObject = jsonValue.asObject();
            unitTypeTable.unitTypes.add(UnitType.createStub(jsonObject));
        }
        for (JsonValue jsonValue : jsonArray.values()) {
            jsonObject = jsonValue.asObject();
            unitTypeTable.getUnitType(jsonObject.getString("name", null)).updateFromJSON(jsonObject, unitTypeTable);
        }
        return unitTypeTable;
    }
}

