/*
 * Decompiled with CFR 0.152.
 */
package tests;

import ai.abstraction.WorkerRush;
import ai.core.AI;
import ai.core.ParameterSpecification;
import ai.mcts.informedmcts.InformedNaiveMCTS;
import ai.mcts.naivemcts.NaiveMCTS;
import ai.montecarlo.lsi.LSI;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import rts.GameState;
import rts.PhysicalGameState;
import rts.units.UnitTypeTable;

public class AIComplianceTest {
    public static void main(String[] stringArray) {
        AIComplianceTest.complianceTest(WorkerRush.class);
        AIComplianceTest.complianceTest(NaiveMCTS.class);
        AIComplianceTest.complianceTest(InformedNaiveMCTS.class);
        AIComplianceTest.complianceTest(LSI.class);
    }

    public static boolean complianceTest(Class clazz) {
        System.out.println("Testing " + clazz.getName() + "...");
        List<Class> list = AIComplianceTest.getSuperClasses(clazz);
        try {
            Object object;
            Object object2;
            Object object3;
            UnitTypeTable unitTypeTable = new UnitTypeTable();
            if (!list.contains(AI.class)) {
                System.err.println(clazz.getName() + " does not extend AI.class!");
                return false;
            }
            AI aI = null;
            try {
                object3 = clazz.getConstructor(UnitTypeTable.class);
                if (object3 == null) {
                    System.err.println(clazz.getName() + " does not have a base constructor with just the UnitTypeTable!");
                    return false;
                }
                aI = (AI)((Constructor)object3).newInstance(unitTypeTable);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                System.err.println(clazz.getName() + " does not have a base constructor with just the UnitTypeTable!");
                return false;
            }
            object3 = aI.getParameters();
            Object object4 = object3.iterator();
            while (object4.hasNext()) {
                object2 = (ParameterSpecification)object4.next();
                System.out.println("    " + ((ParameterSpecification)object2).name + ": " + ((ParameterSpecification)object2).type.getName());
                try {
                    object = clazz.getMethod("get" + ((ParameterSpecification)object2).name, new Class[0]);
                    if (object == null) {
                        System.err.println(clazz.getName() + " does not have a getter for parameter " + ((ParameterSpecification)object2).name);
                        return false;
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    System.err.println(clazz.getName() + " does not have a getter for parameter " + ((ParameterSpecification)object2).name);
                    return false;
                }
                try {
                    object = clazz.getMethod("set" + ((ParameterSpecification)object2).name, ((ParameterSpecification)object2).type);
                    if (object != null) continue;
                    System.err.println(clazz.getName() + " does not have a setter for parameter " + ((ParameterSpecification)object2).name);
                    return false;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    System.err.println(clazz.getName() + " does not have a setter for parameter " + ((ParameterSpecification)object2).name);
                    return false;
                }
            }
            object4 = PhysicalGameState.load("maps/16x16/basesWorkers16x16.xml", unitTypeTable);
            object2 = new GameState((PhysicalGameState)object4, unitTypeTable);
            object = aI.getAction(0, (GameState)object2);
            if (object == null) {
                System.err.println(clazz.getName() + " did not generate a proper action!");
                return false;
            }
            System.out.println(object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        System.out.println(clazz.getName() + " is compliant with the microRTS requirements.");
        return true;
    }

    public static List<Class> getSuperClasses(Class clazz) {
        ArrayList<Class> arrayList = new ArrayList<Class>();
        while (clazz != null) {
            arrayList.add(clazz);
            clazz = clazz.getSuperclass();
        }
        return arrayList;
    }
}

