/*
 * Decompiled with CFR 0.152.
 */
package tests;

import ai.abstraction.AbstractAction;
import ai.abstraction.AbstractTrace;
import ai.abstraction.AbstractTraceEntry;
import ai.abstraction.AbstractionLayerAI;
import ai.abstraction.LightRush;
import ai.abstraction.WorkerRush;
import ai.abstraction.pathfinding.BFSPathFinding;
import ai.core.AI;
import java.io.FileWriter;
import java.io.IOException;
import rts.GameState;
import rts.PhysicalGameState;
import rts.PlayerAction;
import rts.units.Unit;
import rts.units.UnitTypeTable;
import util.XMLWriter;

public class AbstractTraceGenerationTest {
    public static void main(String[] stringArray) throws IOException, Exception {
        Object object;
        UnitTypeTable unitTypeTable = new UnitTypeTable();
        PhysicalGameState physicalGameState = PhysicalGameState.load("maps/16x16/basesWorkers16x16.xml", unitTypeTable);
        GameState gameState = new GameState(physicalGameState, unitTypeTable);
        int n = 5000;
        boolean bl = false;
        LightRush lightRush = new LightRush(unitTypeTable, new BFSPathFinding());
        WorkerRush workerRush = new WorkerRush(unitTypeTable, new BFSPathFinding());
        AbstractTrace abstractTrace = new AbstractTrace(unitTypeTable);
        AbstractTraceEntry abstractTraceEntry = new AbstractTraceEntry(gameState.getPhysicalGameState().clone(), gameState.getTime());
        abstractTrace.addEntry(abstractTraceEntry);
        do {
            object = ((AI)lightRush).getAction(0, gameState);
            PlayerAction playerAction = ((AI)workerRush).getAction(1, gameState);
            if (!((PlayerAction)object).isEmpty() || !playerAction.isEmpty()) {
                AbstractAction abstractAction;
                AbstractionLayerAI abstractionLayerAI;
                abstractTraceEntry = new AbstractTraceEntry(gameState.getPhysicalGameState().clone(), gameState.getTime());
                if (lightRush instanceof AbstractionLayerAI) {
                    abstractionLayerAI = lightRush;
                    for (Unit unit : gameState.getUnits()) {
                        abstractAction = abstractionLayerAI.getAbstractAction(unit);
                        if (abstractAction == null) continue;
                        abstractTraceEntry.addAbstractActionIfNew(unit, abstractAction, abstractTrace);
                    }
                }
                if (workerRush instanceof AbstractionLayerAI) {
                    abstractionLayerAI = workerRush;
                    for (Unit unit : gameState.getUnits()) {
                        abstractAction = abstractionLayerAI.getAbstractAction(unit);
                        if (abstractAction == null) continue;
                        abstractTraceEntry.addAbstractActionIfNew(unit, abstractAction, abstractTrace);
                    }
                }
                abstractTrace.addEntry(abstractTraceEntry);
            }
            gameState.issueSafe((PlayerAction)object);
            gameState.issueSafe(playerAction);
        } while (!(bl = gameState.cycle()) && gameState.getTime() < n);
        abstractTraceEntry = new AbstractTraceEntry(gameState.getPhysicalGameState().clone(), gameState.getTime());
        abstractTrace.addEntry(abstractTraceEntry);
        object = new XMLWriter(new FileWriter("abstracttrace.xml"));
        abstractTrace.toxml((XMLWriter)object);
        ((XMLWriter)object).flush();
    }
}

