/*
 * Decompiled with CFR 0.152.
 */
package tests;

import ai.core.AI;
import gui.PhysicalGameStateJFrame;
import gui.PhysicalGameStatePanel;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import rts.GameState;
import rts.PartiallyObservableGameState;
import rts.PhysicalGameState;
import rts.PlayerAction;
import rts.Trace;
import rts.TraceEntry;
import rts.units.UnitTypeTable;
import util.XMLWriter;

public class Experimenter {
    public static int DEBUG = 0;
    public static boolean GC_EACH_FRAME = true;

    public static void runExperiments(List<AI> list, List<PhysicalGameState> list2, UnitTypeTable unitTypeTable, int n, int n2, int n3, boolean bl) throws Exception {
        Experimenter.runExperiments(list, list2, unitTypeTable, n, n2, n3, bl, System.out, -1, false);
    }

    public static void runExperimentsPartiallyObservable(List<AI> list, List<PhysicalGameState> list2, UnitTypeTable unitTypeTable, int n, int n2, int n3, boolean bl) throws Exception {
        Experimenter.runExperiments(list, list2, unitTypeTable, n, n2, n3, bl, System.out, -1, true);
    }

    public static void runExperiments(List<AI> list, List<PhysicalGameState> list2, UnitTypeTable unitTypeTable, int n, int n2, int n3, boolean bl, PrintStream printStream) throws Exception {
        Experimenter.runExperiments(list, list2, unitTypeTable, n, n2, n3, bl, printStream, -1, false);
    }

    public static void runExperimentsPartiallyObservable(List<AI> list, List<PhysicalGameState> list2, UnitTypeTable unitTypeTable, int n, int n2, int n3, boolean bl, PrintStream printStream) throws Exception {
        Experimenter.runExperiments(list, list2, unitTypeTable, n, n2, n3, bl, printStream, -1, true);
    }

    public static void runExperiments(List<AI> list, List<PhysicalGameState> list2, UnitTypeTable unitTypeTable, int n, int n2, int n3, boolean bl, PrintStream printStream, int n4, boolean bl2) throws Exception {
        Experimenter.runExperiments(list, list2, unitTypeTable, n, n2, n3, bl, printStream, n4, false, bl2);
    }

    public static void runExperiments(List<AI> list, List<PhysicalGameState> list2, UnitTypeTable unitTypeTable, int n, int n2, int n3, boolean bl, PrintStream printStream, int n4, boolean bl2, boolean bl3) throws Exception {
        Experimenter.runExperiments(list, list2, unitTypeTable, n, n2, n3, bl, printStream, n4, bl2, bl3, false, false, "");
    }

    public static void runExperiments(List<AI> list, List<PhysicalGameState> list2, UnitTypeTable unitTypeTable, int n, int n2, int n3, boolean bl, PrintStream printStream, int n4, boolean bl2, boolean bl3, boolean bl4, boolean bl5, String string) throws Exception {
        int n5;
        int[][] nArray = new int[list.size()][list.size()];
        int[][] nArray2 = new int[list.size()][list.size()];
        int[][] nArray3 = new int[list.size()][list.size()];
        double[][] dArray = new double[list.size()][list.size()];
        double[][] dArray2 = new double[list.size()][list.size()];
        double[][] dArray3 = new double[list.size()][list.size()];
        LinkedList<AI> linkedList = new LinkedList<AI>();
        for (AI aI : list) {
            linkedList.add(aI.clone());
        }
        for (n5 = 0; n5 < list.size(); ++n5) {
            for (int j = 0; j < list.size(); ++j) {
                if (n4 != -1 && n5 != n4 && j != n4 || bl2 && n5 == j) continue;
                int n6 = 0;
                for (PhysicalGameState physicalGameState : list2) {
                    for (int k = 0; k < n; ++k) {
                        Object object;
                        Object object2;
                        TraceEntry traceEntry;
                        AI aI = list.get(n5).clone();
                        AI aI2 = ((AI)linkedList.get(j)).clone();
                        long l = 0L;
                        aI.reset();
                        aI2.reset();
                        GameState gameState = new GameState(physicalGameState.clone(), unitTypeTable);
                        PhysicalGameStateJFrame physicalGameStateJFrame = null;
                        if (bl) {
                            physicalGameStateJFrame = PhysicalGameStatePanel.newVisualizer(gameState, 600, 600, bl3);
                        }
                        printStream.println("MATCH UP: " + aI + " vs " + aI2);
                        boolean bl6 = false;
                        Trace trace = null;
                        if (bl4) {
                            trace = new Trace(unitTypeTable);
                            traceEntry = new TraceEntry(gameState.getPhysicalGameState().clone(), gameState.getTime());
                            trace.addEntry(traceEntry);
                        }
                        do {
                            if (GC_EACH_FRAME) {
                                System.gc();
                            }
                            object2 = null;
                            object = null;
                            if (bl3) {
                                object2 = aI.getAction(0, new PartiallyObservableGameState(gameState, 0));
                                object = aI2.getAction(1, new PartiallyObservableGameState(gameState, 1));
                            } else {
                                object2 = aI.getAction(0, gameState);
                                if (DEBUG >= 1) {
                                    System.out.println("AI1 done.");
                                    printStream.flush();
                                }
                                object = aI2.getAction(1, gameState);
                                if (DEBUG >= 1) {
                                    System.out.println("AI2 done.");
                                    printStream.flush();
                                }
                            }
                            if (!(!bl4 || ((PlayerAction)object2).isEmpty() && ((PlayerAction)object).isEmpty())) {
                                traceEntry = new TraceEntry(gameState.getPhysicalGameState().clone(), gameState.getTime());
                                traceEntry.addPlayerAction(((PlayerAction)object2).clone());
                                traceEntry.addPlayerAction(((PlayerAction)object).clone());
                                trace.addEntry(traceEntry);
                            }
                            if (gameState.issueSafe((PlayerAction)object2)) {
                                l = gameState.getTime();
                            }
                            if (gameState.issueSafe((PlayerAction)object)) {
                                l = gameState.getTime();
                            }
                            bl6 = gameState.cycle();
                            if (DEBUG >= 1) {
                                System.out.println("cycle done.");
                                printStream.flush();
                            }
                            if (physicalGameStateJFrame == null) continue;
                            physicalGameStateJFrame.setStateCloning(gameState);
                            physicalGameStateJFrame.repaint();
                            try {
                                Thread.sleep(1L);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        } while (!bl6 && gameState.getTime() < n2 && (long)gameState.getTime() - l < (long)n3);
                        aI.gameOver(gameState.winner());
                        aI2.gameOver(gameState.winner());
                        if (bl4) {
                            traceEntry = new TraceEntry(gameState.getPhysicalGameState().clone(), gameState.getTime());
                            trace.addEntry(traceEntry);
                            object = null;
                            String string2 = aI.toString() + "Vs" + aI2.toString() + "-" + n6 + "-" + k;
                            string2 = string2.replace("/", "");
                            string2 = string2.replace(")", "");
                            string2 = string2.replace("(", "");
                            string2 = string + "/" + string2;
                            if (bl5) {
                                object = new ZipOutputStream(new FileOutputStream(string2 + ".zip"));
                                ((ZipOutputStream)object).putNextEntry(new ZipEntry("game.xml"));
                                object2 = new XMLWriter(new OutputStreamWriter((OutputStream)object));
                            } else {
                                object2 = new XMLWriter(new FileWriter(string2 + ".xml"));
                            }
                            trace.toxml((XMLWriter)object2);
                            ((XMLWriter)object2).flush();
                            if (bl5) {
                                ((ZipOutputStream)object).closeEntry();
                                ((ZipOutputStream)object).close();
                            }
                        }
                        if (physicalGameStateJFrame != null) {
                            physicalGameStateJFrame.dispose();
                        }
                        int n7 = gameState.winner();
                        printStream.println("Winner: " + n7 + "  in " + gameState.getTime() + " cycles");
                        printStream.println(aI + " : " + aI.statisticsString());
                        printStream.println(aI2 + " : " + aI2.statisticsString());
                        printStream.flush();
                        if (n7 == -1) {
                            int[] nArray4 = nArray2[n5];
                            int n8 = j;
                            nArray4[n8] = nArray4[n8] + 1;
                            double[] dArray4 = dArray2[n5];
                            int n9 = j;
                            dArray4[n9] = dArray4[n9] + (double)gameState.getTime();
                            int[] nArray5 = nArray2[j];
                            int n10 = n5;
                            nArray5[n10] = nArray5[n10] + 1;
                            double[] dArray5 = dArray2[j];
                            int n11 = n5;
                            dArray5[n11] = dArray5[n11] + (double)gameState.getTime();
                            continue;
                        }
                        if (n7 == 0) {
                            int[] nArray6 = nArray[n5];
                            int n12 = j;
                            nArray6[n12] = nArray6[n12] + 1;
                            double[] dArray6 = dArray[n5];
                            int n13 = j;
                            dArray6[n13] = dArray6[n13] + (double)gameState.getTime();
                            int[] nArray7 = nArray3[j];
                            int n14 = n5;
                            nArray7[n14] = nArray7[n14] + 1;
                            double[] dArray7 = dArray3[j];
                            int n15 = n5;
                            dArray7[n15] = dArray7[n15] + (double)gameState.getTime();
                            continue;
                        }
                        if (n7 != 1) continue;
                        int[] nArray8 = nArray3[n5];
                        int n16 = j;
                        nArray8[n16] = nArray8[n16] + 1;
                        double[] dArray8 = dArray3[n5];
                        int n17 = j;
                        dArray8[n17] = dArray8[n17] + (double)gameState.getTime();
                        int[] nArray9 = nArray[j];
                        int n18 = n5;
                        nArray9[n18] = nArray9[n18] + 1;
                        double[] dArray9 = dArray[j];
                        int n19 = n5;
                        dArray9[n19] = dArray9[n19] + (double)gameState.getTime();
                    }
                    ++n6;
                }
            }
        }
        printStream.println("Wins: ");
        for (n5 = 0; n5 < list.size(); ++n5) {
            for (int j = 0; j < list.size(); ++j) {
                printStream.print(nArray[n5][j] + ", ");
            }
            printStream.println("");
        }
        printStream.println("Ties: ");
        for (n5 = 0; n5 < list.size(); ++n5) {
            for (int j = 0; j < list.size(); ++j) {
                printStream.print(nArray2[n5][j] + ", ");
            }
            printStream.println("");
        }
        printStream.println("Loses: ");
        for (n5 = 0; n5 < list.size(); ++n5) {
            for (int j = 0; j < list.size(); ++j) {
                printStream.print(nArray3[n5][j] + ", ");
            }
            printStream.println("");
        }
        printStream.println("Win average time: ");
        for (n5 = 0; n5 < list.size(); ++n5) {
            for (int j = 0; j < list.size(); ++j) {
                if (nArray[n5][j] > 0) {
                    printStream.print(dArray[n5][j] / (double)nArray[n5][j] + ", ");
                    continue;
                }
                printStream.print("-, ");
            }
            printStream.println("");
        }
        printStream.println("Tie average time: ");
        for (n5 = 0; n5 < list.size(); ++n5) {
            for (int j = 0; j < list.size(); ++j) {
                if (nArray2[n5][j] > 0) {
                    printStream.print(dArray2[n5][j] / (double)nArray2[n5][j] + ", ");
                    continue;
                }
                printStream.print("-, ");
            }
            printStream.println("");
        }
        printStream.println("Lose average time: ");
        for (n5 = 0; n5 < list.size(); ++n5) {
            for (int j = 0; j < list.size(); ++j) {
                if (nArray3[n5][j] > 0) {
                    printStream.print(dArray3[n5][j] / (double)nArray3[n5][j] + ", ");
                    continue;
                }
                printStream.print("-, ");
            }
            printStream.println("");
        }
        printStream.flush();
    }
}

