/*
 * Decompiled with CFR 0.152.
 */
package tests;

import ai.BranchingFactorCalculatorDouble;
import ai.core.AI;
import gui.PhysicalGameStateJFrame;
import gui.PhysicalGameStatePanel;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import rts.GameState;
import rts.PhysicalGameState;
import rts.PlayerAction;
import rts.Trace;
import rts.TraceEntry;
import rts.units.UnitTypeTable;
import util.RunnableWithTimeOut;
import util.XMLWriter;

public class ExperimenterAsymmetric {
    public static long BRANCHING_CALCULATION_TIMEOUT = 0x6DDD00L;
    public static boolean PRINT_BRANCHING_AT_EACH_MOVE = false;

    public static void runExperiments(List<AI> list, List<AI> list2, List<PhysicalGameState> list3, UnitTypeTable unitTypeTable, int n, int n2, int n3, boolean bl, PrintStream printStream) throws Exception {
        ExperimenterAsymmetric.runExperiments(list, list2, list3, unitTypeTable, n, n2, n3, bl, printStream, false, false, "");
    }

    public static void runExperiments(List<AI> list, List<AI> list2, List<PhysicalGameState> list3, UnitTypeTable unitTypeTable, int n, int n2, int n3, boolean bl, PrintStream printStream, boolean bl2, boolean bl3, String string) throws Exception {
        int n4;
        int n5;
        int[][] nArray = new int[list.size()][list2.size()];
        int[][] nArray2 = new int[list.size()][list2.size()];
        int[][] nArray3 = new int[list.size()][list2.size()];
        double[][] dArray = new double[list.size()][list2.size()];
        double[][] dArray2 = new double[list.size()][list2.size()];
        double[][] dArray3 = new double[list.size()][list2.size()];
        for (n5 = 0; n5 < list.size(); ++n5) {
            for (n4 = 0; n4 < list2.size(); ++n4) {
                int n6 = 0;
                for (PhysicalGameState physicalGameState : list3) {
                    for (int j = 0; j < n; ++j) {
                        Object object;
                        Object object2;
                        TraceEntry traceEntry;
                        AI aI = list.get(n5).clone();
                        AI aI2 = list2.get(n4).clone();
                        long l = 0L;
                        aI.reset();
                        aI2.reset();
                        GameState gameState = new GameState(physicalGameState.clone(), unitTypeTable);
                        PhysicalGameStateJFrame physicalGameStateJFrame = null;
                        if (bl) {
                            physicalGameStateJFrame = PhysicalGameStatePanel.newVisualizer(gameState, 600, 600);
                        }
                        printStream.println("MATCH UP: " + aI + " vs " + aI2);
                        System.gc();
                        boolean bl4 = false;
                        Trace trace = null;
                        if (bl2) {
                            trace = new Trace(unitTypeTable);
                            traceEntry = new TraceEntry(gameState.getPhysicalGameState().clone(), gameState.getTime());
                            trace.addEntry(traceEntry);
                        }
                        do {
                            if (PRINT_BRANCHING_AT_EACH_MOVE) {
                                object2 = gameState.canExecuteAnyAction(0) ? "" + BranchingCalculatorWithTimeOut.branching(gameState, 0, BRANCHING_CALCULATION_TIMEOUT) : "-";
                                Object object3 = object = gameState.canExecuteAnyAction(1) ? "" + BranchingCalculatorWithTimeOut.branching(gameState, 1, BRANCHING_CALCULATION_TIMEOUT) : "-";
                                if (!((String)object2).equals("-") || !((String)object).equals("-")) {
                                    printStream.print("branching\t" + (String)object2 + "\t" + (String)object + "\n");
                                }
                            }
                            object2 = aI.getAction(0, gameState);
                            object = aI2.getAction(1, gameState);
                            if (!(!bl2 || ((PlayerAction)object2).isEmpty() && ((PlayerAction)object).isEmpty())) {
                                traceEntry = new TraceEntry(gameState.getPhysicalGameState().clone(), gameState.getTime());
                                traceEntry.addPlayerAction(((PlayerAction)object2).clone());
                                traceEntry.addPlayerAction(((PlayerAction)object).clone());
                                trace.addEntry(traceEntry);
                            }
                            if (gameState.issueSafe((PlayerAction)object2)) {
                                l = gameState.getTime();
                            }
                            if (gameState.issueSafe((PlayerAction)object)) {
                                l = gameState.getTime();
                            }
                            bl4 = gameState.cycle();
                            if (physicalGameStateJFrame == null) continue;
                            physicalGameStateJFrame.repaint();
                            try {
                                Thread.sleep(1L);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        } while (!bl4 && gameState.getTime() < n2 && (long)gameState.getTime() - l < (long)n3);
                        aI.gameOver(gameState.winner());
                        aI2.gameOver(gameState.winner());
                        if (bl2) {
                            traceEntry = new TraceEntry(gameState.getPhysicalGameState().clone(), gameState.getTime());
                            trace.addEntry(traceEntry);
                            object = null;
                            String string2 = aI.toString() + "Vs" + aI2.toString() + "-" + n6 + "-" + j;
                            string2 = string2.replace("/", "");
                            string2 = string2.replace(")", "");
                            string2 = string2.replace("(", "");
                            string2 = string + "/" + string2;
                            if (bl3) {
                                object = new ZipOutputStream(new FileOutputStream(string2 + ".zip"));
                                ((ZipOutputStream)object).putNextEntry(new ZipEntry("game.xml"));
                                object2 = new XMLWriter(new OutputStreamWriter((OutputStream)object));
                            } else {
                                object2 = new XMLWriter(new FileWriter(string2 + ".xml"));
                            }
                            trace.toxml((XMLWriter)object2);
                            ((XMLWriter)object2).flush();
                            if (bl3) {
                                ((ZipOutputStream)object).closeEntry();
                                ((ZipOutputStream)object).close();
                            }
                        }
                        if (physicalGameStateJFrame != null) {
                            physicalGameStateJFrame.dispose();
                        }
                        int n7 = gameState.winner();
                        printStream.println("Winner: " + n7 + "  in " + gameState.getTime() + " cycles");
                        printStream.println(aI + " : " + aI.statisticsString());
                        printStream.println(aI2 + " : " + aI2.statisticsString());
                        printStream.flush();
                        if (n7 == -1) {
                            int[] nArray4 = nArray2[n5];
                            int n8 = n4;
                            nArray4[n8] = nArray4[n8] + 1;
                            double[] dArray4 = dArray2[n5];
                            int n9 = n4;
                            dArray4[n9] = dArray4[n9] + (double)gameState.getTime();
                            continue;
                        }
                        if (n7 == 0) {
                            int[] nArray5 = nArray[n5];
                            int n10 = n4;
                            nArray5[n10] = nArray5[n10] + 1;
                            double[] dArray5 = dArray[n5];
                            int n11 = n4;
                            dArray5[n11] = dArray5[n11] + (double)gameState.getTime();
                            continue;
                        }
                        if (n7 != 1) continue;
                        int[] nArray6 = nArray3[n5];
                        int n12 = n4;
                        nArray6[n12] = nArray6[n12] + 1;
                        double[] dArray6 = dArray3[n5];
                        int n13 = n4;
                        dArray6[n13] = dArray6[n13] + (double)gameState.getTime();
                    }
                    ++n6;
                }
            }
        }
        printStream.println("Notice that the results below are only from the perspective of the 'bots1' list.");
        printStream.println("If you want a symmetric experimentation, use the 'Experimenter' class");
        printStream.println("Wins: ");
        for (n5 = 0; n5 < list.size(); ++n5) {
            for (n4 = 0; n4 < list2.size(); ++n4) {
                printStream.print(nArray[n5][n4] + ", ");
            }
            printStream.println("");
        }
        printStream.println("Ties: ");
        for (n5 = 0; n5 < list.size(); ++n5) {
            for (n4 = 0; n4 < list2.size(); ++n4) {
                printStream.print(nArray2[n5][n4] + ", ");
            }
            printStream.println("");
        }
        printStream.println("Loses: ");
        for (n5 = 0; n5 < list.size(); ++n5) {
            for (n4 = 0; n4 < list2.size(); ++n4) {
                printStream.print(nArray3[n5][n4] + ", ");
            }
            printStream.println("");
        }
        printStream.println("Win average time: ");
        for (n5 = 0; n5 < list.size(); ++n5) {
            for (n4 = 0; n4 < list2.size(); ++n4) {
                if (nArray[n5][n4] > 0) {
                    printStream.print(dArray[n5][n4] / (double)nArray[n5][n4] + ", ");
                    continue;
                }
                printStream.print("-, ");
            }
            printStream.println("");
        }
        printStream.println("Tie average time: ");
        for (n5 = 0; n5 < list.size(); ++n5) {
            for (n4 = 0; n4 < list2.size(); ++n4) {
                if (nArray2[n5][n4] > 0) {
                    printStream.print(dArray2[n5][n4] / (double)nArray2[n5][n4] + ", ");
                    continue;
                }
                printStream.print("-, ");
            }
            printStream.println("");
        }
        printStream.println("Lose average time: ");
        for (n5 = 0; n5 < list.size(); ++n5) {
            for (n4 = 0; n4 < list2.size(); ++n4) {
                if (nArray3[n5][n4] > 0) {
                    printStream.print(dArray3[n5][n4] / (double)nArray3[n5][n4] + ", ");
                    continue;
                }
                printStream.print("-, ");
            }
            printStream.println("");
        }
        printStream.flush();
    }

    static class BranchingCalculatorWithTimeOut {
        static double branching = 0.0;
        static boolean running = false;

        BranchingCalculatorWithTimeOut() {
        }

        static double branching(final GameState gameState, final int n, long l) throws Exception {
            if (running) {
                throw new Exception("Two calls to BranchingCalculatorWithTimeOut in parallel!");
            }
            branching = 0.0;
            running = true;
            try {
                RunnableWithTimeOut.runWithTimeout(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            branching = BranchingFactorCalculatorDouble.branchingFactorByResourceUsageSeparatingFast(gameState, n);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }, l, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
            running = false;
            return branching;
        }
    }
}

