/*
 * Decompiled with CFR 0.152.
 */
package tests;

import ai.RandomBiasedAI;
import ai.abstraction.WorkerRush;
import ai.abstraction.pathfinding.BFSPathFinding;
import ai.core.AI;
import gui.PhysicalGameStateJFrame;
import gui.PhysicalGameStatePanel;
import rts.GameState;
import rts.PhysicalGameState;
import rts.PlayerAction;
import rts.units.UnitTypeTable;

public class GameVisualSimulationTest {
    public static void main(String[] stringArray) throws Exception {
        UnitTypeTable unitTypeTable = new UnitTypeTable();
        PhysicalGameState physicalGameState = PhysicalGameState.load("maps/16x16/basesWorkers16x16.xml", unitTypeTable);
        GameState gameState = new GameState(physicalGameState, unitTypeTable);
        int n = 5000;
        int n2 = 20;
        boolean bl = false;
        WorkerRush workerRush = new WorkerRush(unitTypeTable, new BFSPathFinding());
        RandomBiasedAI randomBiasedAI = new RandomBiasedAI();
        PhysicalGameStateJFrame physicalGameStateJFrame = PhysicalGameStatePanel.newVisualizer(gameState, 640, 640, false, PhysicalGameStatePanel.COLORSCHEME_BLACK);
        long l = System.currentTimeMillis() + (long)n2;
        do {
            if (System.currentTimeMillis() >= l) {
                PlayerAction playerAction = ((AI)workerRush).getAction(0, gameState);
                PlayerAction playerAction2 = ((AI)randomBiasedAI).getAction(1, gameState);
                gameState.issueSafe(playerAction);
                gameState.issueSafe(playerAction2);
                bl = gameState.cycle();
                physicalGameStateJFrame.repaint();
                l += (long)n2;
                continue;
            }
            try {
                Thread.sleep(1L);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } while (!bl && gameState.getTime() < n);
        workerRush.gameOver(gameState.winner());
        randomBiasedAI.gameOver(gameState.winner());
        System.out.println("Game Over");
    }
}

