/*
 * Decompiled with CFR 0.152.
 */
package tests;

import ai.jni.JNIAI;
import ai.jni.JNIInterface;
import ai.rewardfunction.RewardFunctionInterface;
import gui.PhysicalGameStateJFrame;
import gui.PhysicalGameStatePanel;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.WritableRaster;
import java.io.StringWriter;
import java.nio.file.Paths;
import rts.GameState;
import rts.PhysicalGameState;
import rts.PlayerAction;
import rts.TraceEntry;
import rts.UnitAction;
import rts.units.Unit;
import rts.units.UnitTypeTable;

public class JNISelfPlayClient {
    PhysicalGameStateJFrame w;
    public JNIInterface ai1;
    public JNIInterface ai2;
    PhysicalGameState pgs;
    GameState gs;
    UnitTypeTable utt;
    public RewardFunctionInterface[] rfs;
    String mapPath;
    String micrortsPath;
    boolean gameover = false;
    boolean layerJSON = true;
    int gamestep = 0;
    int ai2Frameskip = 20;

    public JNISelfPlayClient(RewardFunctionInterface[] rewardFunctionInterfaceArray, String string, String string2, UnitTypeTable unitTypeTable) throws Exception {
        this.micrortsPath = string;
        this.mapPath = string2;
        this.rfs = rewardFunctionInterfaceArray;
        this.utt = unitTypeTable;
        this.ai1 = new JNIAI(100, 0, this.utt);
        this.ai2 = new JNIAI(100, 0, this.utt);
        if (this.micrortsPath.length() != 0) {
            this.mapPath = Paths.get(this.micrortsPath, this.mapPath).toString();
        }
        System.out.println(this.mapPath);
        System.out.println(this.rfs);
    }

    public byte[] render(boolean bl) throws Exception {
        long l = System.nanoTime();
        if (this.w == null) {
            this.w = PhysicalGameStatePanel.newVisualizer(this.gs, 640, 640, false, PhysicalGameStatePanel.COLORSCHEME_BLACK);
        }
        this.w.setStateCloning(this.gs);
        this.w.repaint();
        if (!bl) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(this.w.getWidth(), this.w.getHeight(), 5);
        this.w.paint(bufferedImage.getGraphics());
        WritableRaster writableRaster = bufferedImage.getRaster();
        DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
        return dataBufferByte.getData();
    }

    public Response step(int[][] nArray, int[][] nArray2, int n) throws Exception {
        double[] dArray = new double[this.rfs.length];
        for (int j = 0; j <= n; ++j) {
            PlayerAction playerAction;
            PlayerAction playerAction2;
            if (j == 0) {
                playerAction2 = this.ai1.getAction(0, this.gs, nArray);
                playerAction = this.ai2.getAction(1, this.gs, nArray2);
            } else {
                playerAction2 = new PlayerAction();
                playerAction2.fillWithNones(this.gs, 0, 0);
                playerAction = new PlayerAction();
                playerAction.fillWithNones(this.gs, 1, 0);
            }
            this.gs.issueSafe(playerAction2);
            this.gs.issueSafe(playerAction);
            TraceEntry traceEntry = new TraceEntry(this.gs.getPhysicalGameState().clone(), this.gs.getTime());
            traceEntry.addPlayerAction(playerAction2.clone());
            traceEntry.addPlayerAction(playerAction.clone());
            this.gameover = this.gs.cycle();
            if (this.gameover) {
                // empty if block
            }
            try {
                Thread.yield();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            for (int k = 0; k < dArray.length; ++k) {
                this.rfs[k].computeReward(0, 1, traceEntry, this.gs);
                int n2 = k;
                dArray[n2] = dArray[n2] + this.rfs[k].getReward();
            }
        }
        boolean[] blArray = new boolean[this.rfs.length];
        for (int j = 0; j < dArray.length; ++j) {
            blArray[j] = this.rfs[j].isDone();
        }
        ++this.gamestep;
        return new Response(this.ai1.getObservation(0, this.gs), dArray, blArray, this.ai1.computeInfo(0, this.gs));
    }

    public int[][] getUnitActionMasks(int[][] nArray) throws Exception {
        int[][] nArray2 = new int[nArray.length][22];
        int n = this.gs.getPhysicalGameState().getWidth();
        for (int j = 0; j < nArray2.length; ++j) {
            Unit unit = this.gs.getPhysicalGameState().getUnitAt(nArray[j][0] % n, nArray[j][0] / n);
            nArray2[j] = UnitAction.getValidActionArray(unit.getUnitActions(this.gs), this.gs, this.utt);
        }
        return nArray2;
    }

    public String sendUTT() throws Exception {
        StringWriter stringWriter = new StringWriter();
        this.utt.toJSON(stringWriter);
        return ((Object)stringWriter).toString();
    }

    public Response reset() throws Exception {
        this.ai1.reset();
        this.ai2.reset();
        this.pgs = PhysicalGameState.load(this.mapPath, this.utt);
        this.gs = new GameState(this.pgs, this.utt);
        return new Response(this.ai1.getObservation(0, this.gs), new double[this.rfs.length], new boolean[this.rfs.length], "{}");
    }

    public void close() throws Exception {
        if (this.w != null) {
            this.w.dispose();
        }
    }

    public class Response {
        public int[][][] observation;
        public double[] reward;
        public boolean[] done;
        public String info;

        public Response(int[][][] nArray, double[] dArray, boolean[] blArray, String string) {
            this.observation = nArray;
            this.reward = dArray;
            this.done = blArray;
            this.info = string;
        }
    }
}

